/*
 * Decompiled with CFR 0.152.
 */
package siena.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import siena.ClassInfo;
import siena.PersistenceManager;
import siena.Query;
import siena.Util;
import siena.core.Many;
import siena.core.Many4PM;
import siena.core.Relation;
import siena.core.RelationMode;
import siena.core.SyncList;

public class BaseMany<T>
implements Many4PM<T> {
    private static final transient long serialVersionUID = -1417704952199421178L;
    protected transient PersistenceManager pm;
    protected transient Class<T> clazz;
    protected Relation relation;
    protected transient ProxyList<T> list;
    protected transient Query<T> query;

    public BaseMany(PersistenceManager pm, Class<T> clazz) {
        this.pm = pm;
        this.clazz = clazz;
        this.list = new ProxyList(this);
        this.query = pm.createQuery(clazz);
    }

    public BaseMany(PersistenceManager pm, Class<T> clazz, RelationMode mode, Object obj, String fieldName) {
        this.pm = pm;
        this.clazz = clazz;
        this.list = new ProxyList(this);
        switch (mode) {
            case AGGREGATION: {
                this.relation = new Relation(mode, obj, fieldName);
                this.query = pm.createQuery(clazz).aggregated(obj, fieldName);
                break;
            }
            case RELATION: {
                this.query = pm.createQuery(clazz).filter(fieldName, obj);
            }
        }
        this.query = pm.createQuery(clazz);
    }

    @Override
    public SyncList<T> asList() {
        return this.list.sync();
    }

    @Override
    public Query<T> asQuery() {
        return this.query;
    }

    @Override
    public Many4PM<T> setSync(boolean isSync) {
        this.list.isSync = isSync;
        return this;
    }

    @Override
    public List<T> asList2Remove() {
        return this.list.elements2Remove;
    }

    @Override
    public List<T> asList2Add() {
        return this.list.elements2Add;
    }

    @Override
    public Many4PM<T> aggregationMode(Object aggregator, Field field) {
        if (this.relation == null) {
            this.relation = new Relation(RelationMode.AGGREGATION, aggregator, field);
        } else {
            this.relation.mode = RelationMode.AGGREGATION;
            this.relation.target = aggregator;
            this.relation.discriminator = field;
        }
        this.query.resetData().aggregated(aggregator, ClassInfo.getSimplestColumnName(field));
        return this;
    }

    @Override
    public Many4PM<T> relationMode(Object owner, Field field) {
        this.query.resetData().filter(ClassInfo.getSimplestColumnName(field), owner);
        return this;
    }

    protected class ProxyList<V>
    implements SyncList<V> {
        protected transient Many<V> many;
        protected transient List<V> elements;
        protected transient List<V> elements2Remove;
        protected transient List<V> elements2Add;
        protected transient boolean isSync = true;

        public ProxyList(BaseMany<V> many) {
            this.many = many;
            this.elements = new ArrayList<V>();
            this.elements2Remove = new ArrayList<V>();
            this.elements2Add = new ArrayList<V>();
        }

        @Override
        public boolean add(V e) {
            if (BaseMany.this.relation != null && BaseMany.this.relation.mode == RelationMode.AGGREGATION) {
                Util.setField(e, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, BaseMany.this.relation);
            }
            this.elements2Add.add(e);
            return this.elements.add(e);
        }

        @Override
        public void add(int index, V element) {
            if (BaseMany.this.relation != null && BaseMany.this.relation.mode == RelationMode.AGGREGATION) {
                Util.setField(element, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, BaseMany.this.relation);
            }
            this.elements2Add.add(element);
            this.elements.add(index, element);
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            if (BaseMany.this.relation != null && BaseMany.this.relation.mode == RelationMode.AGGREGATION) {
                for (V o : c) {
                    Util.setField(o, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, BaseMany.this.relation);
                }
            }
            this.elements2Add.addAll(c);
            return this.elements.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends V> c) {
            if (BaseMany.this.relation != null && BaseMany.this.relation.mode == RelationMode.AGGREGATION) {
                for (V o : c) {
                    Util.setField(o, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, BaseMany.this.relation);
                }
            }
            this.elements2Add.addAll(c);
            return this.elements.addAll(index, c);
        }

        @Override
        public <F extends V> boolean addAll(F ... c) {
            if (BaseMany.this.relation != null && BaseMany.this.relation.mode == RelationMode.AGGREGATION) {
                F[] FArray = c;
                int n = c.length;
                int n2 = 0;
                while (n2 < n) {
                    F o = FArray[n2];
                    Util.setField(o, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, BaseMany.this.relation);
                    ++n2;
                }
            }
            List<F> l = Arrays.asList(c);
            this.elements2Add.addAll(l);
            return this.elements.addAll(l);
        }

        @Override
        public <F extends V> boolean addAll(int index, F ... c) {
            if (BaseMany.this.relation != null && BaseMany.this.relation.mode == RelationMode.AGGREGATION) {
                F[] FArray = c;
                int n = c.length;
                int n2 = 0;
                while (n2 < n) {
                    F o = FArray[n2];
                    Util.setField(o, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, BaseMany.this.relation);
                    ++n2;
                }
            }
            List<F> l = Arrays.asList(c);
            this.elements2Add.addAll(l);
            return this.elements.addAll(index, l);
        }

        @Override
        public void clear() {
            this.elements2Add.clear();
            this.elements2Remove.addAll(this.elements);
            this.elements.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.elements.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.elements.containsAll(c);
        }

        @Override
        public V get(int index) {
            return this.elements.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.elements.indexOf(o);
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return this.elements.iterator();
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.elements.lastIndexOf(o);
        }

        @Override
        public ListIterator<V> listIterator() {
            return this.elements.listIterator();
        }

        @Override
        public ListIterator<V> listIterator(int index) {
            return this.elements.listIterator(index);
        }

        @Override
        public boolean remove(Object o) {
            this.elements2Remove.add(o);
            return this.elements.remove(o);
        }

        @Override
        public V remove(int index) {
            V o = this.elements.remove(index);
            if (BaseMany.this.relation != null && BaseMany.this.relation.mode == RelationMode.AGGREGATION) {
                Util.setField(o, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, null);
            }
            this.elements2Remove.add(o);
            return o;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.elements2Remove.addAll(c);
            if (BaseMany.this.relation != null && BaseMany.this.relation.mode == RelationMode.AGGREGATION) {
                for (Object o : c) {
                    Util.setField(o, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, null);
                }
            }
            return this.elements.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.elements.retainAll(c);
        }

        @Override
        public V set(int index, V element) {
            Util.setField(element, ClassInfo.getClassInfo(BaseMany.this.clazz).aggregator, null);
            return this.elements.set(index, element);
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            return this.elements.subList(fromIndex, toIndex);
        }

        @Override
        public Object[] toArray() {
            return this.elements.toArray();
        }

        @Override
        public <Z> Z[] toArray(Z[] a) {
            return this.elements.toArray(a);
        }

        @Override
        public SyncList<V> sync() {
            if (!this.isSync) {
                return this.forceSync();
            }
            return this;
        }

        @Override
        public SyncList<V> forceSync() {
            this.elements = this.many.asQuery().fetch();
            this.elements2Remove.clear();
            this.elements2Add.clear();
            this.isSync = true;
            return this;
        }
    }
}

