/*
 * Decompiled with CFR 0.152.
 */
package siena.sdb;

import com.google.appengine.api.datastore.PreparedQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import siena.core.options.QueryOption;
import siena.embed.EmbeddedMap;

@EmbeddedMap
public class QueryOptionSdbContext
extends QueryOption {
    public static final int ID = 12289;
    public List<String> tokens = new ArrayList<String>();
    public List<Integer> tokenOffsets = new ArrayList<Integer>();
    public int tokenIdx = -1;
    public boolean useToken = true;
    public boolean noMoreDataBefore = false;
    public boolean noMoreDataAfter = false;
    public int realPageSize = 0;
    public int realOffset = 0;

    public QueryOptionSdbContext() {
        super(12289);
    }

    public QueryOptionSdbContext(PreparedQuery query) {
        super(12289);
    }

    public QueryOptionSdbContext(QueryOptionSdbContext option) {
        super(option);
        Collections.copy(this.tokens, option.tokens);
        Collections.copy(this.tokenOffsets, option.tokenOffsets);
        this.tokenIdx = option.tokenIdx;
        this.useToken = option.useToken;
        this.noMoreDataBefore = option.noMoreDataBefore;
        this.noMoreDataAfter = option.noMoreDataAfter;
        this.realPageSize = option.realPageSize;
        this.realOffset = option.realOffset;
    }

    public void addToken(String token, int offset) {
        if (this.tokenIdx < this.tokens.size() - 1 && this.tokenIdx >= 0) {
            this.tokens.set(this.tokenIdx + 1, token);
            this.tokenOffsets.set(this.tokenIdx + 1, offset);
        } else {
            this.tokens.add(this.tokenIdx + 1, token);
            this.tokenOffsets.add(this.tokenIdx + 1, offset);
        }
    }

    public void addAndMoveToken(String token, int offset) {
        if (this.tokenIdx < this.tokens.size() - 1 && this.tokenIdx >= 0) {
            this.tokens.set(++this.tokenIdx, token);
            this.tokenOffsets.set(this.tokenIdx, offset);
        } else {
            this.tokens.add(token);
            this.tokenOffsets.add(offset);
            ++this.tokenIdx;
        }
    }

    public void setCurrentToken(String token, int offset) {
        if (this.tokenIdx != -1) {
            this.tokens.set(this.tokenIdx, token);
        } else {
            this.addAndMoveToken(token, offset);
        }
    }

    public String currentToken() {
        if (this.tokenIdx != -1 && this.tokenIdx != this.tokens.size()) {
            return this.tokens.get(this.tokenIdx);
        }
        return null;
    }

    public int currentTokenOffset() {
        if (this.tokenIdx != -1 && this.tokenIdx != this.tokens.size()) {
            return this.tokenOffsets.get(this.tokenIdx);
        }
        return 0;
    }

    public String nextToken() {
        int sz = this.tokens.size();
        if (sz == 0) {
            return null;
        }
        if (this.tokenIdx < sz - 1) {
            return this.tokens.get(++this.tokenIdx);
        }
        this.tokenIdx = sz;
        return null;
    }

    public boolean hasToken() {
        int sz = this.tokens.size();
        return sz != 0;
    }

    public boolean hasNextToken() {
        int sz = this.tokens.size();
        if (sz == 0) {
            return false;
        }
        return this.tokenIdx < sz - 1;
    }

    public String previousToken() {
        int sz = this.tokens.size();
        if (sz == 0) {
            return null;
        }
        if (this.tokenIdx > 0) {
            return this.tokens.get(--this.tokenIdx);
        }
        if (this.tokenIdx == 0) {
            this.tokenIdx = -1;
            return null;
        }
        return null;
    }

    public void resetAll() {
        this.tokenIdx = -1;
        this.realPageSize = 0;
        this.realOffset = 0;
        this.tokens.clear();
        this.tokenOffsets.clear();
    }

    public void reset(boolean recursing) {
        if (!recursing) {
            this.tokenIdx = -1;
            this.realPageSize = 0;
            this.realOffset = 0;
            this.tokens.clear();
            this.tokenOffsets.clear();
        } else {
            if (!this.hasToken()) {
                this.tokenIdx = -1;
            }
            this.realPageSize = 0;
            this.realOffset = 0;
        }
    }

    @Override
    public QueryOption clone() {
        return new QueryOptionSdbContext(this);
    }

    @Override
    public String toString() {
        return "type:SDB_CONTEXT - state:" + (Object)((Object)this.state) + " - realPageSize:" + this.realPageSize + " - useToken:" + this.useToken + " - tokenIdx:" + this.tokenIdx + " - tokens:" + this.tokens;
    }
}

