/*
 * Decompiled with CFR 0.152.
 */
package play.modules.jqvalidate;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.data.validation.Email;
import play.data.validation.Equals;
import play.data.validation.InFuture;
import play.data.validation.InPast;
import play.data.validation.Match;
import play.data.validation.Max;
import play.data.validation.MaxSize;
import play.data.validation.Min;
import play.data.validation.MinSize;
import play.data.validation.Range;
import play.data.validation.Required;
import play.data.validation.URL;
import play.modules.jqvalidate.singleton.MapSingleton;
import play.vfs.VirtualFile;
import siena.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartUp
extends PlayPlugin {
    public void onApplicationStart() {
        Logger.info((String)"Jqvalidation startup plugin Started", (Object[])new Object[0]);
        if (Play.mode == Play.Mode.DEV) {
            MapSingleton.setClassFieldValidation(null);
        }
        if (MapSingleton.getClassFieldValidation() != null) {
            return;
        }
        HashMap<String, Map<String, String>> classFieldValidation = new HashMap<String, Map<String, String>>();
        try {
            RandomAccessFile validationRulesFile = StartUp.prepareValidationEngineRules();
            List classes = Play.classloader.getAnnotatedClasses(Entity.class);
            classes.addAll(this.getSienaModels());
            Logger.info((String)"Siena Classes are %s", (Object[])new Object[]{this.getSienaModels()});
            for (Class c : classes) {
                Map<String, String> fieldsValidation = StartUp.getClassFields(c, validationRulesFile);
                if (fieldsValidation.isEmpty()) continue;
                classFieldValidation.put(c.getSimpleName(), fieldsValidation);
            }
            String jsEnd = "\n};}};$.validationEngineLanguage.newLang();})(jQuery);";
            validationRulesFile.writeBytes(jsEnd);
            validationRulesFile.getChannel().truncate(validationRulesFile.getChannel().position());
            validationRulesFile.close();
        }
        catch (ClassNotFoundException e) {
            Logger.error((Throwable)e, (String)"", (Object[])new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.error((Throwable)e, (String)"", (Object[])new Object[0]);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Logger.error((Throwable)e, (String)"", (Object[])new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error((Throwable)e, (String)"", (Object[])new Object[0]);
        }
        MapSingleton.setClassFieldValidation(classFieldValidation);
        Logger.info((String)"Jqvalidation startup plugin Finished\n%s", (Object[])new Object[]{MapSingleton.getClassFieldValidation()});
    }

    private static Map<String, String> getClassFields(Class<?> c, RandomAccessFile validationRulesFile) {
        Field[] fields;
        HashMap<String, String> fieldValidation = new HashMap<String, String>();
        for (Field field : fields = c.getFields()) {
            String validationString = StartUp.getFieldValidation(c.getSimpleName(), field, validationRulesFile);
            if (validationString.isEmpty()) continue;
            fieldValidation.put(field.getName(), validationString);
        }
        return fieldValidation;
    }

    private static String getFieldValidation(String className, Field field, RandomAccessFile validationRulesFile) {
        InFuture inFuture = field.getAnnotation(InFuture.class);
        Equals equals = field.getAnnotation(Equals.class);
        InPast inPast = field.getAnnotation(InPast.class);
        Match match = field.getAnnotation(Match.class);
        Max max = field.getAnnotation(Max.class);
        MaxSize maxSize = field.getAnnotation(MaxSize.class);
        Min min = field.getAnnotation(Min.class);
        MinSize minSize = field.getAnnotation(MinSize.class);
        Required required = field.getAnnotation(Required.class);
        URL url = field.getAnnotation(URL.class);
        Email email = field.getAnnotation(Email.class);
        Range range = field.getAnnotation(Range.class);
        StringBuffer validation = new StringBuffer();
        if (inFuture != null) {
            validation.append("future[");
            if (inFuture.value().trim().isEmpty()) {
                validation.append("NOW");
            } else {
                validation.append(inFuture.value().trim());
            }
            validation.append("],");
            StartUp.addErrorMessage(validation, inFuture.message());
        }
        if (equals != null && !equals.value().trim().isEmpty()) {
            validation.append(",equals[");
            validation.append(equals.value());
            validation.append("],");
            StartUp.addErrorMessage(validation, equals.message());
        }
        if (inPast != null) {
            validation.append(",past[");
            if (inPast.value().trim().isEmpty()) {
                validation.append("NOW");
            } else {
                validation.append(inPast.value().trim());
            }
            validation.append("],");
            StartUp.addErrorMessage(validation, inPast.message());
        }
        if (match != null && !match.value().isEmpty()) {
            StartUp.addValidationRule(className, field.getName(), validationRulesFile, match.value(), match.message());
            validation.append(",custom[");
            validation.append(className);
            validation.append(".");
            validation.append(field.getName());
            validation.append("]");
        }
        if (max != null) {
            validation.append(",max[");
            validation.append(max.value());
            validation.append("],");
            StartUp.addErrorMessage(validation, max.message());
        }
        if (maxSize != null) {
            validation.append(",maxSize[");
            validation.append(maxSize.value());
            validation.append("],");
            StartUp.addErrorMessage(validation, maxSize.message());
        }
        if (min != null) {
            validation.append(",min[");
            validation.append(min.value());
            validation.append("],");
            StartUp.addErrorMessage(validation, min.message());
        }
        if (minSize != null) {
            validation.append(",minSize[");
            validation.append(minSize.value());
            validation.append("],");
            StartUp.addErrorMessage(validation, minSize.message());
        }
        if (required != null) {
            validation.append(",required,");
            StartUp.addErrorMessage(validation, required.message());
        }
        if (url != null) {
            validation.append(",custom[url],");
            StartUp.addErrorMessage(validation, url.message());
        }
        if (email != null) {
            validation.append(",custom[email],");
            StartUp.addErrorMessage(validation, email.message());
        }
        if (range != null) {
            validation.append(",range[");
            validation.append(range.min());
            validation.append(",");
            validation.append(range.max());
            validation.append("],");
            StartUp.addErrorMessage(validation, range.message());
        }
        return validation.toString();
    }

    private static void addErrorMessage(StringBuffer validation, String errorMsg) {
        if (!errorMsg.trim().isEmpty()) {
            validation.append("msg:");
            validation.append(errorMsg);
        }
    }

    private static void addValidationRule(String className, String fieldName, RandomAccessFile validationRulesFile, String regex, String msg) {
        String RULE_TEMPLATE = ",\n                \"%s.%s\": {\n                    \"regex\":/%s/,\n                    \"alertText\":\"*%s\"                \n}";
        String rule = null;
        try {
            rule = String.format(",\n                \"%s.%s\": {\n                    \"regex\":/%s/,\n                    \"alertText\":\"*%s\"                \n}", className, fieldName, regex, msg);
            validationRulesFile.writeBytes(rule);
        }
        catch (IOException e) {
            try {
                validationRulesFile.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        catch (Exception e) {
            Logger.warn((String)"can't write to validation file", (Object[])new Object[0]);
        }
    }

    private static RandomAccessFile prepareValidationEngineRules() throws Exception {
        Logger.info((String)"Started to read the validation rules file", (Object[])new Object[0]);
        File file = new File(((VirtualFile)Play.modules.get("jqvalidation")).getRealFile().getAbsolutePath(), "public/javascripts/jquery.validationEngine-en.js");
        RandomAccessFile validationRules = null;
        try {
            validationRules = new RandomAccessFile(file, "rwd");
            String line = "";
            while ((line = validationRules.readLine()) != null && !line.endsWith("}")) {
            }
            Logger.info((String)"Created a Pointer to the append after the last pre-defined rule", (Object[])new Object[0]);
        }
        catch (IOException e) {
            try {
                if (validationRules != null) {
                    validationRules.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                Logger.error((Throwable)e1, (String)"", (Object[])new Object[0]);
            }
            e.printStackTrace();
            Logger.error((Throwable)e, (String)"", (Object[])new Object[0]);
            return null;
        }
        catch (Exception e) {
            Logger.warn((Throwable)e, (String)"", (Object[])new Object[0]);
            return null;
        }
        return validationRules;
    }

    public List<Class<Model>> getSienaModels() {
        ArrayList<Class<Model>> classes = new ArrayList<Class<Model>>();
        List allClasses = Play.classloader.getAllClasses();
        for (Class c : allClasses) {
            if (!this.isSienaModel(c)) continue;
            classes.add(c);
        }
        return classes;
    }

    public boolean isSienaModel(Class c) {
        for (Class superClass = c.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (superClass.equals(Model.class)) {
                return true;
            }
            if (!superClass.equals(Object.class)) continue;
            return false;
        }
        return false;
    }
}

