package models;

import java.util.Date;

import javax.persistence.Entity;

import play.data.validation.Email;
import play.data.validation.InPast;
import play.data.validation.Match;
import play.data.validation.MaxSize;
import play.data.validation.MinSize;
import play.data.validation.Required;
import play.db.jpa.Model;

@Entity
public class User extends Model {
	/**
	 * 
	 */
	private static final long serialVersionUID = -1397242695765843990L;

	@Required
	@MaxSize(value = 20)
	@Match(value = "^[0-9a-zA-Z]+$",message="Only Letters and Numbers")
	public String firstName;
	
	@Required
	@Match(value = "^[0-9a-zA-Z]+$", message="Only Letters and Numbers")
	@MaxSize(value = 20)
	public String lastName;
	
	@MaxSize(value = 100)
	public String address;
	
	@Match(value = "^[0-9\\ ]+$", message="Only Numbers and spaces")
	public String phoneNum;
	
	@Required
	@InPast
	public Date dateOfBirth;
	
	@Required
	@MinSize(value = 10)
	public String password;
	
	@Required
	@Email
	public String email;
	/**
	 * If true then he's male, otherwise she's female.
	 */
	public boolean gender;

	public User(String firstName, String lastName, String address,
			String phoneNum, String password, String email, Date dateOfBirth,boolean gender) {
		this.firstName = firstName;
		this.lastName = lastName;
		this.address = address;
		this.phoneNum = phoneNum;
		this.password = password;
		this.email = email;
		this.dateOfBirth = dateOfBirth;
		this.gender = gender;
	}
}
