/*
 * Decompiled with CFR 0.152.
 */
package play.modules.less;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.mozilla.javascript.WrappedException;
import play.Logger;

public class PlayLessEngine {
    LessEngine lessEngine = new LessEngine();
    Boolean devMode;

    PlayLessEngine(Boolean devMode) {
        this.devMode = devMode;
    }

    public String compile(File lessFile) {
        try {
            return this.lessEngine.compile(lessFile);
        }
        catch (LessException e) {
            return this.handleException(lessFile, e);
        }
    }

    public String handleException(File lessFile, LessException e) {
        WrappedException we;
        Logger.warn((Throwable)e, (String)"Less exception", (Object[])new Object[0]);
        String filename = e.getFilename();
        List extractList = e.getExtract();
        String extract = null;
        if (extractList != null) {
            extract = extractList.toString();
        }
        if (filename == null) {
            filename = lessFile.getName();
        }
        if (extract == null && e.getCause() instanceof WrappedException && (we = (WrappedException)e.getCause()).getCause() instanceof FileNotFoundException) {
            FileNotFoundException fnfe = (FileNotFoundException)we.getCause();
            extract = fnfe.getMessage();
        }
        return this.formatMessage(filename, e.getLine(), e.getColumn(), extract, e.getErrorType());
    }

    public String formatMessage(String filename, int line, int column, String extract, String errorType) {
        return "body:before {display: block; color: #c00; white-space: pre; font-family: monospace; background: #FDD9E1; border-top: 1px solid pink; border-bottom: 1px solid pink; padding: 10px; content: \"[LESS ERROR] " + String.format("%s:%s: %s (%s)", filename, line, extract, errorType) + "\"; }";
    }
}

