/*
 * Decompiled with CFR 0.152.
 */
package play.modules.less;

import java.io.PrintStream;
import play.Play;
import play.PlayPlugin;
import play.modules.less.PlayLessEngine;
import play.mvc.Http;
import play.vfs.VirtualFile;

public class Plugin
extends PlayPlugin {
    PlayLessEngine playLessEngine;

    public void onLoad() {
        this.playLessEngine = new PlayLessEngine(Play.mode == Play.Mode.DEV);
    }

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        if (file.getName().endsWith(".less")) {
            response.contentType = "text/css";
            try {
                String css = this.playLessEngine.compile(file.getRealFile());
                response.status = 200;
                if (Play.mode == Play.Mode.PROD) {
                    response.cacheFor(Play.configuration.getProperty("http.cacheControl", "3600") + "s");
                }
                response.print((Object)css);
            }
            catch (Exception e) {
                response.status = 500;
                response.print((Object)"Bugger, the LESS processing failed:,\n");
                e.printStackTrace(new PrintStream(response.out));
            }
            return true;
        }
        return super.serveStatic(file, request, response);
    }
}

