/*
 * Decompiled with CFR 0.152.
 */
package compat16.org.mozilla.javascript.optimizer;

import compat16.org.mozilla.classfile.ClassFileWriter;
import compat16.org.mozilla.javascript.CompilerEnvirons;
import compat16.org.mozilla.javascript.Context;
import compat16.org.mozilla.javascript.Kit;
import compat16.org.mozilla.javascript.Node;
import compat16.org.mozilla.javascript.ScriptOrFnNode;
import compat16.org.mozilla.javascript.optimizer.Codegen;
import compat16.org.mozilla.javascript.optimizer.OptFunctionNode;
import compat16.org.mozilla.javascript.optimizer.OptRuntime;

class BodyCodegen {
    private static final int JAVASCRIPT_EXCEPTION = 0;
    private static final int EVALUATOR_EXCEPTION = 1;
    private static final int ECMAERROR_EXCEPTION = 2;
    ClassFileWriter cfw;
    Codegen codegen;
    CompilerEnvirons compilerEnv;
    ScriptOrFnNode scriptOrFn;
    private OptFunctionNode fnCurrent;
    private boolean isTopLevel;
    private static final int MAX_LOCALS = 256;
    private boolean[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private int itsLineNumber;
    private boolean hasVarsInRegs;
    private short[] varRegisters;
    private boolean inDirectCallFunction;
    private boolean itsForcedObjectParameters;
    private int enterAreaStartLabel;
    private int epilogueLabel;
    private short variableObjectLocal;
    private short popvLocal;
    private short contextLocal;
    private short argsLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private short scriptRegexpLocal;

    BodyCodegen() {
    }

    void generateBodyCode() {
        this.initBodyGeneration();
        this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        this.generatePrologue();
        Node treeTop = this.fnCurrent != null ? this.scriptOrFn.getLastChild() : this.scriptOrFn;
        this.generateStatement(treeTop);
        this.generateEpilogue();
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void initBodyGeneration() {
        this.isTopLevel = this.scriptOrFn == this.codegen.scriptOrFnNodes[0];
        this.varRegisters = null;
        if (this.scriptOrFn.getType() == 105) {
            int n;
            this.fnCurrent = OptFunctionNode.get(this.scriptOrFn);
            boolean bl = this.hasVarsInRegs = !this.fnCurrent.fnode.requiresActivation();
            if (this.hasVarsInRegs && (n = this.fnCurrent.fnode.getParamAndVarCount()) != 0) {
                this.varRegisters = new short[n];
            }
            this.inDirectCallFunction = this.fnCurrent.isTargetOfDirectCall();
            if (this.inDirectCallFunction && !this.hasVarsInRegs) {
                Codegen.badTree();
            }
        } else {
            this.fnCurrent = null;
            this.hasVarsInRegs = false;
            this.inDirectCallFunction = false;
        }
        this.locals = new boolean[256];
        this.funObjLocal = 0;
        this.contextLocal = 1;
        this.variableObjectLocal = (short)2;
        this.thisObjLocal = (short)3;
        this.localsMax = (short)4;
        this.firstFreeLocal = (short)4;
        this.popvLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        this.scriptRegexpLocal = (short)-1;
        this.epilogueLabel = -1;
        this.enterAreaStartLabel = -1;
    }

    private void generatePrologue() {
        String debugVariableName;
        if (this.inDirectCallFunction) {
            int i;
            int directParameterCount = this.scriptOrFn.getParamCount();
            if (this.firstFreeLocal != 4) {
                Kit.codeBug();
            }
            for (i = 0; i != directParameterCount; ++i) {
                this.varRegisters[i] = this.firstFreeLocal;
                this.firstFreeLocal = (short)(this.firstFreeLocal + 3);
            }
            if (!this.fnCurrent.getParameterNumberContext()) {
                this.itsForcedObjectParameters = true;
                for (i = 0; i != directParameterCount; ++i) {
                    short reg = this.varRegisters[i];
                    this.cfw.addALoad(reg);
                    this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int isObjectLabel = this.cfw.acquireLabel();
                    this.cfw.add(166, isObjectLabel);
                    this.cfw.addDLoad(reg + 1);
                    this.addDoubleWrap();
                    this.cfw.addAStore(reg);
                    this.cfw.markLabel(isObjectLabel);
                }
            }
        }
        if (!(this.fnCurrent == null || this.inDirectCallFunction || this.compilerEnv.isUseDynamicScope() && !this.fnCurrent.fnode.getIgnoreDynamicScope())) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "compat16/org/mozilla/javascript/Scriptable", "getParentScope", "()Lcompat16/org/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        if (this.fnCurrent == null && this.scriptOrFn.getRegexpCount() != 0) {
            this.scriptRegexpLocal = this.getNewWordLocal();
            this.codegen.pushRegExpArray(this.cfw, this.scriptOrFn, this.contextLocal, this.variableObjectLocal);
            this.cfw.addAStore(this.scriptRegexpLocal);
        }
        if (this.hasVarsInRegs) {
            int parmCount = this.scriptOrFn.getParamCount();
            if (parmCount > 0 && !this.inDirectCallFunction) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.add(190);
                this.cfw.addPush(parmCount);
                int label = this.cfw.acquireLabel();
                this.cfw.add(162, label);
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(parmCount);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
                this.cfw.addAStore(this.argsLocal);
                this.cfw.markLabel(label);
            }
            int paramCount = this.fnCurrent.fnode.getParamCount();
            int varCount = this.fnCurrent.fnode.getParamAndVarCount();
            boolean[] constDeclarations = this.fnCurrent.fnode.getParamAndVarConst();
            int firstUndefVar = -1;
            for (int i = 0; i != varCount; ++i) {
                int reg = -1;
                if (i < paramCount) {
                    if (!this.inDirectCallFunction) {
                        reg = this.getNewWordLocal();
                        this.cfw.addALoad(this.argsLocal);
                        this.cfw.addPush(i);
                        this.cfw.add(50);
                        this.cfw.addAStore(reg);
                    }
                } else if (this.fnCurrent.isNumberVar(i)) {
                    reg = this.getNewWordPairLocal(constDeclarations[i]);
                    this.cfw.addPush(0.0);
                    this.cfw.addDStore(reg);
                } else {
                    reg = this.getNewWordLocal(constDeclarations[i]);
                    if (firstUndefVar == -1) {
                        Codegen.pushUndefined(this.cfw);
                        firstUndefVar = reg;
                    } else {
                        this.cfw.addALoad(firstUndefVar);
                    }
                    this.cfw.addAStore(reg);
                }
                if (reg >= 0) {
                    if (constDeclarations[i]) {
                        this.cfw.addPush(0);
                        this.cfw.addIStore(reg + (this.fnCurrent.isNumberVar(i) ? 2 : 1));
                    }
                    this.varRegisters[i] = reg;
                }
                if (!this.compilerEnv.isGenerateDebugInfo()) continue;
                String name = this.fnCurrent.fnode.getParamOrVarName(i);
                String type = this.fnCurrent.isNumberVar(i) ? "D" : "Ljava/lang/Object;";
                int startPC = this.cfw.getCurrentCodeOffset();
                if (reg < 0) {
                    reg = this.varRegisters[i];
                }
                this.cfw.addVariableDescriptor(name, type, startPC, reg);
            }
            return;
        }
        if (this.fnCurrent != null) {
            debugVariableName = "activation";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.argsLocal);
            this.addScriptRuntimeInvoke("createFunctionActivation", "(Lcompat16/org/mozilla/javascript/NativeFunction;Lcompat16/org/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lcompat16/org/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("enterActivationFunction", "(Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)V");
        } else {
            debugVariableName = "global";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(0);
            this.addScriptRuntimeInvoke("initScript", "(Lcompat16/org/mozilla/javascript/NativeFunction;Lcompat16/org/mozilla/javascript/Scriptable;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;Z)V");
        }
        this.enterAreaStartLabel = this.cfw.acquireLabel();
        this.epilogueLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(this.enterAreaStartLabel);
        int functionCount = this.scriptOrFn.getFunctionCount();
        for (int i = 0; i != functionCount; ++i) {
            OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, i);
            if (ofn.fnode.getFunctionType() != 1) continue;
            this.visitFunction(ofn, 1);
        }
        if (this.compilerEnv.isGenerateDebugInfo()) {
            this.cfw.addVariableDescriptor(debugVariableName, "Lcompat16/org/mozilla/javascript/Scriptable;", this.cfw.getCurrentCodeOffset(), this.variableObjectLocal);
        }
        if (this.fnCurrent == null) {
            this.popvLocal = this.getNewWordLocal();
            Codegen.pushUndefined(this.cfw);
            this.cfw.addAStore(this.popvLocal);
            int linenum = this.scriptOrFn.getEndLineno();
            if (linenum != -1) {
                this.cfw.addLineNumberEntry((short)linenum);
            }
        } else {
            if (this.fnCurrent.itsContainsCalls0) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.cfw.add(178, "compat16/org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.cfw.addAStore(this.itsZeroArgArray);
            }
            if (this.fnCurrent.itsContainsCalls1) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.cfw.addPush(1);
                this.cfw.add(189, "java/lang/Object");
                this.cfw.addAStore(this.itsOneArgArray);
            }
        }
    }

    private void generateEpilogue() {
        if (this.hasVarsInRegs) {
            if (this.epilogueLabel != -1) {
                this.cfw.markLabel(this.epilogueLabel);
            }
            this.cfw.add(176);
            return;
        }
        this.cfw.markLabel(this.epilogueLabel);
        if (this.fnCurrent == null) {
            this.cfw.addALoad(this.popvLocal);
            this.cfw.add(176);
        } else {
            this.generateActivationExit();
            this.cfw.add(176);
            int finallyHandler = this.cfw.acquireLabel();
            this.cfw.markHandler(finallyHandler);
            short exceptionObject = this.getNewWordLocal();
            this.cfw.addAStore(exceptionObject);
            this.generateActivationExit();
            this.cfw.addALoad(exceptionObject);
            this.releaseWordLocal(exceptionObject);
            this.cfw.add(191);
            this.cfw.addExceptionHandler(this.enterAreaStartLabel, this.epilogueLabel, finallyHandler, null);
        }
    }

    private void generateActivationExit() {
        if (this.fnCurrent == null || this.hasVarsInRegs) {
            throw Kit.codeBug();
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("exitActivationFunction", "(Lcompat16/org/mozilla/javascript/Context;)V");
    }

    private void generateStatement(Node node) {
        this.updateLineNumber(node);
        int type = node.getType();
        switch (type) {
            case 119: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 132: {
                Node child;
                for (child = node.getFirstChild(); child != null; child = child.getNext()) {
                    this.generateStatement(child);
                }
                break;
            }
            case 137: {
                Node child;
                short local = this.getNewWordLocal();
                node.putIntProp(2, local);
                while (child != null) {
                    this.generateStatement(child);
                    child = child.getNext();
                }
                this.releaseWordLocal(local);
                node.removeProp(2);
                break;
            }
            case 105: {
                int fnIndex = node.getExistingIntProp(1);
                OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, fnIndex);
                int t = ofn.fnode.getFunctionType();
                if (t == 3) {
                    this.visitFunction(ofn, t);
                    break;
                }
                if (t == 1) break;
                throw Codegen.badTree();
            }
            case 77: {
                Node child;
                this.visitTryCatchFinally((Node.Jump)node, child);
                break;
            }
            case 56: {
                Node child;
                int local = this.getLocalBlockRegister(node);
                int scopeIndex = node.getExistingIntProp(14);
                String name = child.getString();
                child = child.getNext();
                this.generateExpression(child, node);
                if (scopeIndex == 0) {
                    this.cfw.add(1);
                } else {
                    this.cfw.addALoad(local);
                }
                this.cfw.addPush(name);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("newCatchScope", "(Ljava/lang/Throwable;Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Lcompat16/org/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(local);
                break;
            }
            case 49: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.add(187, "compat16/org/mozilla/javascript/JavaScriptException");
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(this.scriptOrFn.getSourceName());
                this.cfw.addPush(this.itsLineNumber);
                this.cfw.addInvoke(183, "compat16/org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;Ljava/lang/String;I)V");
                this.cfw.add(191);
                break;
            }
            case 50: {
                this.cfw.addALoad(this.getLocalBlockRegister(node));
                this.cfw.add(191);
                break;
            }
            case 4: 
            case 62: {
                Node child;
                if (child != null) {
                    this.generateExpression(child, node);
                } else if (type == 4) {
                    Codegen.pushUndefined(this.cfw);
                } else {
                    if (this.popvLocal < 0) {
                        throw Codegen.badTree();
                    }
                    this.cfw.addALoad(this.popvLocal);
                }
                if (this.epilogueLabel == -1) {
                    if (!this.hasVarsInRegs) {
                        throw Codegen.badTree();
                    }
                    this.epilogueLabel = this.cfw.acquireLabel();
                }
                this.cfw.add(167, this.epilogueLabel);
                break;
            }
            case 110: {
                Node child;
                this.visitSwitch((Node.Jump)node, child);
                break;
            }
            case 2: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Lcompat16/org/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(this.variableObjectLocal);
                break;
            }
            case 3: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("leaveWith", "(Lcompat16/org/mozilla/javascript/Scriptable;)Lcompat16/org/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(this.variableObjectLocal);
                break;
            }
            case 57: 
            case 58: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(type == 58);
                this.addScriptRuntimeInvoke("enumInit", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Z)Ljava/lang/Object;");
                this.cfw.addAStore(this.getLocalBlockRegister(node));
                break;
            }
            case 129: {
                Node child;
                if (child.getType() == 55) {
                    this.visitSetVar(child, child.getFirstChild(), false);
                    break;
                }
                if (child.getType() == 151) {
                    this.visitSetConstVar(child, child.getFirstChild(), false);
                    break;
                }
                this.generateExpression(child, node);
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.add(88);
                    break;
                }
                this.cfw.add(87);
                break;
            }
            case 130: {
                Node child;
                this.generateExpression(child, node);
                if (this.popvLocal < 0) {
                    this.popvLocal = this.getNewWordLocal();
                }
                this.cfw.addAStore(this.popvLocal);
                break;
            }
            case 127: {
                int label = this.getTargetLabel(node);
                this.cfw.markLabel(label);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 131: {
                Node child;
                this.visitGOTO((Node.Jump)node, type, child);
                break;
            }
            case 121: {
                Node child;
                short finallyRegister = this.getNewWordLocal();
                this.cfw.addAStore(finallyRegister);
                while (child != null) {
                    this.generateStatement(child);
                    child = child.getNext();
                }
                this.cfw.add(169, finallyRegister);
                this.releaseWordLocal(finallyRegister);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
    }

    private void generateExpression(Node node, Node parent) {
        int type = node.getType();
        block0 : switch (type) {
            case 134: {
                break;
            }
            case 105: {
                if (this.fnCurrent == null && parent.getType() == 132) break;
                int fnIndex = node.getExistingIntProp(1);
                OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFn, fnIndex);
                int t = ofn.fnode.getFunctionType();
                if (t != 2) {
                    throw Codegen.badTree();
                }
                this.visitFunction(ofn, t);
                break;
            }
            case 38: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node.getString());
                this.addScriptRuntimeInvoke("name", "(Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
                break;
            }
            case 30: 
            case 37: {
                Node child;
                int specialType = node.getIntProp(10, 0);
                if (specialType == 0) {
                    OptFunctionNode target = (OptFunctionNode)node.getProp(9);
                    if (target != null) {
                        this.visitOptimizedCall(node, target, type, child);
                        break;
                    }
                    if (type == 37) {
                        this.visitStandardCall(node, child);
                        break;
                    }
                    this.visitStandardNew(node, child);
                    break;
                }
                this.visitSpecialCall(node, type, specialType, child);
                break;
            }
            case 68: {
                Node child;
                this.generateFunctionAndThisObj(child, node);
                child = child.getNext();
                this.generateCallArgArray(node, child, false);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("callRef", "(Lcompat16/org/mozilla/javascript/Callable;Lcompat16/org/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Lcompat16/org/mozilla/javascript/Ref;");
                break;
            }
            case 39: {
                double num = node.getDouble();
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.addPush(num);
                    break;
                }
                this.codegen.pushNumberAsObject(this.cfw, num);
                break;
            }
            case 40: {
                this.cfw.addPush(node.getString());
                break;
            }
            case 42: {
                this.cfw.addALoad(this.thisObjLocal);
                break;
            }
            case 61: {
                this.cfw.add(42);
                break;
            }
            case 41: {
                this.cfw.add(1);
                break;
            }
            case 44: {
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 43: {
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 47: {
                int i = node.getExistingIntProp(4);
                if (this.fnCurrent == null) {
                    this.cfw.addALoad(this.scriptRegexpLocal);
                } else {
                    this.cfw.addALoad(this.funObjLocal);
                    this.cfw.add(180, this.codegen.mainClassName, "_re", "[Ljava/lang/Object;");
                }
                this.cfw.addPush(i);
                this.cfw.add(50);
                break;
            }
            case 85: {
                Node child;
                for (Node next = child.getNext(); next != null; next = next.getNext()) {
                    this.generateExpression(child, node);
                    this.cfw.add(87);
                    child = next;
                }
                this.generateExpression(child, node);
                break;
            }
            case 59: 
            case 60: {
                int local = this.getLocalBlockRegister(node);
                this.cfw.addALoad(local);
                if (type == 59) {
                    this.addScriptRuntimeInvoke("enumNext", "(Ljava/lang/Object;)Ljava/lang/Boolean;");
                    break;
                }
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("enumId", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 63: {
                Node child;
                this.visitArrayLiteral(node, child);
                break;
            }
            case 64: {
                Node child;
                this.visitObjectLiteral(node, child);
                break;
            }
            case 26: {
                Node child;
                int trueTarget = this.cfw.acquireLabel();
                int falseTarget = this.cfw.acquireLabel();
                int beyond = this.cfw.acquireLabel();
                this.generateIfJump(child, node, trueTarget, falseTarget);
                this.cfw.markLabel(trueTarget);
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.cfw.add(167, beyond);
                this.cfw.markLabel(falseTarget);
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.cfw.markLabel(beyond);
                this.cfw.adjustStackTop(-1);
                break;
            }
            case 27: {
                Node child;
                this.generateExpression(child, node);
                this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
                this.cfw.addPush(-1);
                this.cfw.add(130);
                this.cfw.add(135);
                this.addDoubleWrap();
                break;
            }
            case 122: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.add(87);
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 32: {
                Node child;
                this.generateExpression(child, node);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                break;
            }
            case 133: {
                this.visitTypeofname(node);
                break;
            }
            case 102: 
            case 103: {
                this.visitIncDec(node);
                break;
            }
            case 100: 
            case 101: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.add(89);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int falseTarget = this.cfw.acquireLabel();
                if (type == 101) {
                    this.cfw.add(153, falseTarget);
                } else {
                    this.cfw.add(154, falseTarget);
                }
                this.cfw.add(87);
                this.generateExpression(child.getNext(), node);
                this.cfw.markLabel(falseTarget);
                break;
            }
            case 98: {
                Node child;
                Node ifThen = child.getNext();
                Node ifElse = ifThen.getNext();
                this.generateExpression(child, node);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int elseTarget = this.cfw.acquireLabel();
                this.cfw.add(153, elseTarget);
                short stack = this.cfw.getStackTop();
                this.generateExpression(ifThen, node);
                int afterHook = this.cfw.acquireLabel();
                this.cfw.add(167, afterHook);
                this.cfw.markLabel(elseTarget, stack);
                this.generateExpression(ifElse, node);
                this.cfw.markLabel(afterHook);
                break;
            }
            case 21: {
                Node child;
                this.generateExpression(child, node);
                this.generateExpression(child.getNext(), node);
                switch (node.getIntProp(8, -1)) {
                    case 0: {
                        this.cfw.add(99);
                        break block0;
                    }
                    case 1: {
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;)Ljava/lang/Object;");
                        break block0;
                    }
                    case 2: {
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;D)Ljava/lang/Object;");
                        break block0;
                    }
                }
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("add", "(Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 23: {
                Node child;
                this.visitArithmetic(node, 107, child, parent);
                break;
            }
            case 22: {
                Node child;
                this.visitArithmetic(node, 103, child, parent);
                break;
            }
            case 24: 
            case 25: {
                Node child;
                this.visitArithmetic(node, type == 24 ? 111 : 115, child, parent);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                Node child;
                this.visitBitOp(node, type, child);
                break;
            }
            case 28: 
            case 29: {
                Node child;
                this.generateExpression(child, node);
                this.addObjectToDouble();
                if (type == 29) {
                    this.cfw.add(119);
                }
                this.addDoubleWrap();
                break;
            }
            case 146: {
                Node child;
                this.generateExpression(child, node);
                this.addObjectToDouble();
                break;
            }
            case 145: {
                Node child;
                int prop = -1;
                if (child.getType() == 39) {
                    prop = child.getIntProp(8, -1);
                }
                if (prop != -1) {
                    child.removeProp(8);
                    this.generateExpression(child, node);
                    child.putIntProp(8, prop);
                    break;
                }
                this.generateExpression(child, node);
                this.addDoubleWrap();
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 51: 
            case 52: {
                Node child;
                int trueGOTO = this.cfw.acquireLabel();
                int falseGOTO = this.cfw.acquireLabel();
                this.visitIfJumpRelOp(node, child, trueGOTO, falseGOTO);
                this.addJumpedBooleanWrap(trueGOTO, falseGOTO);
                break;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                Node child;
                int trueGOTO = this.cfw.acquireLabel();
                int falseGOTO = this.cfw.acquireLabel();
                this.visitIfJumpEqOp(node, child, trueGOTO, falseGOTO);
                this.addJumpedBooleanWrap(trueGOTO, falseGOTO);
                break;
            }
            case 33: {
                Node child;
                this.visitGetProp(node, child);
                break;
            }
            case 35: {
                Node child;
                this.generateExpression(child, node);
                this.generateExpression(child.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                if (node.getIntProp(8, -1) != -1) {
                    this.addScriptRuntimeInvoke("getObjectIndex", "(Ljava/lang/Object;DLcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("getObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 65: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refGet", "(Lcompat16/org/mozilla/javascript/Ref;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 54: {
                this.visitGetVar(node);
                break;
            }
            case 55: {
                Node child;
                this.visitSetVar(node, child, true);
                break;
            }
            case 8: {
                Node child;
                this.visitSetName(node, child);
                break;
            }
            case 150: {
                Node child;
                this.visitSetConst(node, child);
                break;
            }
            case 151: {
                Node child;
                this.visitSetConstVar(node, child, true);
                break;
            }
            case 34: 
            case 135: {
                Node child;
                this.visitSetProp(type, node, child);
                break;
            }
            case 36: 
            case 136: {
                Node child;
                this.visitSetElem(type, node, child);
                break;
            }
            case 66: 
            case 138: {
                Node child;
                this.generateExpression(child, node);
                child = child.getNext();
                if (type == 138) {
                    this.cfw.add(89);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("refGet", "(Lcompat16/org/mozilla/javascript/Ref;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                }
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refSet", "(Lcompat16/org/mozilla/javascript/Ref;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 67: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refDel", "(Lcompat16/org/mozilla/javascript/Ref;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 31: {
                Node child;
                this.generateExpression(child, node);
                child = child.getNext();
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("delete", "(Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 48: {
                Node child;
                for (child = node.getFirstChild(); child != null; child = child.getNext()) {
                    this.generateExpression(child, node);
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node.getString());
                this.addScriptRuntimeInvoke("bind", "(Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/String;)Lcompat16/org/mozilla/javascript/Scriptable;");
                break;
            }
            case 53: {
                this.cfw.addALoad(this.getLocalBlockRegister(node));
                break;
            }
            case 69: {
                Node child;
                String special = (String)node.getProp(17);
                this.generateExpression(child, node);
                this.cfw.addPush(special);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("specialRef", "(Ljava/lang/Object;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;)Lcompat16/org/mozilla/javascript/Ref;");
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                String signature;
                String methodName;
                Node child;
                int memberTypeFlags = node.getIntProp(16, 0);
                do {
                    this.generateExpression(child, node);
                } while ((child = child.getNext()) != null);
                this.cfw.addALoad(this.contextLocal);
                switch (type) {
                    case 73: {
                        methodName = "memberRef";
                        signature = "(Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;I)Lcompat16/org/mozilla/javascript/Ref;";
                        break;
                    }
                    case 74: {
                        methodName = "memberRef";
                        signature = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;I)Lcompat16/org/mozilla/javascript/Ref;";
                        break;
                    }
                    case 75: {
                        methodName = "nameRef";
                        signature = "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;I)Lcompat16/org/mozilla/javascript/Ref;";
                        this.cfw.addALoad(this.variableObjectLocal);
                        break;
                    }
                    case 76: {
                        methodName = "nameRef";
                        signature = "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;I)Lcompat16/org/mozilla/javascript/Ref;";
                        this.cfw.addALoad(this.variableObjectLocal);
                        break;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
                this.cfw.addPush(memberTypeFlags);
                this.addScriptRuntimeInvoke(methodName, signature);
                break;
            }
            case 142: {
                Node child;
                this.visitDotQuery(node, child);
                break;
            }
            case 71: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("escapeAttributeValue", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/String;");
                break;
            }
            case 72: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("escapeTextValue", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/String;");
                break;
            }
            case 70: {
                Node child;
                this.generateExpression(child, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("setDefaultNamespace", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            default: {
                throw new RuntimeException("Unexpected node type " + type);
            }
        }
    }

    private void generateIfJump(Node node, Node parent, int trueLabel, int falseLabel) {
        int type = node.getType();
        Node child = node.getFirstChild();
        switch (type) {
            case 26: {
                this.generateIfJump(child, node, falseLabel, trueLabel);
                break;
            }
            case 100: 
            case 101: {
                int interLabel = this.cfw.acquireLabel();
                if (type == 101) {
                    this.generateIfJump(child, node, interLabel, falseLabel);
                } else {
                    this.generateIfJump(child, node, trueLabel, interLabel);
                }
                this.cfw.markLabel(interLabel);
                child = child.getNext();
                this.generateIfJump(child, node, trueLabel, falseLabel);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 51: 
            case 52: {
                this.visitIfJumpRelOp(node, child, trueLabel, falseLabel);
                break;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                this.visitIfJumpEqOp(node, child, trueLabel, falseLabel);
                break;
            }
            default: {
                this.generateExpression(node, parent);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                this.cfw.add(154, trueLabel);
                this.cfw.add(167, falseLabel);
            }
        }
    }

    private void visitFunction(OptFunctionNode ofn, int functionType) {
        int fnIndex = this.codegen.getIndex(ofn.fnode);
        this.cfw.add(187, this.codegen.mainClassName);
        this.cfw.add(89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(fnIndex);
        this.cfw.addInvoke(183, this.codegen.mainClassName, "<init>", "(Lcompat16/org/mozilla/javascript/Scriptable;Lcompat16/org/mozilla/javascript/Context;I)V");
        this.cfw.add(89);
        if (this.isTopLevel) {
            this.cfw.add(42);
        } else {
            this.cfw.add(42);
            this.cfw.add(180, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        }
        this.cfw.add(181, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        int directTargetIndex = ofn.getDirectTargetIndex();
        if (directTargetIndex >= 0) {
            this.cfw.add(89);
            if (this.isTopLevel) {
                this.cfw.add(42);
            } else {
                this.cfw.add(42);
                this.cfw.add(180, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
            }
            this.cfw.add(95);
            this.cfw.add(181, this.codegen.mainClassName, Codegen.getDirectTargetFieldName(directTargetIndex), this.codegen.mainClassSignature);
        }
        if (functionType == 2) {
            return;
        }
        this.cfw.addPush(functionType);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", "(Lcompat16/org/mozilla/javascript/NativeFunction;ILcompat16/org/mozilla/javascript/Scriptable;Lcompat16/org/mozilla/javascript/Context;)V");
    }

    private int getTargetLabel(Node target) {
        int labelId = target.labelId();
        if (labelId == -1) {
            labelId = this.cfw.acquireLabel();
            target.labelId(labelId);
        }
        return labelId;
    }

    private void visitGOTO(Node.Jump node, int type, Node child) {
        Node target = node.target;
        if (type == 6 || type == 7) {
            if (child == null) {
                throw Codegen.badTree();
            }
            int targetLabel = this.getTargetLabel(target);
            int fallThruLabel = this.cfw.acquireLabel();
            if (type == 6) {
                this.generateIfJump(child, node, targetLabel, fallThruLabel);
            } else {
                this.generateIfJump(child, node, fallThruLabel, targetLabel);
            }
            this.cfw.markLabel(fallThruLabel);
        } else if (type == 131) {
            this.addGoto(target, 168);
        } else {
            this.addGoto(target, 167);
        }
    }

    private void visitArrayLiteral(Node node, Node child) {
        int count = 0;
        for (Node cursor = child; cursor != null; cursor = cursor.getNext()) {
            ++count;
        }
        this.addNewObjectArray(count);
        for (int i = 0; i != count; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            this.generateExpression(child, node);
            this.cfw.add(83);
            child = child.getNext();
        }
        int[] skipIndexes = (int[])node.getProp(11);
        if (skipIndexes == null) {
            this.cfw.add(1);
            this.cfw.add(3);
        } else {
            this.cfw.addPush(OptRuntime.encodeIntArray(skipIndexes));
            this.cfw.addPush(skipIndexes.length);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke("newArrayLiteral", "([Ljava/lang/Object;Ljava/lang/String;ILcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Lcompat16/org/mozilla/javascript/Scriptable;");
    }

    private void visitObjectLiteral(Node node, Node child) {
        int childType;
        int i;
        Object[] properties = (Object[])node.getProp(12);
        int count = properties.length;
        this.addNewObjectArray(count);
        for (int i2 = 0; i2 != count; ++i2) {
            this.cfw.add(89);
            this.cfw.addPush(i2);
            Object id = properties[i2];
            if (id instanceof String) {
                this.cfw.addPush((String)id);
            } else {
                this.cfw.addPush((Integer)id);
                this.addScriptRuntimeInvoke("wrapInt", "(I)Ljava/lang/Integer;");
            }
            this.cfw.add(83);
        }
        this.addNewObjectArray(count);
        Node child2 = child;
        for (i = 0; i != count; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            childType = child.getType();
            if (childType == 147) {
                this.generateExpression(child.getFirstChild(), node);
            } else if (childType == 148) {
                this.generateExpression(child.getFirstChild(), node);
            } else {
                this.generateExpression(child, node);
            }
            this.cfw.add(83);
            child = child.getNext();
        }
        this.cfw.addPush(count);
        this.cfw.add(188, 10);
        for (i = 0; i != count; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            childType = child2.getType();
            if (childType == 147) {
                this.cfw.add(2);
            } else if (childType == 148) {
                this.cfw.add(4);
            } else {
                this.cfw.add(3);
            }
            this.cfw.add(79);
            child2 = child2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("newObjectLiteral", "([Ljava/lang/Object;[Ljava/lang/Object;[ILcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Lcompat16/org/mozilla/javascript/Scriptable;");
    }

    private void visitSpecialCall(Node node, int type, int specialType, Node child) {
        String callSignature;
        String methodName;
        this.cfw.addALoad(this.contextLocal);
        if (type == 30) {
            this.generateExpression(child, node);
        } else {
            this.generateFunctionAndThisObj(child, node);
        }
        child = child.getNext();
        this.generateCallArgArray(node, child, false);
        if (type == 30) {
            methodName = "newObjectSpecial";
            callSignature = "(Lcompat16/org/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Scriptable;Lcompat16/org/mozilla/javascript/Scriptable;I)Ljava/lang/Object;";
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(specialType);
        } else {
            methodName = "callSpecial";
            callSignature = "(Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Callable;Lcompat16/org/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Scriptable;Lcompat16/org/mozilla/javascript/Scriptable;ILjava/lang/String;I)Ljava/lang/Object;";
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(specialType);
            String sourceName = this.scriptOrFn.getSourceName();
            this.cfw.addPush(sourceName == null ? "" : sourceName);
            this.cfw.addPush(this.itsLineNumber);
        }
        this.addOptRuntimeInvoke(methodName, callSignature);
    }

    private void visitStandardCall(Node node, Node child) {
        String signature;
        String methodName;
        if (node.getType() != 37) {
            throw Codegen.badTree();
        }
        Node firstArgChild = child.getNext();
        int childType = child.getType();
        if (firstArgChild == null) {
            if (childType == 38) {
                String name = child.getString();
                this.cfw.addPush(name);
                methodName = "callName0";
                signature = "(Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else if (childType == 33) {
                Node propTarget = child.getFirstChild();
                this.generateExpression(propTarget, node);
                Node id = propTarget.getNext();
                String property = id.getString();
                this.cfw.addPush(property);
                methodName = "callProp0";
                signature = "(Ljava/lang/Object;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else {
                this.generateFunctionAndThisObj(child, node);
                methodName = "call0";
                signature = "(Lcompat16/org/mozilla/javascript/Callable;Lcompat16/org/mozilla/javascript/Scriptable;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        } else if (childType == 38) {
            String name = child.getString();
            this.generateCallArgArray(node, firstArgChild, false);
            this.cfw.addPush(name);
            methodName = "callName";
            signature = "([Ljava/lang/Object;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
        } else {
            int argCount = 0;
            for (Node arg = firstArgChild; arg != null; arg = arg.getNext()) {
                ++argCount;
            }
            this.generateFunctionAndThisObj(child, node);
            if (argCount == 1) {
                this.generateExpression(firstArgChild, node);
                methodName = "call1";
                signature = "(Lcompat16/org/mozilla/javascript/Callable;Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else if (argCount == 2) {
                this.generateExpression(firstArgChild, node);
                this.generateExpression(firstArgChild.getNext(), node);
                methodName = "call2";
                signature = "(Lcompat16/org/mozilla/javascript/Callable;Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else {
                this.generateCallArgArray(node, firstArgChild, false);
                methodName = "callN";
                signature = "(Lcompat16/org/mozilla/javascript/Callable;Lcompat16/org/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke(methodName, signature);
    }

    private void visitStandardNew(Node node, Node child) {
        if (node.getType() != 30) {
            throw Codegen.badTree();
        }
        Node firstArgChild = child.getNext();
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.generateCallArgArray(node, firstArgChild, false);
        this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lcompat16/org/mozilla/javascript/Scriptable;");
    }

    private void visitOptimizedCall(Node node, OptFunctionNode target, int type, Node child) {
        Node firstArgChild = child.getNext();
        short thisObjLocal = 0;
        if (type == 30) {
            this.generateExpression(child, node);
        } else {
            this.generateFunctionAndThisObj(child, node);
            thisObjLocal = this.getNewWordLocal();
            this.cfw.addAStore(thisObjLocal);
        }
        int beyond = this.cfw.acquireLabel();
        int directTargetIndex = target.getDirectTargetIndex();
        if (this.isTopLevel) {
            this.cfw.add(42);
        } else {
            this.cfw.add(42);
            this.cfw.add(180, this.codegen.mainClassName, "_dcp", this.codegen.mainClassSignature);
        }
        this.cfw.add(180, this.codegen.mainClassName, Codegen.getDirectTargetFieldName(directTargetIndex), this.codegen.mainClassSignature);
        this.cfw.add(92);
        int regularCall = this.cfw.acquireLabel();
        this.cfw.add(166, regularCall);
        short stackHeight = this.cfw.getStackTop();
        this.cfw.add(95);
        this.cfw.add(87);
        if (this.compilerEnv.isUseDynamicScope()) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
        } else {
            this.cfw.add(89);
            this.cfw.addInvoke(185, "compat16/org/mozilla/javascript/Scriptable", "getParentScope", "()Lcompat16/org/mozilla/javascript/Scriptable;");
            this.cfw.addALoad(this.contextLocal);
            this.cfw.add(95);
        }
        if (type == 30) {
            this.cfw.add(1);
        } else {
            this.cfw.addALoad(thisObjLocal);
        }
        for (Node argChild = firstArgChild; argChild != null; argChild = argChild.getNext()) {
            int dcp_register = this.nodeIsDirectCallParameter(argChild);
            if (dcp_register >= 0) {
                this.cfw.addALoad(dcp_register);
                this.cfw.addDLoad(dcp_register + 1);
                continue;
            }
            if (argChild.getIntProp(8, -1) == 0) {
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.generateExpression(argChild, node);
                continue;
            }
            this.generateExpression(argChild, node);
            this.cfw.addPush(0.0);
        }
        this.cfw.add(178, "compat16/org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
        this.cfw.addInvoke(184, this.codegen.mainClassName, type == 30 ? this.codegen.getDirectCtorName(target.fnode) : this.codegen.getBodyMethodName(target.fnode), this.codegen.getBodyMethodSignature(target.fnode));
        this.cfw.add(167, beyond);
        this.cfw.markLabel(regularCall, stackHeight);
        this.cfw.add(87);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (type != 30) {
            this.cfw.addALoad(thisObjLocal);
            this.releaseWordLocal(thisObjLocal);
        }
        this.generateCallArgArray(node, firstArgChild, true);
        if (type == 30) {
            this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lcompat16/org/mozilla/javascript/Scriptable;");
        } else {
            this.cfw.addInvoke(185, "compat16/org/mozilla/javascript/Callable", "call", "(Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;Lcompat16/org/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        this.cfw.markLabel(beyond);
    }

    private void generateCallArgArray(Node node, Node argChild, boolean directCall) {
        int argCount = 0;
        for (Node child = argChild; child != null; child = child.getNext()) {
            ++argCount;
        }
        if (argCount == 1 && this.itsOneArgArray >= 0) {
            this.cfw.addALoad(this.itsOneArgArray);
        } else {
            this.addNewObjectArray(argCount);
        }
        for (int i = 0; i != argCount; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            if (!directCall) {
                this.generateExpression(argChild, node);
            } else {
                int dcp_register = this.nodeIsDirectCallParameter(argChild);
                if (dcp_register >= 0) {
                    this.dcpLoadAsObject(dcp_register);
                } else {
                    this.generateExpression(argChild, node);
                    int childNumberFlag = argChild.getIntProp(8, -1);
                    if (childNumberFlag == 0) {
                        this.addDoubleWrap();
                    }
                }
            }
            this.cfw.add(83);
            argChild = argChild.getNext();
        }
    }

    private void generateFunctionAndThisObj(Node node, Node parent) {
        int type = node.getType();
        switch (node.getType()) {
            case 33: 
            case 35: {
                Node target = node.getFirstChild();
                this.generateExpression(target, node);
                Node id = target.getNext();
                if (type == 33) {
                    String property = id.getString();
                    this.cfw.addPush(property);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("getPropFunctionAndThis", "(Ljava/lang/Object;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;)Lcompat16/org/mozilla/javascript/Callable;");
                    break;
                }
                if (node.getIntProp(8, -1) != -1) {
                    throw Codegen.badTree();
                }
                this.generateExpression(id, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getElemFunctionAndThis", "(Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Lcompat16/org/mozilla/javascript/Callable;");
                break;
            }
            case 38: {
                String name = node.getString();
                this.cfw.addPush(name);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getNameFunctionAndThis", "(Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;)Lcompat16/org/mozilla/javascript/Callable;");
                break;
            }
            default: {
                this.generateExpression(node, parent);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getValueFunctionAndThis", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Lcompat16/org/mozilla/javascript/Callable;");
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("lastStoredScriptable", "(Lcompat16/org/mozilla/javascript/Context;)Lcompat16/org/mozilla/javascript/Scriptable;");
    }

    private void updateLineNumber(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.cfw.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Node.Jump node, Node child) {
        short savedVariableObject = this.getNewWordLocal();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addAStore(savedVariableObject);
        int startLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(startLabel, (short)1);
        while (child != null) {
            this.generateStatement(child);
            child = child.getNext();
        }
        Node catchTarget = node.target;
        Node finallyTarget = node.getFinally();
        int realEnd = this.cfw.acquireLabel();
        this.cfw.add(167, realEnd);
        int exceptionLocal = this.getLocalBlockRegister(node);
        if (catchTarget != null) {
            int catchLabel = catchTarget.labelId();
            this.generateCatchBlock(0, savedVariableObject, catchLabel, startLabel, exceptionLocal);
            this.generateCatchBlock(1, savedVariableObject, catchLabel, startLabel, exceptionLocal);
            this.generateCatchBlock(2, savedVariableObject, catchLabel, startLabel, exceptionLocal);
        }
        if (finallyTarget != null) {
            int finallyHandler = this.cfw.acquireLabel();
            this.cfw.markHandler(finallyHandler);
            this.cfw.addAStore(exceptionLocal);
            this.cfw.addALoad(savedVariableObject);
            this.cfw.addAStore(this.variableObjectLocal);
            int finallyLabel = finallyTarget.labelId();
            this.cfw.add(168, finallyLabel);
            this.cfw.addALoad(exceptionLocal);
            this.cfw.add(191);
            this.cfw.addExceptionHandler(startLabel, finallyLabel, finallyHandler, null);
        }
        this.releaseWordLocal(savedVariableObject);
        this.cfw.markLabel(realEnd);
    }

    private void generateCatchBlock(int exceptionType, short savedVariableObject, int catchLabel, int startLabel, int exceptionLocal) {
        String exceptionName;
        int handler = this.cfw.acquireLabel();
        this.cfw.markHandler(handler);
        this.cfw.addAStore(exceptionLocal);
        this.cfw.addALoad(savedVariableObject);
        this.cfw.addAStore(this.variableObjectLocal);
        if (exceptionType == 0) {
            exceptionName = "compat16/org/mozilla/javascript/JavaScriptException";
        } else if (exceptionType == 1) {
            exceptionName = "compat16/org/mozilla/javascript/EvaluatorException";
        } else {
            if (exceptionType != 2) {
                Kit.codeBug();
            }
            exceptionName = "compat16/org/mozilla/javascript/EcmaError";
        }
        this.cfw.addExceptionHandler(startLabel, catchLabel, handler, exceptionName);
        this.cfw.add(167, catchLabel);
    }

    private void visitSwitch(Node.Jump switchNode, Node child) {
        this.generateExpression(child, switchNode);
        short selector = this.getNewWordLocal();
        this.cfw.addAStore(selector);
        for (Node.Jump caseNode = (Node.Jump)child.getNext(); caseNode != null; caseNode = (Node.Jump)caseNode.getNext()) {
            if (caseNode.getType() != 111) {
                throw Codegen.badTree();
            }
            Node test = caseNode.getFirstChild();
            this.generateExpression(test, caseNode);
            this.cfw.addALoad(selector);
            this.addScriptRuntimeInvoke("shallowEq", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.addGoto(caseNode.target, 154);
        }
        this.releaseWordLocal(selector);
    }

    private void visitTypeofname(Node node) {
        int varIndex;
        String name = node.getString();
        if (this.hasVarsInRegs && (varIndex = this.fnCurrent.fnode.getParamOrVarIndex(name)) >= 0) {
            if (this.fnCurrent.isNumberVar(varIndex)) {
                this.cfw.addPush("number");
            } else if (this.varIsDirectCallParameter(varIndex)) {
                short dcp_register = this.varRegisters[varIndex];
                this.cfw.addALoad(dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int isNumberLabel = this.cfw.acquireLabel();
                this.cfw.add(165, isNumberLabel);
                short stack = this.cfw.getStackTop();
                this.cfw.addALoad(dcp_register);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                int beyond = this.cfw.acquireLabel();
                this.cfw.add(167, beyond);
                this.cfw.markLabel(isNumberLabel, stack);
                this.cfw.addPush("number");
                this.cfw.markLabel(beyond);
            } else {
                this.cfw.addALoad(this.varRegisters[varIndex]);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
            }
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(name);
        this.addScriptRuntimeInvoke("typeofName", "(Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/String;");
    }

    private void visitIncDec(Node node) {
        int incrDecrMask = node.getExistingIntProp(13);
        Node child = node.getFirstChild();
        switch (child.getType()) {
            case 54: {
                if (!this.hasVarsInRegs) {
                    Kit.codeBug();
                }
                if (node.getIntProp(8, -1) != -1) {
                    boolean post = (incrDecrMask & 2) != 0;
                    int varIndex = this.fnCurrent.getVarIndex(child);
                    short reg = this.varRegisters[varIndex];
                    short offset = this.varIsDirectCallParameter(varIndex) ? (short)1 : 0;
                    this.cfw.addDLoad(reg + offset);
                    if (post) {
                        this.cfw.add(92);
                    }
                    this.cfw.addPush(1.0);
                    if ((incrDecrMask & 1) == 0) {
                        this.cfw.add(99);
                    } else {
                        this.cfw.add(103);
                    }
                    if (!post) {
                        this.cfw.add(92);
                    }
                    this.cfw.addDStore(reg + offset);
                    break;
                }
                boolean post = (incrDecrMask & 2) != 0;
                int varIndex = this.fnCurrent.getVarIndex(child);
                short reg = this.varRegisters[varIndex];
                this.cfw.addALoad(reg);
                if (post) {
                    this.cfw.add(89);
                }
                this.addObjectToDouble();
                this.cfw.addPush(1.0);
                if ((incrDecrMask & 1) == 0) {
                    this.cfw.add(99);
                } else {
                    this.cfw.add(103);
                }
                this.addDoubleWrap();
                if (!post) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(reg);
                break;
            }
            case 38: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(child.getString());
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("nameIncrDecr", "(Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            case 33: {
                Node getPropChild = child.getFirstChild();
                this.generateExpression(getPropChild, node);
                this.generateExpression(getPropChild.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("propIncrDecr", "(Ljava/lang/Object;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            case 35: {
                Node elemChild = child.getFirstChild();
                this.generateExpression(elemChild, node);
                this.generateExpression(elemChild.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(incrDecrMask);
                if (elemChild.getNext().getIntProp(8, -1) != -1) {
                    this.addOptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;DLcompat16/org/mozilla/javascript/Context;I)Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            case 65: {
                Node refChild = child.getFirstChild();
                this.generateExpression(refChild, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(incrDecrMask);
                this.addScriptRuntimeInvoke("refIncrDecr", "(Lcompat16/org/mozilla/javascript/Ref;Lcompat16/org/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
    }

    private static boolean isArithmeticNode(Node node) {
        int type = node.getType();
        return type == 22 || type == 25 || type == 24 || type == 23;
    }

    private void visitArithmetic(Node node, int opCode, Node child, Node parent) {
        int childNumberFlag = node.getIntProp(8, -1);
        if (childNumberFlag != -1) {
            this.generateExpression(child, node);
            this.generateExpression(child.getNext(), node);
            this.cfw.add(opCode);
        } else {
            boolean childOfArithmetic = BodyCodegen.isArithmeticNode(parent);
            this.generateExpression(child, node);
            if (!BodyCodegen.isArithmeticNode(child)) {
                this.addObjectToDouble();
            }
            this.generateExpression(child.getNext(), node);
            if (!BodyCodegen.isArithmeticNode(child.getNext())) {
                this.addObjectToDouble();
            }
            this.cfw.add(opCode);
            if (!childOfArithmetic) {
                this.addDoubleWrap();
            }
        }
    }

    private void visitBitOp(Node node, int type, Node child) {
        int childNumberFlag = node.getIntProp(8, -1);
        this.generateExpression(child, node);
        if (type == 20) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)J");
            this.generateExpression(child.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.cfw.addPush(31);
            this.cfw.add(126);
            this.cfw.add(125);
            this.cfw.add(138);
            this.addDoubleWrap();
            return;
        }
        if (childNumberFlag == -1) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.generateExpression(child.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.generateExpression(child.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
        }
        switch (type) {
            case 9: {
                this.cfw.add(128);
                break;
            }
            case 10: {
                this.cfw.add(130);
                break;
            }
            case 11: {
                this.cfw.add(126);
                break;
            }
            case 19: {
                this.cfw.add(122);
                break;
            }
            case 18: {
                this.cfw.add(120);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
        this.cfw.add(135);
        if (childNumberFlag == -1) {
            this.addDoubleWrap();
        }
    }

    private int nodeIsDirectCallParameter(Node node) {
        int varIndex;
        if (node.getType() == 54 && this.inDirectCallFunction && !this.itsForcedObjectParameters && this.fnCurrent.isParameter(varIndex = this.fnCurrent.getVarIndex(node))) {
            return this.varRegisters[varIndex];
        }
        return -1;
    }

    private boolean varIsDirectCallParameter(int varIndex) {
        return this.fnCurrent.isParameter(varIndex) && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int type, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1) {
            throw Codegen.badTree();
        }
        switch (type) {
            case 15: {
                this.cfw.add(152);
                this.cfw.add(158, trueGOTO);
                break;
            }
            case 17: {
                this.cfw.add(151);
                this.cfw.add(156, trueGOTO);
                break;
            }
            case 14: {
                this.cfw.add(152);
                this.cfw.add(155, trueGOTO);
                break;
            }
            case 16: {
                this.cfw.add(151);
                this.cfw.add(157, trueGOTO);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
        if (falseGOTO != -1) {
            this.cfw.add(167, falseGOTO);
        }
    }

    private void visitIfJumpRelOp(Node node, Node child, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1 || falseGOTO == -1) {
            throw Codegen.badTree();
        }
        int type = node.getType();
        Node rChild = child.getNext();
        if (type == 52 || type == 51) {
            this.generateExpression(child, node);
            this.generateExpression(rChild, node);
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke(type == 52 ? "instanceOf" : "in", "(Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Z");
            this.cfw.add(154, trueGOTO);
            this.cfw.add(167, falseGOTO);
            return;
        }
        int childNumberFlag = node.getIntProp(8, -1);
        int left_dcp_register = this.nodeIsDirectCallParameter(child);
        int right_dcp_register = this.nodeIsDirectCallParameter(rChild);
        if (childNumberFlag != -1) {
            if (childNumberFlag != 2) {
                this.generateExpression(child, node);
            } else if (left_dcp_register != -1) {
                this.dcpLoadAsNumber(left_dcp_register);
            } else {
                this.generateExpression(child, node);
                this.addObjectToDouble();
            }
            if (childNumberFlag != 1) {
                this.generateExpression(rChild, node);
            } else if (right_dcp_register != -1) {
                this.dcpLoadAsNumber(right_dcp_register);
            } else {
                this.generateExpression(rChild, node);
                this.addObjectToDouble();
            }
            this.genSimpleCompare(type, trueGOTO, falseGOTO);
        } else {
            if (left_dcp_register != -1 && right_dcp_register != -1) {
                short stack = this.cfw.getStackTop();
                int leftIsNotNumber = this.cfw.acquireLabel();
                this.cfw.addALoad(left_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, leftIsNotNumber);
                this.cfw.addDLoad(left_dcp_register + 1);
                this.dcpLoadAsNumber(right_dcp_register);
                this.genSimpleCompare(type, trueGOTO, falseGOTO);
                if (stack != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(leftIsNotNumber);
                int rightIsNotNumber = this.cfw.acquireLabel();
                this.cfw.addALoad(right_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, rightIsNotNumber);
                this.cfw.addALoad(left_dcp_register);
                this.addObjectToDouble();
                this.cfw.addDLoad(right_dcp_register + 1);
                this.genSimpleCompare(type, trueGOTO, falseGOTO);
                if (stack != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(rightIsNotNumber);
                this.cfw.addALoad(left_dcp_register);
                this.cfw.addALoad(right_dcp_register);
            } else {
                this.generateExpression(child, node);
                this.generateExpression(rChild, node);
            }
            if (type == 17 || type == 16) {
                this.cfw.add(95);
            }
            String routine = type == 14 || type == 16 ? "cmp_LT" : "cmp_LE";
            this.addScriptRuntimeInvoke(routine, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.cfw.add(154, trueGOTO);
            this.cfw.add(167, falseGOTO);
        }
    }

    private void visitIfJumpEqOp(Node node, Node child, int trueGOTO, int falseGOTO) {
        if (trueGOTO == -1 || falseGOTO == -1) {
            throw Codegen.badTree();
        }
        short stackInitial = this.cfw.getStackTop();
        int type = node.getType();
        Node rChild = child.getNext();
        if (child.getType() == 41 || rChild.getType() == 41) {
            if (child.getType() == 41) {
                child = rChild;
            }
            this.generateExpression(child, node);
            if (type == 45 || type == 46) {
                int testCode = type == 45 ? 198 : 199;
                this.cfw.add(testCode, trueGOTO);
            } else {
                if (type != 12) {
                    if (type != 13) {
                        throw Codegen.badTree();
                    }
                    int tmp = trueGOTO;
                    trueGOTO = falseGOTO;
                    falseGOTO = tmp;
                }
                this.cfw.add(89);
                int undefCheckLabel = this.cfw.acquireLabel();
                this.cfw.add(199, undefCheckLabel);
                short stack = this.cfw.getStackTop();
                this.cfw.add(87);
                this.cfw.add(167, trueGOTO);
                this.cfw.markLabel(undefCheckLabel, stack);
                Codegen.pushUndefined(this.cfw);
                this.cfw.add(165, trueGOTO);
            }
            this.cfw.add(167, falseGOTO);
        } else {
            int testCode;
            String name;
            Node convertChild;
            int child_dcp_register = this.nodeIsDirectCallParameter(child);
            if (child_dcp_register != -1 && rChild.getType() == 145 && (convertChild = rChild.getFirstChild()).getType() == 39) {
                this.cfw.addALoad(child_dcp_register);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int notNumbersLabel = this.cfw.acquireLabel();
                this.cfw.add(166, notNumbersLabel);
                this.cfw.addDLoad(child_dcp_register + 1);
                this.cfw.addPush(convertChild.getDouble());
                this.cfw.add(151);
                if (type == 12) {
                    this.cfw.add(153, trueGOTO);
                } else {
                    this.cfw.add(154, trueGOTO);
                }
                this.cfw.add(167, falseGOTO);
                this.cfw.markLabel(notNumbersLabel);
            }
            this.generateExpression(child, node);
            this.generateExpression(rChild, node);
            switch (type) {
                case 12: {
                    name = "eq";
                    testCode = 154;
                    break;
                }
                case 13: {
                    name = "eq";
                    testCode = 153;
                    break;
                }
                case 45: {
                    name = "shallowEq";
                    testCode = 154;
                    break;
                }
                case 46: {
                    name = "shallowEq";
                    testCode = 153;
                    break;
                }
                default: {
                    throw Codegen.badTree();
                }
            }
            this.addScriptRuntimeInvoke(name, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.cfw.add(testCode, trueGOTO);
            this.cfw.add(167, falseGOTO);
        }
        if (stackInitial != this.cfw.getStackTop()) {
            throw Codegen.badTree();
        }
    }

    private void visitSetName(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateExpression(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(name);
        this.addScriptRuntimeInvoke("setName", "(Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitSetConst(Node node, Node child) {
        String name = node.getFirstChild().getString();
        while (child != null) {
            this.generateExpression(child, node);
            child = child.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(name);
        this.addScriptRuntimeInvoke("setConst", "(Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitGetVar(Node node) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        short reg = this.varRegisters[varIndex];
        if (this.varIsDirectCallParameter(varIndex)) {
            if (node.getIntProp(8, -1) != -1) {
                this.dcpLoadAsNumber(reg);
            } else {
                this.dcpLoadAsObject(reg);
            }
        } else if (this.fnCurrent.isNumberVar(varIndex)) {
            this.cfw.addDLoad(reg);
        } else {
            this.cfw.addALoad(reg);
        }
    }

    private void visitSetVar(Node node, Node child, boolean needValue) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        this.generateExpression(child.getNext(), node);
        boolean isNumber = node.getIntProp(8, -1) != -1;
        short reg = this.varRegisters[varIndex];
        boolean[] constDeclarations = this.fnCurrent.fnode.getParamAndVarConst();
        if (constDeclarations[varIndex]) {
            if (!needValue) {
                if (isNumber) {
                    this.cfw.add(88);
                } else {
                    this.cfw.add(87);
                }
            }
        } else if (this.varIsDirectCallParameter(varIndex)) {
            if (isNumber) {
                if (needValue) {
                    this.cfw.add(92);
                }
                this.cfw.addALoad(reg);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int isNumberLabel = this.cfw.acquireLabel();
                int beyond = this.cfw.acquireLabel();
                this.cfw.add(165, isNumberLabel);
                short stack = this.cfw.getStackTop();
                this.addDoubleWrap();
                this.cfw.addAStore(reg);
                this.cfw.add(167, beyond);
                this.cfw.markLabel(isNumberLabel, stack);
                this.cfw.addDStore(reg + 1);
                this.cfw.markLabel(beyond);
            } else {
                if (needValue) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(reg);
            }
        } else if (isNumber) {
            this.cfw.addDStore(reg);
            if (needValue) {
                this.cfw.addDLoad(reg);
            }
        } else {
            this.cfw.addAStore(reg);
            if (needValue) {
                this.cfw.addALoad(reg);
            }
        }
    }

    private void visitSetConstVar(Node node, Node child, boolean needValue) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int varIndex = this.fnCurrent.getVarIndex(node);
        this.generateExpression(child.getNext(), node);
        boolean isNumber = node.getIntProp(8, -1) != -1;
        short reg = this.varRegisters[varIndex];
        int beyond = this.cfw.acquireLabel();
        int noAssign = this.cfw.acquireLabel();
        if (isNumber) {
            this.cfw.addILoad(reg + 2);
            this.cfw.add(154, noAssign);
            short stack = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(reg + 2);
            this.cfw.addDStore(reg);
            if (needValue) {
                this.cfw.addDLoad(reg);
                this.cfw.markLabel(noAssign, stack);
            } else {
                this.cfw.add(167, beyond);
                this.cfw.markLabel(noAssign, stack);
                this.cfw.add(88);
            }
        } else {
            this.cfw.addILoad(reg + 1);
            this.cfw.add(154, noAssign);
            short stack = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(reg + 1);
            this.cfw.addAStore(reg);
            if (needValue) {
                this.cfw.addALoad(reg);
                this.cfw.markLabel(noAssign, stack);
            } else {
                this.cfw.add(167, beyond);
                this.cfw.markLabel(noAssign, stack);
                this.cfw.add(87);
            }
        }
        this.cfw.markLabel(beyond);
    }

    private void visitGetProp(Node node, Node child) {
        this.generateExpression(child, node);
        Node nameChild = child.getNext();
        this.generateExpression(nameChild, node);
        int childType = child.getType();
        if (childType == 42 && nameChild.getType() == 40) {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("getObjectProp", "(Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
        } else {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("getObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
        }
    }

    private void visitSetProp(int type, Node node, Node child) {
        Node objectChild = child;
        this.generateExpression(child, node);
        child = child.getNext();
        if (type == 135) {
            this.cfw.add(89);
        }
        Node nameChild = child;
        this.generateExpression(child, node);
        child = child.getNext();
        if (type == 135) {
            this.cfw.add(90);
            if (objectChild.getType() == 42 && nameChild.getType() == 40) {
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getObjectProp", "(Lcompat16/org/mozilla/javascript/Scriptable;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
            } else {
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("setObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
    }

    private void visitSetElem(int type, Node node, Node child) {
        boolean indexIsNumber;
        this.generateExpression(child, node);
        child = child.getNext();
        if (type == 136) {
            this.cfw.add(89);
        }
        this.generateExpression(child, node);
        child = child.getNext();
        boolean bl = indexIsNumber = node.getIntProp(8, -1) != -1;
        if (type == 136) {
            if (indexIsNumber) {
                this.cfw.add(93);
                this.cfw.addALoad(this.contextLocal);
                this.addOptRuntimeInvoke("getObjectIndex", "(Ljava/lang/Object;DLcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
            } else {
                this.cfw.add(90);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(child, node);
        this.cfw.addALoad(this.contextLocal);
        if (indexIsNumber) {
            this.addScriptRuntimeInvoke("setObjectIndex", "(Ljava/lang/Object;DLjava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("setObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Context;)Ljava/lang/Object;");
        }
    }

    private void visitDotQuery(Node node, Node child) {
        this.updateLineNumber(node);
        this.generateExpression(child, node);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterDotQuery", "(Ljava/lang/Object;Lcompat16/org/mozilla/javascript/Scriptable;)Lcompat16/org/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(1);
        int queryLoopStart = this.cfw.acquireLabel();
        this.cfw.markLabel(queryLoopStart);
        this.cfw.add(87);
        this.generateExpression(child.getNext(), node);
        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("updateDotQuery", "(ZLcompat16/org/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        this.cfw.add(89);
        this.cfw.add(198, queryLoopStart);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveDotQuery", "(Lcompat16/org/mozilla/javascript/Scriptable;)Lcompat16/org/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private int getLocalBlockRegister(Node node) {
        Node localBlock = (Node)node.getProp(3);
        int localSlot = localBlock.getExistingIntProp(2);
        return localSlot;
    }

    private void dcpLoadAsNumber(int dcp_register) {
        this.cfw.addALoad(dcp_register);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int isNumberLabel = this.cfw.acquireLabel();
        this.cfw.add(165, isNumberLabel);
        short stack = this.cfw.getStackTop();
        this.cfw.addALoad(dcp_register);
        this.addObjectToDouble();
        int beyond = this.cfw.acquireLabel();
        this.cfw.add(167, beyond);
        this.cfw.markLabel(isNumberLabel, stack);
        this.cfw.addDLoad(dcp_register + 1);
        this.cfw.markLabel(beyond);
    }

    private void dcpLoadAsObject(int dcp_register) {
        this.cfw.addALoad(dcp_register);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int isNumberLabel = this.cfw.acquireLabel();
        this.cfw.add(165, isNumberLabel);
        short stack = this.cfw.getStackTop();
        this.cfw.addALoad(dcp_register);
        int beyond = this.cfw.acquireLabel();
        this.cfw.add(167, beyond);
        this.cfw.markLabel(isNumberLabel, stack);
        this.cfw.addDLoad(dcp_register + 1);
        this.addDoubleWrap();
        this.cfw.markLabel(beyond);
    }

    private void addGoto(Node target, int jumpcode) {
        int targetLabel = this.getTargetLabel(target);
        this.cfw.add(jumpcode, targetLabel);
    }

    private void addObjectToDouble() {
        this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
    }

    private void addNewObjectArray(int size) {
        if (size == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.cfw.addALoad(this.itsZeroArgArray);
            } else {
                this.cfw.add(178, "compat16/org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            }
        } else {
            this.cfw.addPush(size);
            this.cfw.add(189, "java/lang/Object");
        }
    }

    private void addScriptRuntimeInvoke(String methodName, String methodSignature) {
        this.cfw.addInvoke(184, "compat16.org.mozilla.javascript.ScriptRuntime", methodName, methodSignature);
    }

    private void addOptRuntimeInvoke(String methodName, String methodSignature) {
        this.cfw.addInvoke(184, "compat16/org/mozilla/javascript/optimizer/OptRuntime", methodName, methodSignature);
    }

    private void addJumpedBooleanWrap(int trueLabel, int falseLabel) {
        this.cfw.markLabel(falseLabel);
        int skip = this.cfw.acquireLabel();
        this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.cfw.add(167, skip);
        this.cfw.markLabel(trueLabel);
        this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        this.cfw.markLabel(skip);
        this.cfw.adjustStackTop(-1);
    }

    private void addDoubleWrap() {
        this.addOptRuntimeInvoke("wrapDouble", "(D)Ljava/lang/Double;");
    }

    private short getNewWordPairLocal(boolean isConst) {
        short result = this.getConsecutiveSlots(2, isConst);
        if (result < 255) {
            this.locals[result] = true;
            this.locals[result + 1] = true;
            if (isConst) {
                this.locals[result + 2] = true;
            }
            if (result == this.firstFreeLocal) {
                for (int i = this.firstFreeLocal + 2; i < 256; ++i) {
                    if (this.locals[i]) continue;
                    this.firstFreeLocal = (short)i;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return result;
                }
            } else {
                return result;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short getNewWordLocal(boolean isConst) {
        short result = this.getConsecutiveSlots(1, isConst);
        if (result < 255) {
            this.locals[result] = true;
            if (isConst) {
                this.locals[result + 1] = true;
            }
            if (result == this.firstFreeLocal) {
                for (int i = this.firstFreeLocal + 1; i < 256; ++i) {
                    if (this.locals[i]) continue;
                    this.firstFreeLocal = (short)i;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return result;
                }
            } else {
                return result;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short getNewWordLocal() {
        short result = this.firstFreeLocal;
        this.locals[result] = true;
        for (int i = this.firstFreeLocal + 1; i < 256; ++i) {
            if (this.locals[i]) continue;
            this.firstFreeLocal = (short)i;
            if (this.localsMax < this.firstFreeLocal) {
                this.localsMax = this.firstFreeLocal;
            }
            return result;
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short getConsecutiveSlots(int count, boolean isConst) {
        short result;
        if (isConst) {
            ++count;
        }
        for (result = this.firstFreeLocal; result < 255; result = (short)(result + 1)) {
            int i;
            for (i = 0; i < count && !this.locals[result + i]; ++i) {
            }
            if (i >= count) break;
        }
        return result;
    }

    private void releaseWordLocal(short local) {
        if (local < this.firstFreeLocal) {
            this.firstFreeLocal = local;
        }
        this.locals[local] = false;
    }
}

