/*
 * Decompiled with CFR 0.152.
 */
package play.modules.excel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.ss.usermodel.Workbook;
import play.Logger;
import play.Play;
import play.exceptions.UnexpectedException;
import play.jobs.Job;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Scope;
import play.mvc.results.Result;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderExcel
extends Result {
    public static final String RA_FILENAME = "__EXCEL_FILE_NAME__";
    public static final String RA_ASYNC = "__EXCEL_ASYNC__";
    public static final String CONF_ASYNC = "excel.async";
    private static VirtualFile tmplRoot = null;
    String templateName = null;
    String fileName = null;
    Map<String, Object> beans = null;
    private byte[] excel = null;

    private static void initTmplRoot() {
        VirtualFile appRoot = VirtualFile.open((File)Play.applicationPath);
        String rootDef = "";
        if (Play.configuration.containsKey("excel.template.root")) {
            rootDef = (String)Play.configuration.get("excel.template.root");
        }
        tmplRoot = appRoot.child(rootDef);
    }

    public RenderExcel(String templateName, Map<String, Object> beans) {
        this(templateName, beans, null);
    }

    public RenderExcel(String templateName, Map<String, Object> beans, String fileName) {
        this.templateName = templateName;
        this.beans = beans;
        this.fileName = fileName == null ? RenderExcel.fileName_(templateName) : fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static boolean async() {
        Object o = null;
        o = Scope.RenderArgs.current().data.containsKey(RA_ASYNC) ? Scope.RenderArgs.current().get(RA_ASYNC) : Play.configuration.get(CONF_ASYNC);
        boolean async = false;
        async = null == o ? false : (o instanceof Boolean ? (Boolean)o : Boolean.parseBoolean(o.toString()));
        return async;
    }

    private static String fileName_(String path) {
        if (Scope.RenderArgs.current().data.containsKey(RA_FILENAME)) {
            return (String)Scope.RenderArgs.current().get(RA_FILENAME, String.class);
        }
        int i = path.lastIndexOf("/");
        if (-1 == i) {
            return path;
        }
        return path.substring(++i);
    }

    public static void main(String[] args) {
        System.out.println(RenderExcel.fileName_("abc.xls"));
        System.out.println(RenderExcel.fileName_("/xyz/abc.xls"));
        System.out.println(RenderExcel.fileName_("app/xyz/abc.xls"));
    }

    public void apply(Http.Request request, Http.Response response) {
        if (null == this.excel) {
            Logger.debug((String)"use sync excel rendering", (Object[])new Object[0]);
            long start = System.currentTimeMillis();
            try {
                if (null == tmplRoot) {
                    RenderExcel.initTmplRoot();
                }
                InputStream is = tmplRoot.child(this.templateName).inputstream();
                Workbook workbook = new XLSTransformer().transformXLS(is, this.beans);
                workbook.write((OutputStream)response.out);
                is.close();
                Logger.debug((String)"Excel sync render takes %sms", (Object[])new Object[]{System.currentTimeMillis() - start});
            }
            catch (Exception e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
        Logger.debug((String)"use async excel rendering...", (Object[])new Object[0]);
        try {
            response.out.write(this.excel);
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public void preRender() {
        try {
            if (null == tmplRoot) {
                RenderExcel.initTmplRoot();
            }
            InputStream is = tmplRoot.child(this.templateName).inputstream();
            Workbook workbook = new XLSTransformer().transformXLS(is, this.beans);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            workbook.write((OutputStream)os);
            this.excel = os.toByteArray();
            is.close();
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static F.Promise<RenderExcel> renderAsync(final String templateName, final Map<String, Object> beans, String fileName) {
        final String fn = fileName == null ? RenderExcel.fileName_(templateName) : fileName;
        return new Job<RenderExcel>(){

            public RenderExcel doJobWithResult() throws Exception {
                RenderExcel excel = new RenderExcel(templateName, beans, fn);
                excel.preRender();
                return excel;
            }
        }.now();
    }
}

