/*
 * Decompiled with CFR 0.152.
 */
package org.allcolor.yahp.cl.converter;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.allcolor.xml.parser.CShaniDomParser;
import org.allcolor.xml.parser.CXmlParser;
import org.allcolor.xml.parser.dom.ADocument;
import org.allcolor.yahp.cl.converter.CDocumentCut;
import org.allcolor.yahp.cl.converter.CDocumentReconstructor;
import org.allcolor.yahp.converter.IHtmlToPdfTransformer;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;
import org.xhtmlrenderer.pdf.ITextRenderer;

public final class CHtmlToPdfFlyingSaucerTransformer
implements IHtmlToPdfTransformer {
    private static final Logger log = Logger.getLogger(CHtmlToPdfFlyingSaucerTransformer.class);
    private final ThreadLocal tlparser = new ThreadLocal();
    private final ThreadLocal tlrenderer = new ThreadLocal();
    private final ThreadLocal tltidy = new ThreadLocal();

    private static boolean accept(File dir, String name) {
        return name.toLowerCase().endsWith(".ttf");
    }

    private static void registerTTF(File f, _ITextRenderer renderer) {
        block4: {
            block3: {
                if (!f.isDirectory()) break block3;
                File[] list = f.listFiles();
                if (list == null) break block4;
                for (int i = 0; i < list.length; ++i) {
                    CHtmlToPdfFlyingSaucerTransformer.registerTTF(list[i], renderer);
                }
                break block4;
            }
            if (!CHtmlToPdfFlyingSaucerTransformer.accept(f.getParentFile(), f.getName()) || renderer.isKnown(f.getAbsolutePath())) break block4;
            try {
                renderer.getFontResolver().addFont(f.getAbsolutePath(), "Identity-H", true);
                renderer.addKnown(f.getAbsolutePath());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String removeScript(String a) {
        ArrayList<String> toRemove = new ArrayList<String>();
        Pattern p = Pattern.compile("(<script\\s*)");
        Matcher m = p.matcher(a);
        int start = 0;
        while (m.find(start)) {
            int ie;
            int is = m.start();
            for (ie = m.start(); ie < a.length(); ++ie) {
                if (!a.substring(ie).startsWith("</script>")) continue;
                ie += 9;
                break;
            }
            start = ie + 1;
            toRemove.add(a.substring(is, ie));
            if (start < a.length()) continue;
            break;
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            String rem = (String)toRemove.get(i);
            int index = a.indexOf(rem);
            a = a.substring(0, index) + a.substring(index + rem.length());
        }
        return a;
    }

    private void convertComboboxToVisibleHTML(Document doc) {
        NodeList nl = doc.getElementsByTagName("select");
        while (nl.getLength() > 0) {
            Element select = (Element)nl.item(0);
            String ssize = select.getAttribute("size");
            int size = 1;
            if (!"".equals(ssize.trim())) {
                try {
                    size = Integer.parseInt(ssize);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            Node node = select.getParentNode();
            NodeList options = select.getElementsByTagName("option");
            String style = select.getAttribute("style");
            String width = null;
            String height = null;
            if (style.indexOf("width") != -1) {
                width = style.substring(style.indexOf("width") + 5);
                if (width.indexOf(58) != -1) {
                    width = width.substring(width.indexOf(58));
                }
                if (width.indexOf(59) != -1) {
                    width = width.substring(0, width.indexOf(59));
                }
            }
            if (width == null) {
                width = "50px";
            }
            if (style.indexOf("height") != -1) {
                height = style.substring(style.indexOf("height") + 6);
                if (height.indexOf(58) != -1) {
                    height = height.substring(height.indexOf(58));
                }
                if (height.indexOf(59) != -1) {
                    height = height.substring(0, height.indexOf(59));
                }
            }
            if (size > 1) {
                Element span = doc.createElement("span");
                span.setAttribute("style", "display: inline-block;border: 1px solid black;" + (width != null ? "width: " + width + ";" : "") + (height != null ? "height: " + height + ";" : ""));
                for (int i = 0; i < options.getLength() && i < size; ++i) {
                    Element option = (Element)options.item(i);
                    Element content = doc.createElement("span");
                    content.setTextContent(option.getTextContent());
                    span.appendChild(content);
                    if (i >= options.getLength() - 1) continue;
                    Element br = doc.createElement("br");
                    span.appendChild(br);
                }
                node.insertBefore(span, select);
            } else {
                for (int i = 0; i < options.getLength(); ++i) {
                    Element option = (Element)options.item(i);
                    if (!"selected".equalsIgnoreCase(option.getAttribute("selected"))) continue;
                    Element span = doc.createElement("span");
                    span.setTextContent(option.getTextContent().trim());
                    span.setAttribute("style", "display: inline-block;border: 1px solid black;" + (width != null ? "width: " + width + ";" : "") + (height != null ? "height: " + height + ";" : ""));
                    node.insertBefore(span, select);
                    break;
                }
            }
            node.removeChild(select);
        }
    }

    private void convertInputToVisibleHTML(Document doc) {
        NodeList nl = doc.getElementsByTagName("input");
        while (nl.getLength() > 0) {
            Element span;
            Element input = (Element)nl.item(0);
            String type = input.getAttribute("type");
            Node node = input.getParentNode();
            if ("image".equalsIgnoreCase(type)) {
                Element img = doc.createElement("img");
                img.setAttribute("src", input.getAttribute("src"));
                img.setAttribute("alt", input.getAttribute("alt"));
                node.insertBefore(img, input);
            } else if ("text".equalsIgnoreCase(type) || "password".equalsIgnoreCase(type) || "button".equalsIgnoreCase(type)) {
                String style = input.getAttribute("style");
                String width = null;
                String height = null;
                if (style.indexOf("width") != -1) {
                    width = style.substring(style.indexOf("width") + 5);
                    if (width.indexOf(58) != -1) {
                        width = width.substring(width.indexOf(58));
                    }
                    if (width.indexOf(59) != -1) {
                        width = width.substring(0, width.indexOf(59));
                    }
                }
                if (width == null) {
                    width = "100px";
                }
                if (style.indexOf("height") != -1) {
                    height = style.substring(style.indexOf("height") + 6);
                    if (height.indexOf(58) != -1) {
                        height = height.substring(height.indexOf(58));
                    }
                    if (height.indexOf(59) != -1) {
                        height = height.substring(0, height.indexOf(59));
                    }
                }
                if (height == null) {
                    height = "16px";
                }
                Element span2 = doc.createElement("span");
                span2.setTextContent(input.getAttribute("value"));
                span2.setAttribute("style", "display: inline-block;border: 1px solid black;" + (width != null ? "width: " + width + ";" : "") + (height != null ? "height: " + height + ";" : "") + ("button".equalsIgnoreCase(type) ? "background-color: #DDDDDD;" : ""));
                node.insertBefore(span2, input);
            } else if ("radio".equalsIgnoreCase(type)) {
                span = doc.createElement("span");
                span.setTextContent("\u00a0");
                if ("checked".equalsIgnoreCase(input.getAttribute("checked"))) {
                    span.setAttribute("style", "display: inline-block;width: 10px;background-color: black;height: 10px;border: 1px solid black;");
                } else {
                    span.setAttribute("style", "display: inline-block;width: 10px;height: 10px;border: 1px solid black;");
                }
                node.insertBefore(span, input);
            } else if ("checkbox".equalsIgnoreCase(type)) {
                span = doc.createElement("span");
                span.setTextContent("\u00a0");
                if ("checked".equalsIgnoreCase(input.getAttribute("checked"))) {
                    span.setAttribute("style", "display: inline-block;width: 10px;background-color: black;height: 10px;border: 1px solid black;");
                } else {
                    span.setAttribute("style", "display: inline-block;width: 10px;height: 10px;border: 1px solid black;");
                }
                node.insertBefore(span, input);
            }
            node.removeChild(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertTextAreaToVisibleHTML(Document doc) {
        NodeList nl = doc.getElementsByTagName("textarea");
        while (nl.getLength() > 0) {
            Element textarea = (Element)nl.item(0);
            Node node = textarea.getParentNode();
            String style = textarea.getAttribute("style");
            String width = null;
            String height = null;
            if (style.indexOf("display:none") != -1 || style.indexOf("display: none") != -1 || style.indexOf("visibility:hidden") != -1 || style.indexOf("visibility: hidden") != -1) {
                node.removeChild(textarea);
                continue;
            }
            if (style.indexOf("width") != -1) {
                width = style.substring(style.indexOf("width") + 5);
                if (width.indexOf(58) != -1) {
                    width = width.substring(width.indexOf(58));
                }
                if (width.indexOf(59) != -1) {
                    width = width.substring(0, width.indexOf(59));
                }
            }
            if (width == null) {
                width = "100px";
            }
            if (style.indexOf("height") != -1) {
                height = style.substring(style.indexOf("height") + 6);
                if (height.indexOf(58) != -1) {
                    height = height.substring(height.indexOf(58));
                }
                if (height.indexOf(59) != -1) {
                    height = height.substring(0, height.indexOf(59));
                }
            }
            if (height == null) {
                height = "50px";
            }
            Element span = doc.createElement("span");
            span.setAttribute("style", "display: inline-block;border: 1px solid black;" + (width != null ? "width: " + width + ";" : "") + (height != null ? "height: " + height + ";" : ""));
            node.insertBefore(span, textarea);
            String content = textarea.getTextContent();
            BufferedReader reader = new BufferedReader(new StringReader(content));
            node.removeChild(textarea);
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Element econtent = doc.createElement("span");
                    econtent.setTextContent(line);
                    Element br = doc.createElement("br");
                    span.appendChild(econtent);
                    span.appendChild(br);
                }
            }
            catch (IOException ignore) {}
            continue;
            finally {
                try {
                    reader.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private CShaniDomParser getCShaniDomParser() {
        Reference ref = (Reference)this.tlparser.get();
        CShaniDomParser parser = ref == null ? null : ref.get();
        if (parser != null) {
            return parser;
        }
        CShaniDomParser ret = new CShaniDomParser(true, false);
        ret.setAutodoctype(false);
        ret.setIgnoreDTD(true);
        this.tlparser.set(new SoftReference<CShaniDomParser>(ret));
        return ret;
    }

    private _ITextRenderer getITextRenderer() {
        Reference ref = (Reference)this.tlrenderer.get();
        _ITextRenderer renderer = ref == null ? null : ref.get();
        if (renderer != null) {
            return renderer;
        }
        _ITextRenderer ret = new _ITextRenderer();
        this.tlrenderer.set(new SoftReference<_ITextRenderer>(ret));
        return ret;
    }

    private Tidy getTidy() {
        Reference ref = (Reference)this.tltidy.get();
        Tidy tidy = ref == null ? null : ref.get();
        if (tidy != null) {
            return tidy;
        }
        Tidy ret = new Tidy();
        ret.setInputEncoding("utf-8");
        ret.setXHTML(true);
        ret.setQuiet(true);
        ret.setShowWarnings(false);
        ret.setXmlOut(true);
        ret.setFixComments(true);
        ret.setEscapeCdata(true);
        ret.setMakeBare(true);
        ret.setMakeClean(true);
        ret.setFixBackslash(true);
        ret.setIndentContent(true);
        ret.setLogicalEmphasis(true);
        ret.setJoinClasses(true);
        ret.setJoinStyles(true);
        ret.setDocType("strict");
        ret.setErrout(new PrintWriter(new Writer(){

            public void close() throws IOException {
            }

            public void flush() throws IOException {
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
            }
        }));
        this.tltidy.set(new SoftReference<Tidy>(ret));
        return ret;
    }

    private String normalizeLink(String base, String href) {
        if (href.indexOf("//") == -1) {
            if (base != null) {
                if (href.startsWith("/")) {
                    String scheme = base.substring(0, base.indexOf("://"));
                    if ((base = base.substring(base.indexOf("://") + 3)).indexOf(47) != -1) {
                        String host = base.substring(0, base.indexOf(47));
                        href = scheme + "://" + host + href;
                    } else {
                        href = scheme + "://" + base + href;
                    }
                } else if (href.startsWith("../")) {
                    String scheme = base.substring(0, base.indexOf("://"));
                    String host = base.substring(base.indexOf("://") + 3);
                    if (host.indexOf(47) != -1) {
                        host = host.substring(0, host.indexOf(47));
                    }
                    if (base.indexOf(47) != -1) {
                        base = base.substring(0, base.lastIndexOf(47));
                    }
                    while (href.startsWith("../")) {
                        href = href.substring(3);
                        if (base.lastIndexOf(47) == -1) continue;
                        base = base.substring(0, base.lastIndexOf(47));
                    }
                    base = base.indexOf(host) == -1 ? scheme + "://" + host + "/" : base + "/";
                    href = base + href;
                } else {
                    base = base.substring(0, base.lastIndexOf(47) + 1);
                    href = base + href;
                }
            }
        } else if (href.startsWith("//")) {
            href = "http:" + href;
        }
        return href;
    }

    public final void transform(InputStream in, String urlForBase, IHtmlToPdfTransformer.PageSize size, List hf, Map properties, OutputStream out) throws IHtmlToPdfTransformer.CConvertException {
        ArrayList<File> files = new ArrayList<File>();
        try {
            Tidy tidy = this.getTidy();
            CShaniDomParser parser = this.getCShaniDomParser();
            _ITextRenderer renderer = this.getITextRenderer();
            Reader r = CXmlParser.getReader((InputStream)in);
            StringBuffer s = new StringBuffer();
            char[] buffer = new char[2048];
            int inb = -1;
            while ((inb = r.read(buffer)) != -1) {
                s.append(buffer, 0, inb);
            }
            r.close();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            tidy.parse((InputStream)new ByteArrayInputStream(s.toString().getBytes("utf-8")), (OutputStream)bout);
            String result = CHtmlToPdfFlyingSaucerTransformer.removeScript(new String(bout.toByteArray(), "utf-8"));
            Document theDoc = parser.parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(result.getBytes("utf-8")), "utf-8"));
            if (theDoc.toString().length() == 0) {
                theDoc = parser.parse((Reader)new StringReader(CHtmlToPdfFlyingSaucerTransformer.removeScript(s.toString())));
            }
            this.convertInputToVisibleHTML(theDoc);
            this.convertComboboxToVisibleHTML(theDoc);
            this.convertTextAreaToVisibleHTML(theDoc);
            NodeList styles = theDoc.getElementsByTagName("style");
            for (int i = 0; i < styles.getLength(); ++i) {
                Node n = styles.item(i);
                StringBuffer style = new StringBuffer();
                while (n.getChildNodes().getLength() > 0) {
                    CharacterData c;
                    Node child = n.getChildNodes().item(0);
                    if (child.getNodeType() == 8) {
                        c = (Comment)child;
                        style.append(c.getData());
                    } else if (child.getNodeType() == 3) {
                        c = (Text)child;
                        style.append(c.getData());
                    } else if (child.getNodeType() == 4) {
                        c = (CDATASection)child;
                        style.append(c.getData());
                    }
                    n.removeChild(child);
                }
                String content = style.toString().trim();
                Text start = theDoc.createTextNode("/*");
                CDATASection cd = theDoc.createCDATASection("*/\n" + content + "\n/*");
                Text end = theDoc.createTextNode("*/\n");
                n.appendChild(start);
                n.appendChild(cd);
                n.appendChild(end);
            }
            ArrayList<Node> toRemove = new ArrayList<Node>();
            NodeList tnl = theDoc.getChildNodes();
            for (int i = 0; i < tnl.getLength(); ++i) {
                Node n = tnl.item(i);
                if (n == theDoc.getDocumentElement()) continue;
                toRemove.add(n);
            }
            Node title = theDoc.getDocumentElement().getElementsByTagName("title").item(0);
            if (title != null && properties.get("yahp.PDF_TITLE") == null) {
                properties.put("yahp.PDF_TITLE", title.getTextContent());
            }
            Node body = theDoc.getDocumentElement().getElementsByTagName("body").item(0);
            Node head = theDoc.getDocumentElement().getElementsByTagName("head").item(0);
            for (int i = 0; i < toRemove.size(); ++i) {
                Text t;
                Node n = (Node)toRemove.get(i);
                n.getParentNode().removeChild(n);
                if (n.getNodeType() == 3 && (t = (Text)n).getData().trim().length() == 0) continue;
                if ("link".equals(n.getNodeName()) || "style".equals(n.getNodeName())) {
                    head.appendChild(n);
                    continue;
                }
                body.appendChild(n);
            }
            CDocumentCut.DocumentAndSize[] docs = CDocumentCut.cut((Document)theDoc, (IHtmlToPdfTransformer.PageSize)size);
            for (int jj = 0; jj < docs.length; ++jj) {
                File dir;
                NodeList nl;
                Document mydoc = docs[jj].doc;
                body = mydoc.getDocumentElement().getElementsByTagName("body").item(0);
                head = mydoc.getDocumentElement().getElementsByTagName("head").item(0);
                try {
                    String surlForBase = ((Element)mydoc.getElementsByTagName("base").item(0)).getAttribute("href");
                    if (surlForBase == null || "".equals(surlForBase)) {
                        surlForBase = null;
                    }
                    if (surlForBase != null) {
                        urlForBase = surlForBase;
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (urlForBase != null) {
                    ((ADocument)mydoc).setDocumentURI(urlForBase);
                }
                if ((nl = mydoc.getElementsByTagName("base")).getLength() == 0) {
                    ADocument doc = (ADocument)mydoc;
                    Element base = doc.createElement("base");
                    base.setAttribute("href", urlForBase);
                    if (head.getFirstChild() != null) {
                        head.insertBefore(base, head.getFirstChild());
                    } else {
                        head.appendChild(base);
                    }
                } else {
                    Element base = (Element)nl.item(0);
                    base.setAttribute("href", urlForBase);
                }
                NumberFormat nf = NumberFormat.getInstance(Locale.US);
                nf.setMaximumFractionDigits(2);
                nf.setMinimumFractionDigits(0);
                Element style = mydoc.createElement("style");
                style.setAttribute("type", "text/css");
                double[] dsize = docs[jj].size.getCMSize();
                double[] dmargin = docs[jj].size.getCMMargin();
                style.setTextContent("\n@page {\nsize: " + nf.format(dsize[0] / 2.54) + "in " + nf.format(dsize[1] / 2.54) + "in;\n" + "margin-left: " + nf.format(dmargin[0] / 2.54) + "in;\n" + "margin-right: " + nf.format(dmargin[1] / 2.54) + "in;\n" + "margin-bottom: " + nf.format(dmargin[2] / 2.54) + "in;\n" + "margin-top: " + nf.format(dmargin[3] / 2.54) + "in;\npadding: 0in;\n" + "}\n");
                head.appendChild(style);
                if (properties.get("yahp.FOP_TTF_FONT_PATH") != null && (dir = new File((String)properties.get("yahp.FOP_TTF_FONT_PATH"))).isDirectory()) {
                    CHtmlToPdfFlyingSaucerTransformer.registerTTF(dir, renderer);
                }
                ((ADocument)mydoc).setInputEncoding("utf-8");
                ((ADocument)mydoc).setXmlEncoding("utf-8");
                renderer.getSharedContext().setBaseURL(urlForBase);
                mydoc = parser.parse((Reader)new StringReader(mydoc.toString()));
                mydoc.getDomConfig().setParameter("entities", Boolean.FALSE);
                mydoc.normalizeDocument();
                renderer.setDocument(mydoc, urlForBase);
                renderer.layout();
                File f = File.createTempFile("pdf", "yahp");
                files.add(f);
                BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(f));
                renderer.createPDF(fout, true);
                ((OutputStream)fout).flush();
                ((OutputStream)fout).close();
            }
            IHtmlToPdfTransformer.PageSize[] sizes = new IHtmlToPdfTransformer.PageSize[docs.length];
            for (int i = 0; i < docs.length; ++i) {
                sizes[i] = docs[i].size;
            }
            CDocumentReconstructor.reconstruct(files, (Map)properties, (OutputStream)out, (String)urlForBase, (String)"Flying Saucer Renderer (https://xhtmlrenderer.dev.java.net/)", (IHtmlToPdfTransformer.PageSize[])sizes, (List)hf);
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new IHtmlToPdfTransformer.CConvertException("ERROR: An unhandled exception occured: " + e.getMessage(), e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception ignore) {}
            for (File f : files) {
                try {
                    f.delete();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private static class _ITextRenderer
    extends ITextRenderer {
        private final Map knownFont = new HashMap();

        private _ITextRenderer() {
        }

        private void addKnown(String path) {
            this.knownFont.put(path, path);
        }

        private boolean isKnown(String path) {
            return this.knownFont.get(path) != null;
        }
    }
}

