/*
 * Decompiled with CFR 0.152.
 */
package play.modules.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.allcolor.yahp.converter.IHtmlToPdfTransformer;
import org.apache.commons.lang.StringUtils;
import play.Logger;
import play.Play;
import play.exceptions.TemplateNotFoundException;
import play.exceptions.UnexpectedException;
import play.modules.pdf.PDF;
import play.mvc.Http;
import play.mvc.results.Result;
import play.templates.Template;
import play.templates.TemplateLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderPDFTemplate
extends Result {
    private static final long serialVersionUID = 6238738409770109140L;
    protected static IHtmlToPdfTransformer transformer;
    private PDF.MultiPDFDocuments docs;

    public RenderPDFTemplate(PDF.MultiPDFDocuments docs, Map<String, Object> args) throws TemplateNotFoundException {
        this.docs = docs;
        this.renderDocuments(args);
    }

    private void renderDocuments(Map<String, Object> args) {
        for (PDF.PDFDocument doc : this.docs.documents) {
            Http.Request request = Http.Request.current();
            String templateName = PDF.resolveTemplateName(doc.template, request, request.format);
            Template template = TemplateLoader.load((String)templateName);
            doc.args.putAll(args);
            doc.content = template.render(new HashMap<String, Object>(doc.args));
            this.loadHeaderAndFooter(doc, doc.args);
        }
    }

    private void loadHeaderAndFooter(PDF.PDFDocument doc, Map<String, Object> args) throws TemplateNotFoundException {
        Template template;
        PDF.Options options = doc.options;
        if (options == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)options.HEADER_TEMPLATE)) {
            template = TemplateLoader.load((String)options.HEADER_TEMPLATE);
            options.HEADER = template.render(new HashMap<String, Object>(args));
        }
        if (!StringUtils.isEmpty((String)options.FOOTER_TEMPLATE)) {
            template = TemplateLoader.load((String)options.FOOTER_TEMPLATE);
            options.FOOTER = template.render(new HashMap<String, Object>(args));
        }
        if (!StringUtils.isEmpty((String)options.HEADER)) {
            doc.headerFooterList.add(new IHtmlToPdfTransformer.CHeaderFooter(options.HEADER, "header"));
        }
        if (!StringUtils.isEmpty((String)options.ALL_PAGES)) {
            doc.headerFooterList.add(new IHtmlToPdfTransformer.CHeaderFooter(options.ALL_PAGES, "all"));
        }
        if (!StringUtils.isEmpty((String)options.EVEN_PAGES)) {
            doc.headerFooterList.add(new IHtmlToPdfTransformer.CHeaderFooter(options.EVEN_PAGES, "even"));
        }
        if (!StringUtils.isEmpty((String)options.FOOTER)) {
            doc.headerFooterList.add(new IHtmlToPdfTransformer.CHeaderFooter(options.FOOTER, "footer"));
        }
        if (!StringUtils.isEmpty((String)options.ODD_PAGES)) {
            doc.headerFooterList.add(new IHtmlToPdfTransformer.CHeaderFooter(options.ODD_PAGES, "odd"));
        }
    }

    public void apply(Http.Request request, Http.Response response) {
        try {
            response.setHeader("Content-Disposition", "inline; filename=\"" + this.docs.filename + "\"");
            this.setContentTypeIfNotSet(response, "application/pdf");
            if (request.secure.booleanValue() && this.isIE(request)) {
                response.setHeader("Cache-Control", "");
            }
            this.renderPDF(response.out, request, response);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private boolean isIE(Http.Request request) {
        if (!request.headers.containsKey("user-agent")) {
            return false;
        }
        Http.Header userAgent = (Http.Header)request.headers.get("user-agent");
        return userAgent.value().contains("MSIE");
    }

    private void renderPDF(OutputStream out, Http.Request request, Http.Response response) throws Exception {
        Properties properties = Play.configuration;
        String uri = request.getBase() + request.url;
        if (this.docs.documents.size() == 1) {
            this.renderDoc(this.docs.documents.get(0), uri, properties, out);
        } else {
            Document resultDocument = new Document();
            PdfCopy copy = new PdfCopy(resultDocument, out);
            resultDocument.open();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (PDF.PDFDocument doc : this.docs.documents) {
                os.reset();
                this.renderDoc(doc, uri, properties, os);
                PdfReader pdfReader = new PdfReader(os.toByteArray());
                int n = pdfReader.getNumberOfPages();
                for (int i = 0; i < n; ++i) {
                    copy.addPage(copy.getImportedPage(pdfReader, i + 1));
                }
                copy.freeReader(pdfReader);
            }
            resultDocument.close();
        }
    }

    private void renderDoc(PDF.PDFDocument doc, String uri, Map<?, ?> properties, OutputStream out) throws Exception {
        IHtmlToPdfTransformer.PageSize pageSize = doc.options != null ? doc.options.pageSize : IHtmlToPdfTransformer.A4P;
        transformer.transform((InputStream)new ByteArrayInputStream(doc.content.getBytes("UTF-8")), uri, pageSize, doc.headerFooterList, properties, out);
    }

    public void writePDF(OutputStream out, Http.Request request, Http.Response response) {
        try {
            this.renderPDF(out, request, response);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    static {
        try {
            transformer = (IHtmlToPdfTransformer)Play.classloader.loadClass("org.allcolor.yahp.cl.converter.CHtmlToPdfFlyingSaucerTransformer").newInstance();
        }
        catch (Exception e) {
            Logger.error((String)"Exception initializing pdf module", (Object[])new Object[]{e});
        }
    }
}

