/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessException
extends Exception {
    private static final long serialVersionUID = 662552833197468936L;
    private String errorType;
    private String filename;
    private int line;
    private int column;
    private List<String> extract;

    public LessException() {
    }

    public LessException(String message) {
        super(message);
    }

    public LessException(String message, Throwable e) {
        super(message, e);
    }

    public LessException(String message, String errorType, String filename, int line, int column, List<String> extract) {
        super(message);
        this.errorType = errorType != null ? errorType : "LESS Error";
        this.filename = filename;
        this.line = line;
        this.column = column;
        this.extract = extract;
    }

    public LessException(Throwable e) {
        super(e);
    }

    @Override
    public String getMessage() {
        if (this.errorType != null) {
            String msg = String.format("%s: %s (line %s, column %s)", this.errorType, super.getMessage(), this.line, this.column);
            if (this.extract != null && !this.extract.isEmpty()) {
                msg = msg + " near";
                for (String l : this.extract) {
                    msg = msg + "\n" + l;
                }
            }
            return msg;
        }
        return super.getMessage();
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public List<String> getExtract() {
        return this.extract;
    }
}

