/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.tag;

import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.tag.BaseTag;
import net.sf.jxls.tag.Block;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.SheetTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Sheet;

public class OutlineTag
extends BaseTag {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String TAG_NAME = "outline";
    private boolean detail;

    public OutlineTag() {
        this.name = TAG_NAME;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }

    public ResultTransformation process(SheetTransformer sheetTransformer) {
        Block body;
        if (this.log.isDebugEnabled()) {
            this.log.info((Object)"jx:outline tag processing..");
        }
        if ((body = this.tagContext.getTagBody()).getNumberOfRows() == 1) {
            this.log.warn((Object)"jx:outline for columns is not supported. Ignoring.");
        }
        int shiftNumber = 0;
        ResultTransformation shift = new ResultTransformation(0);
        this.tagContext.getSheetTransformationController().removeBorders(body);
        shiftNumber -= 2;
        try {
            ResultTransformation processResult = sheetTransformer.processRows(this.tagContext.getSheetTransformationController(), this.tagContext.getSheet(), body.getStartRowNum(), body.getEndRowNum(), this.tagContext.getBeans(), null);
            if (body.getStartRowNum() <= body.getEndRowNum() + processResult.getLastRowShift()) {
                this.groupRows(body.getStartRowNum(), body.getEndRowNum() + processResult.getLastRowShift());
            }
            shift.add(processResult);
        }
        catch (ParsePropertyException e) {
            this.log.error((Object)"Can't parse property ", (Throwable)e);
        }
        return shift.add(new ResultTransformation(0, shiftNumber));
    }

    private void groupRows(int startRowNum, int endRowNum) {
        Sheet hssfSheet = this.tagContext.getSheet().getPoiSheet();
        hssfSheet.groupRow(startRowNum, endRowNum);
        hssfSheet.setRowGroupCollapsed(startRowNum, !this.detail);
    }
}

