/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.RanChangeSet;
import liquibase.exception.RollbackFailedException;
import liquibase.parser.filter.ChangeSetFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AfterTagChangeSetFilter
implements ChangeSetFilter {
    private Set<String> changeLogsAfterTag = new HashSet<String>();

    public AfterTagChangeSetFilter(String tag, List<RanChangeSet> ranChangeSets) throws RollbackFailedException {
        boolean seenTag = false;
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            if (seenTag && !tag.equalsIgnoreCase(ranChangeSet.getTag())) {
                this.changeLogsAfterTag.add(this.changeLogToString(ranChangeSet.getId(), ranChangeSet.getAuthor(), ranChangeSet.getChangeLog()));
            }
            if (seenTag || !tag.equalsIgnoreCase(ranChangeSet.getTag())) continue;
            seenTag = true;
        }
        if (!seenTag) {
            throw new RollbackFailedException("Could not find tag '" + tag + "' in the database");
        }
    }

    private String changeLogToString(String id, String author, String changeLog) {
        return id + ":" + author + ":" + changeLog;
    }

    @Override
    public boolean accepts(ChangeSet changeSet) {
        return this.changeLogsAfterTag.contains(this.changeLogToString(changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()));
    }
}

