/*
 * Decompiled with CFR 0.152.
 */
package play.modules.liquibase;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import liquibase.ClassLoaderFileOpener;
import liquibase.FileOpener;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.DB;
import play.modules.liquibase.LiquibaseUpdateException;
import play.utils.Properties;

public class LiquibasePlugin
extends PlayPlugin {
    public void onApplicationStart() {
        String autoupdate = Play.configuration.getProperty("liquibase.active");
        String mainchangelogpath = Play.configuration.getProperty("liquibase.changelog", "mainchangelog.xml");
        String propertiespath = Play.configuration.getProperty("liquibase.properties", "liquibase.properties");
        String contexts = Play.configuration.getProperty("liquibase.contexts");
        if (null != autoupdate && "true".equals(autoupdate)) {
            Logger.info((String)"Auto update flag found and positive => let's get on with changelog update", (Object[])new Object[0]);
            try {
                Connection cnx = DB.datasource.getConnection();
                cnx.setAutoCommit(false);
                Liquibase liquibase = new Liquibase(mainchangelogpath, (FileOpener)new ClassLoaderFileOpener(), cnx);
                InputStream stream = Play.classloader.getResourceAsStream(propertiespath);
                if (null != stream) {
                    Properties props = new Properties();
                    props.load(stream);
                    for (String key : props.keySet()) {
                        String val = (String)props.get((Object)key);
                        Logger.info((String)"found parameter [%1$s] /\u00ac\u2020[%2$s] for liquibase update", (Object[])new Object[]{key, val});
                        liquibase.setChangeLogParameterValue(key, (Object)val);
                    }
                } else {
                    Logger.warn((String)"Could not find properties file [%s]", (Object[])new Object[]{propertiespath});
                }
                Logger.info((String)"Ready for database diff generation", (Object[])new Object[0]);
                liquibase.changeLogSync(contexts);
                Logger.info((String)"Changelog Execution performed", (Object[])new Object[0]);
            }
            catch (SQLException sqle) {
                throw new LiquibaseUpdateException(sqle.getMessage());
            }
            catch (LiquibaseException e) {
                throw new LiquibaseUpdateException(e.getMessage());
            }
            catch (IOException ioe) {
                throw new LiquibaseUpdateException(ioe.getMessage());
            }
        } else {
            Logger.info((String)"Auto update flag set to false or not available => skipping structural update", (Object[])new Object[0]);
        }
    }
}

