/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.SqlDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDatabaseSnapshot
extends SqlDatabaseSnapshot {
    private static Map<String, Map<String, List<String>>> schemaCache = new HashMap<String, Map<String, List<String>>>();

    public MySqlDatabaseSnapshot() {
    }

    public MySqlDatabaseSnapshot(Database database) throws JDBCException {
        this(database, null, null);
    }

    public MySqlDatabaseSnapshot(Database database, String schema) throws JDBCException {
        this(database, null, schema);
    }

    public MySqlDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners) throws JDBCException {
        this(database, statusListeners, database.getDefaultSchemaName());
    }

    public MySqlDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners, String requestedSchema) throws JDBCException {
        super(database, statusListeners, requestedSchema);
    }

    @Override
    protected void getColumnTypeAndDefValue(Column columnInfo, ResultSet rs, Database database) throws SQLException, JDBCException {
        String columnTypeName = rs.getString("TYPE_NAME");
        String columnName = rs.getString("COLUMN_NAME");
        String tableName = rs.getString("TABLE_NAME");
        String schemaName = rs.getString("TABLE_CAT");
        Map<Object, Object> tableSchema = new HashMap();
        if (!schemaCache.containsKey(tableName)) {
            Statement selectStatement = database.getConnection().createStatement();
            ResultSet rsColumnType = selectStatement.executeQuery("DESC " + database.escapeTableName(schemaName, tableName));
            while (rsColumnType.next()) {
                ArrayList<String> colSchema = new ArrayList<String>();
                colSchema.add(rsColumnType.getString("Type"));
                colSchema.add(rsColumnType.getString("Default"));
                tableSchema.put(rsColumnType.getString("Field"), colSchema);
            }
            rsColumnType.close();
            schemaCache.put(tableName, tableSchema);
        }
        tableSchema = schemaCache.get(tableName);
        if (columnTypeName.toLowerCase().startsWith("enum") || columnTypeName.toLowerCase().startsWith("set")) {
            columnInfo.setTypeName((String)((List)tableSchema.get(columnName)).get(0));
            try {
                String tmpDefaultValue = (String)database.convertDatabaseValueToJavaObject(((List)tableSchema.get(columnName)).get(1), columnInfo.getDataType(), columnInfo.getColumnSize(), columnInfo.getDecimalDigits());
                if ("".equals(tmpDefaultValue)) {
                    columnInfo.setDefaultValue(null);
                }
                columnInfo.setDefaultValue(tmpDefaultValue);
            }
            catch (ParseException e) {
                throw new JDBCException(e);
            }
        } else if (columnTypeName.toLowerCase().equals("text") || columnTypeName.toLowerCase().equals("blob")) {
            columnInfo.setTypeName(columnTypeName);
            columnInfo.setDefaultValue(null);
        } else if (columnTypeName.toLowerCase().equals("timestamp") && !"CURRENT_TIMESTAMP".equals(((List)tableSchema.get(columnName)).get(1))) {
            columnInfo.setTypeName(columnTypeName);
            columnInfo.setDefaultValue(((List)tableSchema.get(columnName)).get(1));
        } else {
            super.getColumnTypeAndDefValue(columnInfo, rs, database);
        }
    }

    @Override
    protected String convertPrimaryKeyName(String pkName) throws SQLException {
        if (pkName.equals("PRIMARY")) {
            return null;
        }
        return pkName;
    }
}

