/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
implements DatabaseObject,
Comparable<Index> {
    private String name;
    private Table table;
    private Boolean unique;
    private List<String> columns = new ArrayList<String>();
    private String filterCondition;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getColumnNames() {
        return StringUtils.join(this.columns, ", ");
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public void setUnique(Boolean value) {
        this.unique = value;
    }

    public Boolean isUnique() {
        return this.unique;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        boolean equals = true;
        for (String column : index.getColumns()) {
            if (this.columns.contains(column)) continue;
            equals = false;
        }
        if (this.unique != null || index.isUnique() != null) {
            if (this.unique == null && index.isUnique() != null) {
                equals = false;
            } else if (this.unique != null && index.isUnique() == null) {
                equals = false;
            } else if (!this.unique.equals(index.isUnique())) {
                equals = false;
            }
        }
        return equals || this.table.getName().equalsIgnoreCase(index.table.getName());
    }

    public int hashCode() {
        int result = this.table.getName().toUpperCase().hashCode();
        result = 31 * result + ((Object)this.columns).hashCode();
        result = 31 * result + (this.unique == null || this.unique != false ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(Index o) {
        int returnValue = this.table.getName().compareTo(o.table.getName());
        if (returnValue == 0) {
            returnValue = this.getName().compareTo(o.getName());
        }
        return returnValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        if (!this.unique.booleanValue()) {
            stringBuffer.append(" unique ");
        }
        stringBuffer.append(" on ").append(this.table.getName()).append("(");
        for (String column : this.columns) {
            stringBuffer.append(column).append(", ");
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

