/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.sql.CallableSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.template.CallableStatementCallback;
import liquibase.database.template.ColumnMapRowMapper;
import liquibase.database.template.ResultSetExtractor;
import liquibase.database.template.RowCallbackHandler;
import liquibase.database.template.RowMapper;
import liquibase.database.template.RowMapperResultSetExtractor;
import liquibase.database.template.SingleColumnRowMapper;
import liquibase.database.template.StatementCallback;
import liquibase.exception.JDBCException;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.log.LogFactory;
import liquibase.util.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTemplate {
    protected Database database;

    public JdbcTemplate(Database database) {
        this.database = database;
    }

    public boolean executesStatements() {
        return true;
    }

    public Object execute(StatementCallback action, List<SqlVisitor> sqlVisitors) throws JDBCException {
        DatabaseConnection con = this.database.getConnection();
        Statement stmt = null;
        try {
            Statement stmtToUse = stmt = con.createStatement();
            Object object = action.doInStatement(stmtToUse);
            return object;
        }
        catch (SQLException ex) {
            JdbcUtils.closeStatement(stmt);
            stmt = null;
            throw new JDBCException("Error executing SQL " + this.applyVisitors(action.getStatement(), sqlVisitors), ex);
        }
        finally {
            JdbcUtils.closeStatement(stmt);
        }
    }

    public void execute(SqlStatement sql) throws JDBCException {
        this.execute(sql, new ArrayList<SqlVisitor>());
    }

    public void execute(final SqlStatement sql, final List<SqlVisitor> sqlVisitors) throws JDBCException {
        if (sql instanceof CallableSqlStatement) {
            this.call((CallableSqlStatement)sql, new ArrayList(), sqlVisitors);
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ExecuteStatementCallback
        implements StatementCallback {
            ExecuteStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException, JDBCException {
                String statement = JdbcTemplate.this.applyVisitors(sql, sqlVisitors);
                stmt.execute(statement);
                return null;
            }

            @Override
            public SqlStatement getStatement() {
                return sql;
            }
        }
        this.execute(new ExecuteStatementCallback(), sqlVisitors);
    }

    protected String applyVisitors(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws StatementNotSupportedOnDatabaseException {
        String returnSql = sql.getSqlStatement(this.database);
        for (SqlVisitor visitor : sqlVisitors) {
            if (!visitor.isApplicable(this.database)) continue;
            returnSql = visitor.modifySql(returnSql, this.database);
        }
        return returnSql;
    }

    public Object query(SqlStatement sql, ResultSetExtractor rse) throws JDBCException {
        return this.query(sql, rse, new ArrayList<SqlVisitor>());
    }

    public Object query(final SqlStatement sql, final ResultSetExtractor rse, final List<SqlVisitor> sqlVisitors) throws JDBCException {
        if (sql instanceof CallableSqlStatement) {
            throw new JDBCException("Direct query using CallableSqlStatement not currently implemented");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class QueryStatementCallback
        implements StatementCallback {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInStatement(Statement stmt) throws SQLException, JDBCException {
                Object object;
                ResultSet rs = null;
                try {
                    ResultSet rsToUse = rs = stmt.executeQuery(JdbcTemplate.this.applyVisitors(sql, sqlVisitors));
                    object = rse.extractData(rsToUse);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable;
                }
                JdbcUtils.closeResultSet(rs);
                return object;
            }

            @Override
            public SqlStatement getStatement() {
                return sql;
            }
        }
        return this.execute(new QueryStatementCallback(), sqlVisitors);
    }

    public List query(SqlStatement sql, RowMapper rowMapper) throws JDBCException {
        return this.query(sql, rowMapper, new ArrayList<SqlVisitor>());
    }

    public List query(SqlStatement sql, RowMapper rowMapper, List<SqlVisitor> sqlVisitors) throws JDBCException {
        return (List)this.query(sql, new RowMapperResultSetExtractor(rowMapper), sqlVisitors);
    }

    public Object queryForObject(SqlStatement sql, RowMapper rowMapper) throws JDBCException {
        return this.queryForObject(sql, rowMapper, new ArrayList<SqlVisitor>());
    }

    public Object queryForObject(SqlStatement sql, RowMapper rowMapper, List<SqlVisitor> sqlVisitors) throws JDBCException {
        List results = this.query(sql, rowMapper, sqlVisitors);
        return JdbcUtils.requiredSingleResult(results);
    }

    public Object queryForObject(SqlStatement sql, Class requiredType) throws JDBCException {
        return this.queryForObject(sql, requiredType, new ArrayList<SqlVisitor>());
    }

    public Object queryForObject(SqlStatement sql, Class requiredType, List<SqlVisitor> sqlVisitors) throws JDBCException {
        return this.queryForObject(sql, this.getSingleColumnRowMapper(requiredType), sqlVisitors);
    }

    public long queryForLong(SqlStatement sql) throws JDBCException {
        return this.queryForLong(sql, new ArrayList<SqlVisitor>());
    }

    public long queryForLong(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws JDBCException {
        Number number = (Number)this.queryForObject(sql, Long.class, sqlVisitors);
        return number != null ? number.longValue() : 0L;
    }

    public int queryForInt(SqlStatement sql) throws JDBCException {
        return this.queryForInt(sql, new ArrayList<SqlVisitor>());
    }

    public int queryForInt(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws JDBCException {
        Number number = (Number)this.queryForObject(sql, Integer.class, sqlVisitors);
        return number != null ? number.intValue() : 0;
    }

    public List queryForList(SqlStatement sql, Class elementType) throws JDBCException {
        return this.queryForList(sql, elementType, new ArrayList<SqlVisitor>());
    }

    public List queryForList(SqlStatement sql, Class elementType, List<SqlVisitor> sqlVisitors) throws JDBCException {
        return this.query(sql, this.getSingleColumnRowMapper(elementType), sqlVisitors);
    }

    public List<Map> queryForList(SqlStatement sql) throws JDBCException {
        return this.queryForList(sql, new ArrayList<SqlVisitor>());
    }

    public List<Map> queryForList(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws JDBCException {
        return this.query(sql, this.getColumnMapRowMapper(), sqlVisitors);
    }

    public int update(SqlStatement sql) throws JDBCException {
        return this.update(sql, new ArrayList<SqlVisitor>());
    }

    public int update(final SqlStatement sql, final List<SqlVisitor> sqlVisitors) throws JDBCException {
        if (sql instanceof CallableSqlStatement) {
            throw new JDBCException("Direct update using CallableSqlStatement not currently implemented");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UpdateStatementCallback
        implements StatementCallback {
            UpdateStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException, JDBCException {
                return stmt.executeUpdate(JdbcTemplate.this.applyVisitors(sql, sqlVisitors));
            }

            @Override
            public SqlStatement getStatement() {
                return sql;
            }
        }
        return (Integer)this.execute(new UpdateStatementCallback(), sqlVisitors);
    }

    public Object execute(CallableSqlStatement csc, CallableStatementCallback action, List<SqlVisitor> sqlVisitors) throws JDBCException {
        Object object;
        CallableStatement cs = null;
        try {
            CallableStatement csToUse = cs = csc.createCallableStatement(this.database);
            object = action.doInCallableStatement(csToUse);
        }
        catch (SQLException ex) {
            try {
                throw new JDBCException("Error executing callable statement", ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(cs);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(cs);
        return object;
    }

    public Map call(CallableSqlStatement csc, List declaredParameters, List<SqlVisitor> sqlVisitors) throws JDBCException {
        return (Map)this.execute(csc, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException {
                cs.execute();
                return new HashMap();
            }
        }, sqlVisitors);
    }

    protected RowMapper getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected RowMapper getSingleColumnRowMapper(Class requiredType) {
        return new SingleColumnRowMapper(requiredType);
    }

    public void comment(String message) throws JDBCException {
        LogFactory.getLogger().info(message);
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            return null;
        }
    }
}

