/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class SetTableRemarksStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String remarks;

    public SetTableRemarksStatement(String schemaName, String tableName, String remarks) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.remarks = remarks;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (database instanceof OracleDatabase) {
            return "COMMENT ON TABLE " + database.escapeTableName(this.schemaName, this.tableName) + " IS '" + this.remarks + "'";
        }
        return "ALTER TABLE " + database.escapeTableName(this.schemaName, this.tableName) + " COMMENT = '" + this.remarks + "'";
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return database instanceof MySQLDatabase || database instanceof OracleDatabase;
    }
}

