/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.sql;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.FileOpener;
import liquibase.change.RawSQLChange;
import liquibase.exception.ChangeLogParseException;
import liquibase.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlChangeLogGenerator {
    public DatabaseChangeLog generate(String physicalChangeLogLocation, FileOpener fileOpener, Map<String, Object> changeLogProperties) throws ChangeLogParseException {
        RawSQLChange change = new RawSQLChange();
        try {
            InputStream sqlStream = fileOpener.getResourceAsStream(physicalChangeLogLocation);
            String sql = StreamUtil.getStreamContents(sqlStream, null);
            change.setSql(sql);
        }
        catch (IOException e) {
            throw new ChangeLogParseException(e);
        }
        change.setFileOpener(fileOpener);
        change.setSplitStatements(false);
        change.setStripComments(false);
        ChangeSet changeSet = new ChangeSet("raw", "includeAll", false, false, physicalChangeLogLocation, physicalChangeLogLocation, null, null, false);
        changeSet.addChange(change);
        DatabaseChangeLog changeLog = new DatabaseChangeLog(physicalChangeLogLocation);
        changeLog.addChangeSet(changeSet);
        return changeLog;
    }
}

