/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import liquibase.Liquibase;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.util.ui.UIFactory;
import org.apache.tools.ant.BuildException;

public class DatabaseUpdateTestingRollbackTask
extends BaseLiquibaseTask {
    private boolean dropFirst = false;

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public void execute() throws BuildException {
        if (!this.shouldRun()) {
            return;
        }
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibase();
            if (this.isPromptOnNonLocalDatabase() && !liquibase.isSafeToRunMigration() && UIFactory.getInstance().getFacade().promptForNonLocalDatabase(liquibase.getDatabase())) {
                throw new BuildException("Chose not to run against non-production database");
            }
            if (this.isDropFirst()) {
                liquibase.dropAll();
            }
            liquibase.updateTestingRollback(this.getContexts());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }
}

