/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.lockservice.LockService;
import liquibase.logging.LogFactory;
import liquibase.logging.LogLevel;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    protected ClassLoader classLoader;
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String databaseClass;
    protected String defaultSchemaName;
    protected String changeLogFile;
    protected String classpath;
    protected String contexts;
    protected Boolean promptForNonLocalDatabase = null;
    protected Boolean includeSystemClasspath;
    protected String defaultsFile = "liquibase.properties";
    protected String diffTypes;
    protected String changeSetAuthor;
    protected String changeSetContext;
    protected String dataDir;
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String currentDateTimeFunction;
    protected String command;
    protected Set<String> commandParams = new HashSet<String>();
    protected String logLevel;
    protected String logFile;
    protected Map<String, Object> changeLogParameters = new HashMap<String, Object>();

    public static void main(String[] args) throws CommandLineParsingException, IOException {
        try {
            List<String> setupMessages;
            String shouldRunProperty = System.getProperty("liquibase.should.run");
            if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
                System.out.println("Liquibase did not run because 'liquibase.should.run' system property was set to false");
                return;
            }
            Main main = new Main();
            if (args.length == 1 && "--help".equals(args[0])) {
                main.printHelp(System.out);
                return;
            }
            if (args.length == 1 && "--version".equals(args[0])) {
                System.out.println("Liquibase Version: " + LiquibaseUtil.getBuildVersion() + StreamUtil.getLineSeparator());
                return;
            }
            try {
                main.parseOptions(args);
            }
            catch (CommandLineParsingException e) {
                main.printHelp(Arrays.asList(e.getMessage()), System.out);
                System.exit(-2);
            }
            File propertiesFile = new File(main.defaultsFile);
            File localPropertiesFile = new File(main.defaultsFile.replaceFirst("(\\.[^\\.]+)$", ".local$1"));
            if (localPropertiesFile.exists()) {
                main.parsePropertiesFile(new FileInputStream(localPropertiesFile));
            }
            if (propertiesFile.exists()) {
                main.parsePropertiesFile(new FileInputStream(propertiesFile));
            }
            if ((setupMessages = main.checkSetup()).size() > 0) {
                main.printHelp(setupMessages, System.out);
                return;
            }
            try {
                main.applyDefaults();
                main.configureClassLoader();
                main.doMigration();
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                if (message == null) {
                    message = "Unknown Reason";
                }
                if (e.getCause() instanceof ValidationFailedException) {
                    ((ValidationFailedException)e.getCause()).printDescriptiveError(System.out);
                } else {
                    System.out.println("Liquibase Update Failed: " + message);
                    LogFactory.getLogger().severe(message, e);
                    System.out.println(Main.generateLogLevelWarningMessage());
                }
                System.exit(-1);
            }
            if ("update".equals(main.command)) {
                System.out.println("Liquibase Update Successful");
            } else if (main.command.startsWith("rollback") && !main.command.endsWith("SQL")) {
                System.out.println("Liquibase Rollback Successful");
            }
        }
        catch (Throwable e) {
            String message = "Unexpected error running Liquibase: " + e.getMessage();
            System.out.println(message);
            try {
                LogFactory.getLogger().severe(message, e);
            }
            catch (Exception e1) {
                e.printStackTrace();
            }
            System.exit(-3);
        }
        System.exit(0);
    }

    private static String generateLogLevelWarningMessage() {
        Logger logger = LogFactory.getLogger();
        if (logger == null || logger.getLogLevel() == null || logger.getLogLevel().equals((Object)LogLevel.DEBUG)) {
            return "";
        }
        return "\n\nFor more information, use the --logLevel flag)";
    }

    protected String[] fixupArgs(String[] args) {
        ArrayList<String> fixedArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ((arg.startsWith("--") || arg.startsWith("-D")) && !arg.contains("=")) {
                String nextArg = null;
                if (i + 1 < args.length) {
                    nextArg = args[i + 1];
                }
                if (nextArg != null && !nextArg.startsWith("--") && !this.isCommand(nextArg)) {
                    arg = arg + "=" + nextArg;
                    ++i;
                }
            }
            fixedArgs.add(arg);
        }
        return fixedArgs.toArray(new String[fixedArgs.size()]);
    }

    protected List<String> checkSetup() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.command == null) {
            messages.add("Command not passed");
        } else if (!this.isCommand(this.command)) {
            messages.add("Unknown command: " + this.command);
        } else {
            if (this.url == null) {
                messages.add("--url is required");
            }
            if (this.isChangeLogRequired(this.command) && this.changeLogFile == null) {
                messages.add("--changeLog is required");
            }
        }
        return messages;
    }

    private boolean isChangeLogRequired(String command) {
        return command.toLowerCase().startsWith("update") || command.toLowerCase().startsWith("rollback") || "validate".equals(command);
    }

    private boolean isCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "updateCount".equalsIgnoreCase(arg) || "updateCountSQL".equalsIgnoreCase(arg) || "rollback".equalsIgnoreCase(arg) || "rollbackToDate".equalsIgnoreCase(arg) || "rollbackCount".equalsIgnoreCase(arg) || "rollbackSQL".equalsIgnoreCase(arg) || "rollbackToDateSQL".equalsIgnoreCase(arg) || "rollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "tag".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "status".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "diff".equalsIgnoreCase(arg) || "diffChangeLog".equalsIgnoreCase(arg) || "generateChangeLog".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "dbDoc".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg);
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws IOException, CommandLineParsingException {
        Properties props = new Properties();
        props.load(propertiesInputStream);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            try {
                if (entry.getKey().equals("promptOnNonLocalDatabase")) continue;
                if (((String)entry.getKey()).startsWith("parameter.")) {
                    this.changeLogParameters.put(((String)entry.getKey()).replaceFirst("^parameter.", ""), entry.getValue());
                    continue;
                }
                Field field = this.getClass().getDeclaredField((String)entry.getKey());
                Object currentValue = field.get(this);
                if (currentValue != null) continue;
                String value = entry.getValue().toString().trim();
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(value));
                    continue;
                }
                field.set(this, value);
            }
            catch (Exception e) {
                throw new CommandLineParsingException("Unknown parameter: '" + entry.getKey() + "'");
            }
        }
    }

    protected void printHelp(List<String> errorMessages, PrintStream stream) {
        stream.println("Errors:");
        for (String message : errorMessages) {
            stream.println("  " + message);
        }
        stream.println();
        this.printHelp(stream);
    }

    protected void printHelp(PrintStream stream) {
        stream.println("Usage: java -jar liquibase.jar [options] [command]");
        stream.println("");
        stream.println("Standard Commands:");
        stream.println(" update                         Updates database to current version");
        stream.println(" updateSQL                      Writes SQL to update database to current");
        stream.println("                                version to STDOUT");
        stream.println(" updateCount <num>              Applies next NUM changes to the database");
        stream.println(" updateSQL <num>                Writes SQL to apply next NUM changes");
        stream.println("                                to the database");
        stream.println(" rollback <tag>                 Rolls back the database to the the state is was");
        stream.println("                                when the tag was applied");
        stream.println(" rollbackSQL <tag>              Writes SQL to roll back the database to that");
        stream.println("                                state it was in when the tag was applied");
        stream.println("                                to STDOUT");
        stream.println(" rollbackToDate <date/time>     Rolls back the database to the the state is was");
        stream.println("                                at the given date/time.");
        stream.println("                                Date Format: yyyy-MM-dd HH:mm:ss");
        stream.println(" rollbackToDateSQL <date/time>  Writes SQL to roll back the database to that");
        stream.println("                                state it was in at the given date/time version");
        stream.println("                                to STDOUT");
        stream.println(" rollbackCount <value>          Rolls back the last <value> change sets");
        stream.println("                                applied to the database");
        stream.println(" rollbackCountSQL <value>       Writes SQL to roll back the last");
        stream.println("                                <value> change sets to STDOUT");
        stream.println("                                applied to the database");
        stream.println(" futureRollbackSQL              Writes SQL to roll back the database to the ");
        stream.println("                                current state after the changes in the ");
        stream.println("                                changeslog have been applied");
        stream.println(" updateTestingRollback          Updates database, then rolls back changes before");
        stream.println("                                updating again. Useful for testing");
        stream.println("                                rollback support");
        stream.println(" generateChangeLog              Writes Change Log XML to copy the current state");
        stream.println("                                of the database to standard out");
        stream.println("");
        stream.println("Diff Commands");
        stream.println(" diff [diff parameters]          Writes description of differences");
        stream.println("                                 to standard out");
        stream.println(" diffChangeLog [diff parameters] Writes Change Log XML to update");
        stream.println("                                 the database");
        stream.println("                                 to the reference database to standard out");
        stream.println("");
        stream.println("Documentation Commands");
        stream.println(" dbDoc <outputDirectory>         Generates Javadoc-like documentation");
        stream.println("                                 based on current database and change log");
        stream.println("");
        stream.println("Maintenance Commands");
        stream.println(" tag <tag string>          'Tags' the current database state for future rollback");
        stream.println(" status [--verbose]        Outputs count (list if --verbose) of unrun changesets");
        stream.println(" validate                  Checks changelog for errors");
        stream.println(" clearCheckSums            Removes all saved checksums from database log.");
        stream.println("                           Useful for 'MD5Sum Check Failed' errors");
        stream.println(" changelogSync             Mark all changes as executed in the database");
        stream.println(" changelogSyncSQL          Writes SQL to mark all changes as executed ");
        stream.println("                           in the database to STDOUT");
        stream.println(" markNextChangeSetRan      Mark the next change changes as executed ");
        stream.println("                           in the database");
        stream.println(" markNextChangeSetRanSQL   Writes SQL to mark the next change ");
        stream.println("                           as executed in the database to STDOUT");
        stream.println(" listLocks                 Lists who currently has locks on the");
        stream.println("                           database changelog");
        stream.println(" releaseLocks              Releases all locks on the database changelog");
        stream.println(" dropAll                   Drop all database objects owned by user");
        stream.println("");
        stream.println("Required Parameters:");
        stream.println(" --changeLogFile=<path and filename>        Migration file");
        stream.println(" --username=<value>                         Database username");
        stream.println(" --password=<value>                         Database password");
        stream.println(" --url=<value>                              Database URL");
        stream.println("");
        stream.println("Optional Parameters:");
        stream.println(" --classpath=<value>                        Classpath containing");
        stream.println("                                            migration files and JDBC Driver");
        stream.println(" --driver=<jdbc.driver.ClassName>           Database driver class name");
        stream.println(" --databaseClass=<database.ClassName>       custom liquibase.database.Database");
        stream.println("                                            implementation to use");
        stream.println(" --defaultSchemaName=<name>                 Default database schema to use");
        stream.println(" --contexts=<value>                         ChangeSet contexts to execute");
        stream.println(" --defaultsFile=</path/to/file.properties>  File with default option values");
        stream.println("                                            (default: ./liquibase.properties)");
        stream.println(" --includeSystemClasspath=<true|false>      Include the system classpath");
        stream.println("                                            in the Liquibase classpath");
        stream.println("                                            (default: true)");
        stream.println(" --promptForNonLocalDatabase=<true|false>   Prompt if non-localhost");
        stream.println("                                            databases (default: false)");
        stream.println(" --logLevel=<level>                         Execution log level");
        stream.println("                                            (debug, info, warning, severe, off");
        stream.println(" --logFile=<file>                           Log file");
        stream.println(" --currentDateTimeFunction=<value>          Overrides current date time function");
        stream.println("                                            used in SQL.");
        stream.println("                                            Useful for unsupported databases");
        stream.println(" --help                                     Prints this message");
        stream.println(" --version                                  Prints this version information");
        stream.println("");
        stream.println("Required Diff Parameters:");
        stream.println(" --referenceUsername=<value>                Reference Database username");
        stream.println(" --referencePassword=<value>                Reference Database password");
        stream.println(" --referenceUrl=<value>                     Reference Database URL");
        stream.println("");
        stream.println("Optional Diff Parameters:");
        stream.println(" --referenceDriver=<jdbc.driver.ClassName>  Reference Database driver class name");
        stream.println(" --dataOutputDirectory=DIR                  Output data as CSV in the given ");
        stream.println("                                            directory");
        stream.println("");
        stream.println("Change Log Properties:");
        stream.println(" -D<property.name>=<property.value>         Pass a name/value pair for");
        stream.println("                                            substitution in the change log(s)");
        stream.println("");
        stream.println("Default value for parameters can be stored in a file called");
        stream.println("'liquibase.properties' that is read from the current working directory.");
        stream.println("");
        stream.println("Full documentation is available at");
        stream.println("http://www.liquibase.org/manual/command_line");
        stream.println("");
    }

    protected void parseOptions(String[] args) throws CommandLineParsingException {
        args = this.fixupArgs(args);
        boolean seenCommand = false;
        for (String arg : args) {
            String value;
            String attributeName;
            String[] splitArg;
            if (this.isCommand(arg)) {
                this.command = arg;
                if (this.command.equalsIgnoreCase("migrate")) {
                    this.command = "update";
                } else if (this.command.equalsIgnoreCase("migrateSQL")) {
                    this.command = "updateSQL";
                }
                seenCommand = true;
                continue;
            }
            if (seenCommand) {
                if (arg.startsWith("-D")) {
                    splitArg = this.splitArg(arg);
                    attributeName = splitArg[0].replaceFirst("^-D", "");
                    value = splitArg[1];
                    this.changeLogParameters.put(attributeName, value);
                    continue;
                }
                this.commandParams.add(arg);
                continue;
            }
            if (arg.startsWith("--")) {
                splitArg = this.splitArg(arg);
                attributeName = splitArg[0];
                value = splitArg[1];
                try {
                    Field field = this.getClass().getDeclaredField(attributeName);
                    if (field.getType().equals(Boolean.class)) {
                        field.set(this, Boolean.valueOf(value));
                        continue;
                    }
                    field.set(this, value);
                    continue;
                }
                catch (Exception e) {
                    throw new CommandLineParsingException("Unknown parameter: '" + attributeName + "'");
                }
            }
            throw new CommandLineParsingException("Unexpected value " + arg + ": parameters must start with a '--'");
        }
    }

    private String[] splitArg(String arg) throws CommandLineParsingException {
        String[] splitArg = arg.split("=");
        if (splitArg.length < 2) {
            throw new CommandLineParsingException("Could not parse '" + arg + "'");
        }
        if (splitArg.length > 2) {
            StringBuffer secondHalf = new StringBuffer();
            for (int j = 1; j < splitArg.length; ++j) {
                secondHalf.append(splitArg[j]).append("=");
            }
            splitArg = new String[]{splitArg[0], secondHalf.toString().replaceFirst("=$", "")};
        }
        splitArg[0] = splitArg[0].replaceFirst("--", "");
        return splitArg;
    }

    protected void applyDefaults() {
        if (this.promptForNonLocalDatabase == null) {
            this.promptForNonLocalDatabase = Boolean.FALSE;
        }
        if (this.logLevel == null) {
            this.logLevel = "info";
        }
        if (this.includeSystemClasspath == null) {
            this.includeSystemClasspath = Boolean.TRUE;
        }
    }

    protected void configureClassLoader() throws CommandLineParsingException {
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (this.classpath != null) {
            String[] classpath = this.isWindows() ? this.classpath.split(";") : this.classpath.split(":");
            for (String classpathEntry : classpath) {
                File classPathFile = new File(classpathEntry);
                if (!classPathFile.exists()) {
                    throw new CommandLineParsingException(classPathFile.getAbsolutePath() + " does not exist");
                }
                try {
                    if (classpathEntry.endsWith(".war")) {
                        this.addWarFileClasspathEntries(classPathFile, urls);
                        continue;
                    }
                    if (classpathEntry.endsWith(".ear")) {
                        JarFile earZip = new JarFile(classPathFile);
                        Enumeration<JarEntry> entries = earZip.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.getName().toLowerCase().endsWith(".jar")) {
                                File jar = this.extract(earZip, entry);
                                urls.add(new URL("jar:" + jar.toURL() + "!/"));
                                jar.deleteOnExit();
                                continue;
                            }
                            if (!entry.getName().toLowerCase().endsWith("war")) continue;
                            File warFile = this.extract(earZip, entry);
                            this.addWarFileClasspathEntries(warFile, urls);
                        }
                        continue;
                    }
                    urls.add(new File(classpathEntry).toURL());
                }
                catch (Exception e) {
                    throw new CommandLineParsingException(e);
                }
            }
        }
        this.classLoader = this.includeSystemClasspath != false ? (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            }
        }) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]));
            }
        });
        ServiceLocator.getInstance().setResourceAccessor(new ClassLoaderResourceAccessor(this.classLoader));
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    private void addWarFileClasspathEntries(File classPathFile, List<URL> urls) throws IOException {
        URL url = new URL("jar:" + classPathFile.toURL() + "!/WEB-INF/classes/");
        urls.add(url);
        JarFile warZip = new JarFile(classPathFile);
        Enumeration<JarEntry> entries = warZip.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith("WEB-INF/lib") || !entry.getName().toLowerCase().endsWith(".jar")) continue;
            File jar = this.extract(warZip, entry);
            urls.add(new URL("jar:" + jar.toURL() + "!/"));
            jar.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extract(JarFile jar, JarEntry entry) throws IOException {
        File tempFile = File.createTempFile("liquibase.tmp", null);
        BufferedInputStream inStream = null;
        FilterOutputStream outStream = null;
        try {
            int status;
            inStream = new BufferedInputStream(jar.getInputStream(entry));
            outStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            while ((status = inStream.read()) != -1) {
                ((BufferedOutputStream)outStream).write(status);
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException ioe) {}
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMigration() throws Exception {
        block88: {
            if ("help".equalsIgnoreCase(this.command)) {
                this.printHelp(System.out);
                return;
            }
            try {
                if (null != this.logFile) {
                    LogFactory.getLogger().setLogLevel(this.logLevel, this.logFile);
                } else {
                    LogFactory.getLogger().setLogLevel(this.logLevel);
                }
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineParsingException(e.getMessage(), e);
            }
            FileSystemResourceAccessor fsOpener = new FileSystemResourceAccessor();
            CommandLineResourceAccessor clOpener = new CommandLineResourceAccessor(this.classLoader);
            Database database = CommandLineUtils.createDatabaseObject(this.classLoader, this.url, this.username, this.password, this.driver, this.defaultSchemaName, this.databaseClass);
            try {
                CompositeResourceAccessor fileOpener = new CompositeResourceAccessor(fsOpener, clOpener);
                if ("diff".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doDiff(this.createReferenceDatabaseFromCommandParams(this.commandParams), database);
                    return;
                }
                if ("diffChangeLog".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doDiffToChangeLog(this.changeLogFile, this.createReferenceDatabaseFromCommandParams(this.commandParams), database);
                    return;
                }
                if ("generateChangeLog".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doGenerateChangeLog(this.changeLogFile, database, this.defaultSchemaName, StringUtils.trimToNull(this.diffTypes), StringUtils.trimToNull(this.changeSetAuthor), StringUtils.trimToNull(this.changeSetContext), StringUtils.trimToNull(this.dataDir));
                    return;
                }
                Liquibase liquibase = new Liquibase(this.changeLogFile, (ResourceAccessor)fileOpener, database);
                liquibase.setCurrentDateTimeFunction(this.currentDateTimeFunction);
                for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                    liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
                }
                if ("listLocks".equalsIgnoreCase(this.command)) {
                    liquibase.reportLocks(System.out);
                    return;
                }
                if ("releaseLocks".equalsIgnoreCase(this.command)) {
                    LockService.getInstance(database).forceReleaseLock();
                    System.out.println("Successfully released all database change log locks for " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                    return;
                }
                if ("tag".equalsIgnoreCase(this.command)) {
                    liquibase.tag(this.commandParams.iterator().next());
                    System.out.println("Successfully tagged " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                    return;
                }
                if ("dropAll".equals(this.command)) {
                    liquibase.dropAll();
                    System.out.println("All objects dropped from " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                    return;
                }
                if ("status".equalsIgnoreCase(this.command)) {
                    boolean runVerbose = false;
                    if (this.commandParams.contains("--verbose")) {
                        runVerbose = true;
                    }
                    liquibase.reportStatus(runVerbose, this.contexts, this.getOutputWriter());
                    return;
                }
                if ("validate".equalsIgnoreCase(this.command)) {
                    try {
                        liquibase.validate();
                    }
                    catch (ValidationFailedException e) {
                        e.printDescriptiveError(System.out);
                        try {
                            database.rollback();
                            database.close();
                        }
                        catch (DatabaseException e2) {
                            LogFactory.getLogger().warning("problem closing connection", e2);
                        }
                        return;
                    }
                    System.out.println("No validation errors found");
                    return;
                }
                if ("clearCheckSums".equalsIgnoreCase(this.command)) {
                    liquibase.clearCheckSums();
                    return;
                }
                if ("dbdoc".equalsIgnoreCase(this.command)) {
                    if (this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("dbdoc requires an output directory");
                    }
                    if (this.changeLogFile == null) {
                        throw new CommandLineParsingException("dbdoc requires a changeLog parameter");
                    }
                    liquibase.generateDocumentation(this.commandParams.iterator().next());
                    return;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                try {
                    if ("update".equalsIgnoreCase(this.command)) {
                        liquibase.update(this.contexts);
                        break block88;
                    }
                    if ("changelogSync".equalsIgnoreCase(this.command)) {
                        liquibase.changeLogSync(this.contexts);
                        break block88;
                    }
                    if ("changelogSyncSQL".equalsIgnoreCase(this.command)) {
                        liquibase.changeLogSync(this.contexts, this.getOutputWriter());
                        break block88;
                    }
                    if ("markNextChangeSetRan".equalsIgnoreCase(this.command)) {
                        liquibase.markNextChangeSetRan(this.contexts);
                        break block88;
                    }
                    if ("markNextChangeSetRanSQL".equalsIgnoreCase(this.command)) {
                        liquibase.markNextChangeSetRan(this.contexts, this.getOutputWriter());
                        break block88;
                    }
                    if ("updateCount".equalsIgnoreCase(this.command)) {
                        liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), this.contexts);
                        break block88;
                    }
                    if ("updateCountSQL".equalsIgnoreCase(this.command)) {
                        liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                        break block88;
                    }
                    if ("updateSQL".equalsIgnoreCase(this.command)) {
                        liquibase.update(this.contexts, this.getOutputWriter());
                        break block88;
                    }
                    if ("rollback".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null || this.commandParams.size() == 0) {
                            throw new CommandLineParsingException("rollback requires a rollback tag");
                        }
                        liquibase.rollback(this.commandParams.iterator().next(), this.contexts);
                        break block88;
                    }
                    if ("rollbackToDate".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null || this.commandParams.size() == 0) {
                            throw new CommandLineParsingException("rollback requires a rollback date");
                        }
                        liquibase.rollback(dateFormat.parse(this.commandParams.iterator().next()), this.contexts);
                        break block88;
                    }
                    if ("rollbackCount".equalsIgnoreCase(this.command)) {
                        liquibase.rollback(Integer.parseInt(this.commandParams.iterator().next()), this.contexts);
                        break block88;
                    }
                    if ("rollbackSQL".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null || this.commandParams.size() == 0) {
                            throw new CommandLineParsingException("rollbackSQL requires a rollback tag");
                        }
                        liquibase.rollback(this.commandParams.iterator().next(), this.contexts, this.getOutputWriter());
                        break block88;
                    }
                    if ("rollbackToDateSQL".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null || this.commandParams.size() == 0) {
                            throw new CommandLineParsingException("rollbackToDateSQL requires a rollback date");
                        }
                        liquibase.rollback(dateFormat.parse(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                        break block88;
                    }
                    if ("rollbackCountSQL".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null || this.commandParams.size() == 0) {
                            throw new CommandLineParsingException("rollbackCountSQL requires a rollback tag");
                        }
                        liquibase.rollback(Integer.parseInt(this.commandParams.iterator().next()), this.contexts, this.getOutputWriter());
                        break block88;
                    }
                    if ("futureRollbackSQL".equalsIgnoreCase(this.command)) {
                        liquibase.futureRollbackSQL(this.contexts, this.getOutputWriter());
                        break block88;
                    }
                    if ("updateTestingRollback".equalsIgnoreCase(this.command)) {
                        liquibase.updateTestingRollback(this.contexts);
                        break block88;
                    }
                    throw new CommandLineParsingException("Unknown command: " + this.command);
                }
                catch (ParseException e) {
                    throw new CommandLineParsingException("Unexpected date/time format.  Use 'yyyy-MM-dd'T'HH:mm:ss'");
                }
            }
            finally {
                try {
                    database.rollback();
                    database.close();
                }
                catch (DatabaseException e) {
                    LogFactory.getLogger().warning("problem closing connection", e);
                }
            }
        }
    }

    private String getCommandParam(String paramName) throws CommandLineParsingException {
        for (String param : this.commandParams) {
            String[] splitArg = this.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if (!attributeName.equalsIgnoreCase(paramName)) continue;
            return value;
        }
        return null;
    }

    private Database createReferenceDatabaseFromCommandParams(Set<String> commandParams) throws CommandLineParsingException, DatabaseException {
        String driver = this.referenceDriver;
        String url = this.referenceUrl;
        String username = this.referenceUsername;
        String password = this.referencePassword;
        String defaultSchemaName = this.defaultSchemaName;
        for (String param : commandParams) {
            String[] splitArg = this.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if ("referenceDriver".equalsIgnoreCase(attributeName)) {
                driver = value;
                continue;
            }
            if ("referenceUrl".equalsIgnoreCase(attributeName)) {
                url = value;
                continue;
            }
            if ("referenceUsername".equalsIgnoreCase(attributeName)) {
                username = value;
                continue;
            }
            if ("referencePassword".equalsIgnoreCase(attributeName)) {
                password = value;
                continue;
            }
            if ("referenceDefaultSchemaName".equalsIgnoreCase(attributeName)) {
                defaultSchemaName = value;
                continue;
            }
            if (!"dataOutputDirectory".equalsIgnoreCase(attributeName)) continue;
            this.dataDir = value;
        }
        if (url == null) {
            throw new CommandLineParsingException("referenceUrl parameter missing");
        }
        return CommandLineUtils.createDatabaseObject(this.classLoader, url, username, password, driver, defaultSchemaName, null);
    }

    private Writer getOutputWriter() {
        return new OutputStreamWriter(System.out);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows ");
    }
}

