/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure.type;

import liquibase.database.Database;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.UnexpectedLiquibaseException;

public abstract class DataType {
    private String dataTypeName;
    private int minParameters;
    private int maxParameters;
    private String unit;
    private String firstParameter;
    private String secondParameter;

    protected DataType(String dataTypeName, int minParameters, int maxParameters) {
        this.dataTypeName = dataTypeName;
        this.minParameters = minParameters;
        this.maxParameters = maxParameters;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public void setDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
    }

    public int getMinParameters() {
        return this.minParameters;
    }

    public int getMaxParameters() {
        return this.maxParameters;
    }

    public String getFirstParameter() {
        return this.firstParameter;
    }

    public void setFirstParameter(String firstParameter) {
        if (this.maxParameters < 1) {
            throw new UnexpectedLiquibaseException("Type " + this.getClass() + " doesn't support precision but precision was specified");
        }
        this.firstParameter = firstParameter;
    }

    public String getSecondParameter() {
        return this.secondParameter;
    }

    public void setSecondParameter(String secondParameter) {
        if (this.maxParameters < 2) {
            throw new UnexpectedLiquibaseException("Type " + this.getClass() + " doesn't support second parameters but one was specified");
        }
        this.secondParameter = secondParameter;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String convertObjectToString(Object value, Database database) {
        if (value == null) {
            return null;
        }
        if (value.toString().equals("CURRENT_TIMESTAMP()")) {
            return database.getCurrentDateTimeFunction();
        }
        if (value.equals(Boolean.TRUE)) {
            return TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getTrueBooleanValue();
        }
        if (value.equals(Boolean.FALSE)) {
            return TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getFalseBooleanValue();
        }
        return value.toString();
    }

    public String toString() {
        String returnString = this.getDataTypeName();
        if (this.getFirstParameter() != null) {
            returnString = returnString + "(" + this.getFirstParameter();
            if (this.getSecondParameter() != null) {
                returnString = returnString + "," + this.getSecondParameter();
            }
            if (this.getUnit() != null) {
                returnString = returnString + " " + this.getUnit();
            }
            returnString = returnString + ")";
        }
        return returnString;
    }

    public boolean equals(Object o) {
        return o instanceof DataType && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean getSupportsPrecision() {
        return false;
    }
}

