/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lockservice;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.logging.LogFactory;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;

public class LockService {
    private Database database;
    private boolean hasChangeLogLock = false;
    private long changeLogLockWaitTime = 300000L;
    private long changeLogLocRecheckTime = 10000L;
    private static Map<Database, LockService> instances = new ConcurrentHashMap<Database, LockService>();

    private LockService(Database database) {
        this.database = database;
    }

    public static LockService getInstance(Database database) {
        if (!instances.containsKey(database)) {
            instances.put(database, new LockService(database));
        }
        return instances.get(database);
    }

    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockWaitTime = changeLogLockWaitTime;
    }

    public void setChangeLogLockRecheckTime(long changeLogLocRecheckTime) {
        this.changeLogLocRecheckTime = changeLogLocRecheckTime;
    }

    public boolean hasChangeLogLock() {
        return this.hasChangeLogLock;
    }

    public void waitForLock() throws LockException {
        boolean locked = false;
        long timeToGiveUp = new Date().getTime() + this.changeLogLockWaitTime;
        while (!locked && new Date().getTime() < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            System.out.println("Waiting for changelog lock....");
            try {
                Thread.sleep(this.changeLogLocRecheckTime);
            }
            catch (InterruptedException e) {}
        }
        if (!locked) {
            String lockedBy;
            DatabaseChangeLogLock[] locks = this.listLocks();
            if (locks.length > 0) {
                DatabaseChangeLogLock lock = locks[0];
                lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }

    public boolean acquireLock() throws LockException {
        boolean bl;
        if (this.hasChangeLogLock) {
            return true;
        }
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        try {
            this.database.rollback();
            this.database.checkDatabaseChangeLogLockTable();
            Boolean locked = (Boolean)ExecutorService.getInstance().getExecutor(this.database).queryForObject(new SelectFromDatabaseChangeLogLockStatement("LOCKED"), Boolean.class);
            if (locked.booleanValue()) {
                boolean bl2 = false;
                return bl2;
            }
            executor.comment("Lock Database");
            int rowsUpdated = executor.update(new LockDatabaseChangeLogStatement());
            if (rowsUpdated != 1) {
                throw new LockException("Did not update change log lock correctly");
            }
            this.database.commit();
            LogFactory.getLogger().info("Successfully acquired change log lock");
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            bl = true;
        }
        catch (Exception e) {
            throw new LockException(e);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException e) {}
        }
        return bl;
    }

    public void releaseLock() throws LockException {
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        try {
            if (this.database.hasDatabaseChangeLogLockTable()) {
                executor.comment("Release Database Lock");
                this.database.rollback();
                int updatedRows = executor.update(new UnlockDatabaseChangeLogStatement());
                if (updatedRows != 1) {
                    throw new LockException("Did not update change log lock correctly.\n\n" + updatedRows + " rows were updated instead of the expected 1 row using executor " + executor.getClass().getName() + " there are " + executor.queryForInt(new RawSqlStatement("select count(*) from " + this.database.getDatabaseChangeLogLockTableName())) + " rows in the table");
                }
                this.database.commit();
                this.hasChangeLogLock = false;
                instances.remove(this.database);
                this.database.setCanCacheLiquibaseTableInfo(false);
                LogFactory.getLogger().info("Successfully released change log lock");
            }
        }
        catch (Exception e) {
            throw new LockException(e);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException e) {}
        }
    }

    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            if (!this.database.hasDatabaseChangeLogLockTable()) {
                return new DatabaseChangeLogLock[0];
            }
            ArrayList<DatabaseChangeLogLock> allLocks = new ArrayList<DatabaseChangeLogLock>();
            SelectFromDatabaseChangeLogLockStatement sqlStatement = new SelectFromDatabaseChangeLogLockStatement("ID", "LOCKED", "LOCKGRANTED", "LOCKEDBY");
            List<Map> rows = ExecutorService.getInstance().getExecutor(this.database).queryForList(sqlStatement);
            for (Map columnMap : rows) {
                Object lockedValue = columnMap.get("LOCKED");
                Boolean locked = lockedValue instanceof Number ? Boolean.valueOf(((Number)lockedValue).intValue() == 1) : (Boolean)lockedValue;
                if (locked == null || !locked.booleanValue()) continue;
                allLocks.add(new DatabaseChangeLogLock(((Number)columnMap.get("ID")).intValue(), (Date)columnMap.get("LOCKGRANTED"), (String)columnMap.get("LOCKEDBY")));
            }
            return allLocks.toArray(new DatabaseChangeLogLock[allLocks.size()]);
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    public void forceReleaseLock() throws LockException, DatabaseException {
        this.database.checkDatabaseChangeLogLockTable();
        this.releaseLock();
    }

    public void reset() {
        this.hasChangeLogLock = false;
    }

    public static void resetAll() {
        for (Map.Entry<Database, LockService> entity : instances.entrySet()) {
            entity.getValue().reset();
        }
    }
}

