/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.database.structure.Column;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.ForeignKeyConstraintType;
import liquibase.database.structure.ForeignKeyInfo;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.statement.core.SelectSequencesStatement;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JdbcDatabaseSnapshotGenerator
implements DatabaseSnapshotGenerator {
    private Set<DiffStatusListener> statusListeners;

    protected String convertTableNameToDatabaseTableName(String tableName) {
        return tableName;
    }

    protected String convertColumnNameToDatabaseTableName(String columnName) {
        return columnName;
    }

    @Override
    public Table getDatabaseChangeLogTable(Database database) throws DatabaseException {
        return this.getTable(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName(), database);
    }

    @Override
    public Table getDatabaseChangeLogLockTable(Database database) throws DatabaseException {
        return this.getTable(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogLockTableName(), database);
    }

    @Override
    public boolean hasDatabaseChangeLogTable(Database database) {
        return this.hasTable(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName(), database);
    }

    @Override
    public boolean hasDatabaseChangeLogLockTable(Database database) {
        return this.hasTable(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogLockTableName(), database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTable(String schemaName, String tableName, Database database) {
        boolean bl;
        ResultSet rs = this.getMetaData(database).getTables(database.convertRequestedSchemaToCatalog(schemaName), database.convertRequestedSchemaToSchema(schemaName), this.convertTableNameToDatabaseTableName(tableName), new String[]{"TABLE"});
        try {
            bl = rs.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
        try {
            rs.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table getTable(String schemaName, String tableName, Database database) throws DatabaseException {
        Table table;
        ResultSet rs = null;
        try {
            Table table2;
            DatabaseMetaData metaData = this.getMetaData(database);
            rs = metaData.getTables(database.convertRequestedSchemaToCatalog(schemaName), database.convertRequestedSchemaToSchema(schemaName), this.convertTableNameToDatabaseTableName(tableName), new String[]{"TABLE"});
            try {
                if (!rs.next()) {
                    Table table3 = null;
                    return table3;
                }
                table2 = this.readTable(rs, database);
            }
            finally {
                rs.close();
            }
            rs = metaData.getColumns(database.convertRequestedSchemaToCatalog(schemaName), database.convertRequestedSchemaToSchema(schemaName), this.convertTableNameToDatabaseTableName(tableName), null);
            try {
                while (rs.next()) {
                    table2.getColumns().add(this.readColumn(rs, database));
                }
            }
            finally {
                rs.close();
            }
            table = table2;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
        }
        return table;
    }

    @Override
    public Column getColumn(String schemaName, String tableName, String columnName, Database database) throws DatabaseException {
        Column column;
        ResultSet rs = null;
        try {
            rs = this.getMetaData(database).getColumns(database.convertRequestedSchemaToCatalog(schemaName), database.convertRequestedSchemaToSchema(schemaName), this.convertTableNameToDatabaseTableName(tableName), this.convertColumnNameToDatabaseTableName(columnName));
            if (!rs.next()) {
                Column column2 = null;
                return column2;
            }
            column = this.readColumn(rs, database);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
        }
        return column;
    }

    private Table readTable(ResultSet rs, Database database) throws SQLException {
        String name = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
        String schemaName = this.convertFromDatabaseName(rs.getString("TABLE_SCHEM"));
        String remarks = rs.getString("REMARKS");
        Table table = new Table(name);
        table.setRemarks(StringUtils.trimToNull(remarks));
        table.setDatabase(database);
        table.setSchema(schemaName);
        table.setRawSchemaName(rs.getString("TABLE_SCHEM"));
        table.setRawCatalogName(rs.getString("TABLE_CAT"));
        return table;
    }

    private View readView(ResultSet rs, Database database) throws SQLException, DatabaseException {
        String name = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
        String schemaName = this.convertFromDatabaseName(rs.getString("TABLE_SCHEM"));
        View view = new View();
        view.setName(name);
        view.setSchema(schemaName);
        view.setRawSchemaName(rs.getString("TABLE_SCHEM"));
        view.setRawCatalogName(rs.getString("TABLE_CAT"));
        try {
            view.setDefinition(database.getViewDefinition(rs.getString("TABLE_SCHEM"), name));
        }
        catch (DatabaseException e) {
            throw new DatabaseException("Error getting " + database.getConnection().getURL() + " view with " + new GetViewDefinitionStatement(view.getSchema(), name), e);
        }
        return view;
    }

    private Column readColumn(ResultSet rs, Database database) throws SQLException, DatabaseException {
        Column column = new Column();
        String tableName = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
        String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
        String schemaName = this.convertFromDatabaseName(rs.getString("TABLE_SCHEM"));
        String catalogName = this.convertFromDatabaseName(rs.getString("TABLE_CAT"));
        String remarks = rs.getString("REMARKS");
        if (database.isSystemTable(catalogName, schemaName, tableName) || database.isSystemView(catalogName, schemaName, tableName)) {
            return null;
        }
        column.setName(columnName);
        Table table = new Table(tableName);
        table.setSchema(schemaName);
        column.setTable(table);
        this.configureColumnType(column, rs);
        int nullable = rs.getInt("NULLABLE");
        if (nullable == 0) {
            column.setNullable(false);
        } else if (nullable == 1) {
            column.setNullable(true);
        }
        this.getColumnTypeAndDefValue(column, rs, database);
        column.setRemarks(remarks);
        return column;
    }

    protected void configureColumnType(Column column, ResultSet rs) throws SQLException {
        column.setDataType(rs.getInt("DATA_TYPE"));
        column.setColumnSize(rs.getInt("COLUMN_SIZE"));
        column.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
        column.setInitPrecision(column.getDataType() != 3 && column.getDataType() != 2 && column.getDataType() != 7 || rs.getString("DECIMAL_DIGITS") != null);
    }

    @Override
    public DatabaseSnapshot createSnapshot(Database database, String requestedSchema, Set<DiffStatusListener> listeners) throws DatabaseException {
        if (requestedSchema == null) {
            requestedSchema = database.getDefaultSchemaName();
        }
        try {
            DatabaseMetaData databaseMetaData = this.getMetaData(database);
            this.statusListeners = listeners;
            DatabaseSnapshot snapshot = new DatabaseSnapshot(database, requestedSchema);
            this.readTables(snapshot, requestedSchema, databaseMetaData);
            this.readViews(snapshot, requestedSchema, databaseMetaData);
            this.readForeignKeyInformation(snapshot, requestedSchema, databaseMetaData);
            this.readPrimaryKeys(snapshot, requestedSchema, databaseMetaData);
            this.readColumns(snapshot, requestedSchema, databaseMetaData);
            this.readUniqueConstraints(snapshot, requestedSchema, databaseMetaData);
            this.readIndexes(snapshot, requestedSchema, databaseMetaData);
            this.readSequences(snapshot, requestedSchema, databaseMetaData);
            return snapshot;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    protected DatabaseMetaData getMetaData(Database database) throws SQLException {
        DatabaseMetaData databaseMetaData = null;
        if (database.getConnection() != null) {
            databaseMetaData = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().getMetaData();
        }
        return databaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTables(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws SQLException, DatabaseException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading tables for " + database.toString() + " ...");
        ResultSet rs = databaseMetaData.getTables(database.convertRequestedSchemaToCatalog(schema), database.convertRequestedSchemaToSchema(schema), null, new String[]{"TABLE", "ALIAS"});
        try {
            while (rs.next()) {
                Table table = this.readTable(rs, database);
                table.setSchema(schema);
                if (database.isLiquibaseTable(table.getName())) {
                    if (table.getName().equalsIgnoreCase(database.getDatabaseChangeLogTableName())) {
                        snapshot.setDatabaseChangeLogTable(table);
                        continue;
                    }
                    if (table.getName().equalsIgnoreCase(database.getDatabaseChangeLogLockTableName())) {
                        snapshot.setDatabaseChangeLogLockTable(table);
                        continue;
                    }
                }
                if (database.isSystemTable(table.getRawCatalogName(), table.getRawSchemaName(), table.getName()) || database.isSystemView(table.getRawCatalogName(), table.getRawSchemaName(), table.getName())) continue;
                snapshot.getTables().add(table);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readViews(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws SQLException, DatabaseException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading views for " + database.toString() + " ...");
        ResultSet rs = databaseMetaData.getTables(database.convertRequestedSchemaToCatalog(schema), database.convertRequestedSchemaToSchema(schema), null, new String[]{"VIEW"});
        try {
            while (rs.next()) {
                View view = this.readView(rs, database);
                if (database.isSystemView(view.getRawCatalogName(), view.getRawSchemaName(), view.getName())) continue;
                snapshot.getViews().add(view);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ignore) {}
        }
    }

    protected String convertFromDatabaseName(String objectName) {
        if (objectName == null) {
            return null;
        }
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readColumns(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws SQLException, DatabaseException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading columns for " + database.toString() + " ...");
        Statement selectStatement = null;
        ResultSet rs = null;
        try {
            selectStatement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
            rs = databaseMetaData.getColumns(database.convertRequestedSchemaToCatalog(schema), database.convertRequestedSchemaToSchema(schema), null, null);
            while (rs.next()) {
                Table table;
                Column column = this.readColumn(rs, database);
                if (column == null) continue;
                Table tempTable = column.getTable();
                column.setTable(null);
                if (database.isLiquibaseTable(tempTable.getName())) {
                    if (tempTable.getName().equalsIgnoreCase(database.getDatabaseChangeLogTableName())) {
                        table = snapshot.getDatabaseChangeLogTable();
                    } else {
                        if (!tempTable.getName().equalsIgnoreCase(database.getDatabaseChangeLogLockTableName())) throw new UnexpectedLiquibaseException("Unknown liquibase table: " + tempTable.getName());
                        table = snapshot.getDatabaseChangeLogLockTable();
                    }
                } else {
                    table = snapshot.getTable(tempTable.getName());
                }
                if (table == null) {
                    View view = snapshot.getView(tempTable.getName());
                    if (view == null) {
                        LogFactory.getLogger().debug("Could not find table or view " + tempTable.getName() + " for column " + column.getName());
                        continue;
                    }
                    column.setView(view);
                    column.setAutoIncrement(false);
                    view.getColumns().add(column);
                } else {
                    column.setTable(table);
                    column.setAutoIncrement(this.isColumnAutoIncrement(database, table.getSchema(), table.getName(), column.getName()));
                    table.getColumns().add(column);
                }
                column.setPrimaryKey(snapshot.isPrimaryKey(column));
            }
            return;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignored) {}
            }
            if (selectStatement != null) {
                try {
                    selectStatement.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    protected void getColumnTypeAndDefValue(Column columnInfo, ResultSet rs, Database database) throws SQLException, DatabaseException {
        Object defaultValue = rs.getObject("COLUMN_DEF");
        try {
            columnInfo.setDefaultValue(TypeConverterFactory.getInstance().findTypeConverter(database).convertDatabaseValueToObject(defaultValue, columnInfo.getDataType(), columnInfo.getColumnSize(), columnInfo.getDecimalDigits(), database));
        }
        catch (ParseException e) {
            throw new DatabaseException(e);
        }
        columnInfo.setTypeName(TypeConverterFactory.getInstance().findTypeConverter(database).getDataType(rs.getString("TYPE_NAME"), columnInfo.isAutoIncrement()).toString());
    }

    protected void readForeignKeyInformation(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws DatabaseException, SQLException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading foreign keys for " + database.toString() + " ...");
        String dbSchema = database.convertRequestedSchemaToSchema(schema);
        snapshot.getForeignKeys().addAll(this.getAdditionalForeignKeys(dbSchema, database));
        for (Table table : snapshot.getTables()) {
            for (ForeignKey fk : this.getForeignKeys(schema, table.getName(), snapshot.getDatabase())) {
                Table tempFkTable;
                Table fkTable;
                Table tempPKTable = fk.getPrimaryKeyTable();
                Table pkTable = snapshot.getTable(tempPKTable.getName());
                if (pkTable == null) {
                    LogFactory.getLogger().warning("Foreign key " + fk.getName() + " references table " + tempPKTable + ", which is in a different schema. Retaining FK in diff, but table will not be diffed.");
                }
                if ((fkTable = snapshot.getTable((tempFkTable = fk.getForeignKeyTable()).getName())) == null) {
                    LogFactory.getLogger().warning("Foreign key " + fk.getName() + " is in table " + tempFkTable + ", which we cannot find. Ignoring.");
                    continue;
                }
                snapshot.getForeignKeys().add(fk);
            }
        }
    }

    @Override
    public boolean hasIndex(String schemaName, String tableName, String indexName, Database database, String columnNames) throws DatabaseException {
        DatabaseSnapshot databaseSnapshot = this.createSnapshot(database, schemaName, null);
        if (databaseSnapshot.getIndex(indexName) != null) {
            return true;
        }
        if (tableName != null && columnNames != null) {
            for (Index index : databaseSnapshot.getIndexes()) {
                if (!index.getColumnNames().replaceAll("\\s+", "").equalsIgnoreCase(columnNames.replaceAll("\\s+", ""))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ForeignKey getForeignKeyByForeignKeyTable(String schemaName, String foreignKeyTableName, String fkName, Database database) throws DatabaseException {
        for (ForeignKey fk : this.getForeignKeys(schemaName, foreignKeyTableName, database)) {
            if (!fk.getName().equalsIgnoreCase(fkName)) continue;
            return fk;
        }
        return null;
    }

    public ForeignKey generateForeignKey(ForeignKeyInfo fkInfo, Database database, List<ForeignKey> fkList) throws DatabaseException {
        ForeignKey foreignKey = null;
        if (fkInfo.getKeySeq() == 1 || fkInfo.getReferencesUniqueColumn() && fkInfo.getKeySeq() == 0) {
            foreignKey = new ForeignKey();
        } else {
            for (ForeignKey foundFK : fkList) {
                if (!foundFK.getName().equalsIgnoreCase(fkInfo.getFkName())) continue;
                foreignKey = foundFK;
            }
            if (foreignKey == null) {
                throw new DatabaseException("Database returned out of sequence foreign key column for " + fkInfo.getFkName());
            }
        }
        foreignKey.setName(fkInfo.getFkName());
        Table pkTable = new Table(fkInfo.getPkTableName());
        pkTable.setSchema(fkInfo.getPkTableSchema());
        foreignKey.setPrimaryKeyTable(pkTable);
        foreignKey.addPrimaryKeyColumn(fkInfo.getPkColumn());
        String fkTableName = fkInfo.getFkTableName();
        Table fkTable = new Table(fkTableName);
        fkTable.setSchema(fkInfo.getFkSchema());
        foreignKey.setForeignKeyTable(fkTable);
        foreignKey.addForeignKeyColumn(fkInfo.getFkColumn());
        foreignKey.setUpdateRule(fkInfo.getUpdateRule());
        foreignKey.setDeleteRule(fkInfo.getDeleteRule());
        foreignKey.setReferencesUniqueColumn(fkInfo.getReferencesUniqueColumn());
        if (database.supportsInitiallyDeferrableColumns()) {
            if (fkInfo.getDeferrablility() == 5) {
                foreignKey.setDeferrable(Boolean.TRUE);
                foreignKey.setInitiallyDeferred(Boolean.TRUE);
            } else if (fkInfo.getDeferrablility() == 6) {
                foreignKey.setDeferrable(Boolean.TRUE);
                foreignKey.setInitiallyDeferred(Boolean.FALSE);
            } else if (fkInfo.getDeferrablility() == 7) {
                foreignKey.setDeferrable(Boolean.FALSE);
                foreignKey.setInitiallyDeferred(Boolean.FALSE);
            }
        }
        return foreignKey;
    }

    public List<ForeignKey> getAdditionalForeignKeys(String schemaName, Database database) throws DatabaseException {
        return new ArrayList<ForeignKey>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ForeignKey> getForeignKeys(String schemaName, String foreignKeyTableName, Database database) throws DatabaseException {
        ArrayList<ForeignKey> fkList = new ArrayList<ForeignKey>();
        try {
            String dbCatalog = database.convertRequestedSchemaToCatalog(schemaName);
            String dbSchema = database.convertRequestedSchemaToSchema(schemaName);
            ResultSet rs = this.getMetaData(database).getImportedKeys(dbCatalog, dbSchema, this.convertTableNameToDatabaseTableName(foreignKeyTableName));
            try {
                while (rs.next()) {
                    ForeignKeyInfo fkInfo = this.fillForeignKeyInfo(rs);
                    fkList.add(this.generateForeignKey(fkInfo, database, fkList));
                }
            }
            finally {
                rs.close();
            }
            return fkList;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    protected ForeignKeyInfo fillForeignKeyInfo(ResultSet rs) throws DatabaseException, SQLException {
        ForeignKeyInfo fkInfo = new ForeignKeyInfo();
        fkInfo.setFkName(this.convertFromDatabaseName(rs.getString("FK_NAME")));
        fkInfo.setFkSchema(this.convertFromDatabaseName(rs.getString("FKTABLE_SCHEM")));
        fkInfo.setFkTableName(this.convertFromDatabaseName(rs.getString("FKTABLE_NAME")));
        fkInfo.setFkColumn(this.convertFromDatabaseName(rs.getString("FKCOLUMN_NAME")));
        fkInfo.setPkTableSchema(rs.getString("PKTABLE_SCHEM"));
        fkInfo.setPkTableName(this.convertFromDatabaseName(rs.getString("PKTABLE_NAME")));
        fkInfo.setPkColumn(this.convertFromDatabaseName(rs.getString("PKCOLUMN_NAME")));
        fkInfo.setKeySeq(rs.getInt("KEY_SEQ"));
        ForeignKeyConstraintType updateRule = this.convertToForeignKeyConstraintType(rs.getInt("UPDATE_RULE"));
        if (rs.wasNull()) {
            updateRule = null;
        }
        fkInfo.setUpdateRule(updateRule);
        ForeignKeyConstraintType deleteRule = this.convertToForeignKeyConstraintType(rs.getInt("DELETE_RULE"));
        if (rs.wasNull()) {
            deleteRule = null;
        }
        fkInfo.setDeleteRule(deleteRule);
        fkInfo.setDeferrablility(rs.getShort("DEFERRABILITY"));
        return fkInfo;
    }

    protected ForeignKeyConstraintType convertToForeignKeyConstraintType(int jdbcType) throws DatabaseException {
        if (jdbcType == 0) {
            return ForeignKeyConstraintType.importedKeyCascade;
        }
        if (jdbcType == 3) {
            return ForeignKeyConstraintType.importedKeyNoAction;
        }
        if (jdbcType == 1) {
            return ForeignKeyConstraintType.importedKeyRestrict;
        }
        if (jdbcType == 4) {
            return ForeignKeyConstraintType.importedKeySetDefault;
        }
        if (jdbcType == 2) {
            return ForeignKeyConstraintType.importedKeySetNull;
        }
        throw new DatabaseException("Unknown constraint type: " + jdbcType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readIndexes(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws DatabaseException, SQLException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading indexes for " + database.toString() + " ...");
        for (Table table : snapshot.getTables()) {
            ResultSet rs = null;
            Statement statement = null;
            try {
                if (database instanceof OracleDatabase) {
                    statement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
                    String sql = "SELECT INDEX_NAME, 3 AS TYPE, TABLE_NAME, COLUMN_NAME, COLUMN_POSITION AS ORDINAL_POSITION, null AS FILTER_CONDITION FROM ALL_IND_COLUMNS WHERE TABLE_OWNER='" + database.convertRequestedSchemaToSchema(schema) + "' AND TABLE_NAME='" + table.getName() + "' ORDER BY INDEX_NAME, ORDINAL_POSITION";
                    rs = statement.executeQuery(sql);
                } else {
                    rs = databaseMetaData.getIndexInfo(database.convertRequestedSchemaToCatalog(schema), database.convertRequestedSchemaToSchema(schema), table.getName(), false, true);
                }
                HashMap<String, Index> indexMap = new HashMap<String, Index>();
                while (rs.next()) {
                    Index indexInformation;
                    String indexName = this.convertFromDatabaseName(rs.getString("INDEX_NAME"));
                    if (database instanceof InformixDatabase && indexName.startsWith(" ")) {
                        indexName = "_generated_index_" + indexName.substring(1);
                    }
                    short type = rs.getShort("TYPE");
                    boolean nonUnique = true;
                    try {
                        nonUnique = rs.getBoolean("NON_UNIQUE");
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
                    short position = rs.getShort("ORDINAL_POSITION");
                    if (database instanceof InformixDatabase && type != 0 && position == 0) {
                        position = (short)(position + 1);
                        System.out.println(this.getClass().getName() + ": corrected position to " + position);
                    }
                    String filterCondition = rs.getString("FILTER_CONDITION");
                    if (type == 0 || columnName == null) continue;
                    if (indexMap.containsKey(indexName)) {
                        indexInformation = (Index)indexMap.get(indexName);
                    } else {
                        indexInformation = new Index();
                        indexInformation.setTable(table);
                        indexInformation.setName(indexName);
                        indexInformation.setUnique(!nonUnique);
                        indexInformation.setFilterCondition(filterCondition);
                        indexMap.put(indexName, indexInformation);
                    }
                    for (int i = indexInformation.getColumns().size(); i < position; ++i) {
                        indexInformation.getColumns().add(null);
                    }
                    indexInformation.getColumns().set(position - 1, columnName);
                }
                for (Map.Entry entry : indexMap.entrySet()) {
                    snapshot.getIndexes().add((Index)entry.getValue());
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignored) {}
                }
                if (statement == null) continue;
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
        }
        HashSet indexesToRemove = new HashSet();
        for (Index index : snapshot.getIndexes()) {
            for (PrimaryKey pk : snapshot.getPrimaryKeys()) {
                if (!index.getTable().getName().equalsIgnoreCase(pk.getTable().getName()) || !index.getColumnNames().equals(pk.getColumnNames())) continue;
                index.addAssociatedWith("primaryKey");
            }
            for (ForeignKey fk : snapshot.getForeignKeys()) {
                if (!index.getTable().getName().equalsIgnoreCase(fk.getForeignKeyTable().getName()) || !index.getColumnNames().equals(fk.getForeignKeyColumns())) continue;
                index.addAssociatedWith("foreignKey");
            }
            for (UniqueConstraint uc : snapshot.getUniqueConstraints()) {
                if (!index.getTable().getName().equalsIgnoreCase(uc.getTable().getName()) || !index.getColumnNames().equals(uc.getColumnNames())) continue;
                index.addAssociatedWith("uniqueConstraint");
            }
        }
        snapshot.getIndexes().removeAll(indexesToRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPrimaryKeys(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws DatabaseException, SQLException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading primary keys for " + database.toString() + " ...");
        ArrayList<PrimaryKey> foundPKs = new ArrayList<PrimaryKey>();
        for (Table table : snapshot.getTables()) {
            ResultSet rs = databaseMetaData.getPrimaryKeys(database.convertRequestedSchemaToCatalog(schema), database.convertRequestedSchemaToSchema(schema), table.getName());
            try {
                while (rs.next()) {
                    String tableName = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
                    String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
                    short position = rs.getShort("KEY_SEQ");
                    boolean foundExistingPK = false;
                    for (PrimaryKey pk : foundPKs) {
                        if (!pk.getTable().getName().equals(tableName)) continue;
                        pk.addColumnName(position - 1, columnName);
                        foundExistingPK = true;
                    }
                    if (foundExistingPK) continue;
                    PrimaryKey primaryKey = new PrimaryKey();
                    primaryKey.setTable(table);
                    primaryKey.addColumnName(position - 1, columnName);
                    primaryKey.setName(this.convertPrimaryKeyName(rs.getString("PK_NAME")));
                    foundPKs.add(primaryKey);
                }
            }
            finally {
                rs.close();
            }
        }
        snapshot.getPrimaryKeys().addAll(foundPKs);
    }

    protected String convertPrimaryKeyName(String pkName) throws SQLException {
        return pkName;
    }

    protected void readUniqueConstraints(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws DatabaseException, SQLException {
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading unique constraints for " + database.toString() + " ...");
    }

    protected void readSequences(DatabaseSnapshot snapshot, String schema, DatabaseMetaData databaseMetaData) throws DatabaseException {
        List sequenceNames;
        Database database = snapshot.getDatabase();
        this.updateListeners("Reading sequences for " + database.toString() + " ...");
        String convertedSchemaName = database.convertRequestedSchemaToSchema(schema);
        if (database.supportsSequences() && (sequenceNames = ExecutorService.getInstance().getExecutor(database).queryForList((SqlStatement)new SelectSequencesStatement(schema), String.class)) != null) {
            for (String sequenceName : sequenceNames) {
                Sequence seq = new Sequence();
                seq.setName(sequenceName.trim());
                seq.setSchema(convertedSchemaName);
                snapshot.getSequences().add(seq);
            }
        }
    }

    protected void updateListeners(String message) {
        if (this.statusListeners == null) {
            return;
        }
        LogFactory.getLogger().debug(message);
        for (DiffStatusListener listener : this.statusListeners) {
            listener.statusUpdate(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColumnAutoIncrement(Database database, String schemaName, String tableName, String columnName) throws SQLException, DatabaseException {
        if (!database.supportsAutoIncrement()) {
            return false;
        }
        boolean autoIncrement = false;
        Statement statement = null;
        ResultSet selectRS = null;
        try {
            statement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
            selectRS = statement.executeQuery("SELECT " + database.escapeColumnName(schemaName, tableName, columnName) + " FROM " + database.escapeTableName(schemaName, tableName) + " WHERE 1 = 0");
            ResultSetMetaData meta = selectRS.getMetaData();
            autoIncrement = meta.isAutoIncrement(1);
        }
        finally {
            if (selectRS != null) {
                try {
                    selectRS.close();
                }
                catch (SQLException ignored) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {}
            }
        }
        return autoIncrement;
    }

    public int getDatabaseType(int type, Database database) {
        String booleanType;
        int returnType = type;
        if (returnType == 16 && !(booleanType = TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getDataTypeName()).equalsIgnoreCase("boolean")) {
            returnType = -6;
        }
        return returnType;
    }
}

