/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.AddForeignKeyConstraintStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddForeignKeyConstraintGenerator
extends AbstractSqlGenerator<AddForeignKeyConstraintStatement> {
    @Override
    public boolean supports(AddForeignKeyConstraintStatement statement, Database database) {
        if (statement.getReferencesUniqueColumn() && !(database instanceof OracleDatabase)) {
            return false;
        }
        return !(database instanceof SQLiteDatabase);
    }

    @Override
    public ValidationErrors validate(AddForeignKeyConstraintStatement addForeignKeyConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        if ((addForeignKeyConstraintStatement.isInitiallyDeferred() || addForeignKeyConstraintStatement.isDeferrable()) && !database.supportsInitiallyDeferrableColumns()) {
            validationErrors.checkDisallowedField("initiallyDeferred", addForeignKeyConstraintStatement.isInitiallyDeferred(), database, new Class[0]);
            validationErrors.checkDisallowedField("deferrable", addForeignKeyConstraintStatement.isDeferrable(), database, new Class[0]);
        }
        validationErrors.checkRequiredField("baseColumnNames", addForeignKeyConstraintStatement.getBaseColumnNames());
        validationErrors.checkRequiredField("baseTableNames", addForeignKeyConstraintStatement.getBaseTableName());
        validationErrors.checkRequiredField("referencedColumnNames", addForeignKeyConstraintStatement.getReferencedColumnNames());
        validationErrors.checkRequiredField("referencedTableName", addForeignKeyConstraintStatement.getReferencedTableName());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(AddForeignKeyConstraintStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(database.escapeTableName(statement.getBaseTableSchemaName(), statement.getBaseTableName())).append(" ADD CONSTRAINT ");
        if (!(database instanceof InformixDatabase)) {
            sb.append(database.escapeConstraintName(statement.getConstraintName()));
        }
        sb.append(" FOREIGN KEY (").append(database.escapeColumnNameList(statement.getBaseColumnNames())).append(") REFERENCES ").append(database.escapeTableName(statement.getReferencedTableSchemaName(), statement.getReferencedTableName())).append("(").append(database.escapeColumnNameList(statement.getReferencedColumnNames())).append(")");
        if (!(statement.getOnUpdate() == null || database instanceof OracleDatabase && statement.getOnUpdate().equalsIgnoreCase("RESTRICT"))) {
            sb.append(" ON UPDATE ").append(statement.getOnUpdate());
        }
        if (!(statement.getOnDelete() == null || database instanceof OracleDatabase && (statement.getOnDelete().equalsIgnoreCase("RESTRICT") || statement.getOnDelete().equalsIgnoreCase("NO ACTION")) || database instanceof MSSQLDatabase && statement.getOnDelete().equalsIgnoreCase("RESTRICT"))) {
            sb.append(" ON DELETE ").append(statement.getOnDelete());
        }
        if (statement.isDeferrable() || statement.isInitiallyDeferred()) {
            if (statement.isDeferrable()) {
                sb.append(" DEFERRABLE");
            }
            if (statement.isInitiallyDeferred()) {
                sb.append(" INITIALLY DEFERRED");
            }
        }
        if (database instanceof InformixDatabase) {
            sb.append(" CONSTRAINT ");
            sb.append(database.escapeConstraintName(statement.getConstraintName()));
        }
        return new Sql[]{new UnparsedSql(sb.toString(), new DatabaseObject[0])};
    }
}

