/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.text.ParseException;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.structure.type.BlobType;
import liquibase.database.structure.type.ClobType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class PostgresTypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof PostgresDatabase;
    }

    public Object convertDatabaseValueToObject(Object defaultValue, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            defaultValue = ((String)defaultValue).replaceAll("'::[\\w\\s]+$", "'");
            if (dataType == 91 || dataType == 92 || dataType == 93) {
                defaultValue = ((String)defaultValue).replaceFirst("-\\d+$", "");
            }
        }
        return super.convertDatabaseValueToObject(defaultValue, dataType, columnSize, decimalDigits, database);
    }

    public DataType getDataType(String columnTypeString, Boolean autoIncrement) {
        DataType type = super.getDataType(columnTypeString, autoIncrement);
        if (type.getDataTypeName().startsWith("TEXT(")) {
            type = this.getClobType();
        } else if (type.getDataTypeName().toLowerCase().startsWith("float8")) {
            type.setDataTypeName("FLOAT8");
        } else if (type.getDataTypeName().toLowerCase().startsWith("float4")) {
            type.setDataTypeName("FLOAT4");
        }
        if (autoIncrement != null && autoIncrement.booleanValue()) {
            if ("integer".equals(type.getDataTypeName().toLowerCase())) {
                type.setDataTypeName("serial");
            } else if ("bigint".equals(type.getDataTypeName().toLowerCase()) || "bigserial".equals(type.getDataTypeName().toLowerCase())) {
                type.setDataTypeName("bigserial");
            } else {
                type.setDataTypeName("serial");
            }
        }
        return type;
    }

    protected Object convertToCorrectObjectType(String value, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        Object returnValue = super.convertToCorrectObjectType(value, dataType, columnSize, decimalDigits, database);
        if (returnValue != null && returnValue instanceof String && ((String)returnValue).startsWith("NULL::")) {
            return null;
        }
        return returnValue;
    }

    public ClobType getClobType() {
        return new ClobType("TEXT");
    }

    public BlobType getBlobType() {
        return new BlobType("BYTEA");
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType("TIMESTAMP WITH TIME ZONE");
    }
}

