/*
 * Decompiled with CFR 0.152.
 */
package play.modules.liquibase;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.lockservice.LockService;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.hibernate.JDBCException;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.DB;
import play.modules.liquibase.LiquibaseAction;
import play.modules.liquibase.LiquibaseUpdateException;
import play.utils.Properties;

public class LiquibasePlugin
extends PlayPlugin {
    public void onApplicationStart() {
        String autoupdate = Play.configuration.getProperty("liquibase.active", "false");
        String mainchangelogpath = Play.configuration.getProperty("liquibase.changelog", "mainchangelog.xml");
        String propertiespath = Play.configuration.getProperty("liquibase.properties", "liquibase.properties");
        String contexts = Play.configuration.getProperty("liquibase.contexts", null);
        contexts = null != contexts && !contexts.trim().isEmpty() ? contexts : null;
        String actions = Play.configuration.getProperty("liquibase.actions");
        if (null == actions) {
            throw new LiquibaseUpdateException("No valid action found for liquibase operation");
        }
        ArrayList<LiquibaseAction> acts = new ArrayList<LiquibaseAction>();
        for (String action : actions.split(",")) {
            LiquibaseAction op = LiquibaseAction.valueOf(action.toUpperCase());
            acts.add(op);
        }
        Database db = null;
        if (Boolean.valueOf(autoupdate).booleanValue()) {
            Logger.info((String)"Auto update flag found and positive => let's get on with changelog update", (Object[])new Object[0]);
            InputStream pstream = null;
            InputStream clstream = null;
            try {
                Connection cnx = DB.datasource.getConnection();
                CompositeResourceAccessor composite = new CompositeResourceAccessor(new ResourceAccessor[]{new ClassLoaderResourceAccessor((ClassLoader)Play.classloader)});
                Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(cnx));
                Liquibase liquibase = new Liquibase(mainchangelogpath, (ResourceAccessor)composite, database);
                pstream = Play.classloader.getResourceAsStream(propertiespath);
                clstream = Play.classloader.getResourceAsStream(mainchangelogpath);
                if (null != pstream) {
                    Properties props = new Properties();
                    props.load(pstream);
                    for (String key : props.keySet()) {
                        String val = (String)props.get((Object)key);
                        Logger.info((String)"found parameter [%1$s] /\u00ac\u2020[%2$s] for liquibase update", (Object[])new Object[]{key, val});
                        liquibase.setChangeLogParameter(key, (Object)val);
                    }
                } else {
                    Logger.warn((String)"Could not find properties file [%s]", (Object[])new Object[]{propertiespath});
                }
                db = liquibase.getDatabase();
                for (LiquibaseAction op : acts) {
                    Logger.info((String)"Dealing with op [%s]", (Object[])new Object[]{op});
                    switch (op) {
                        case LISTLOCKS: {
                            liquibase.reportLocks(System.out);
                            break;
                        }
                        case RELEASELOCKS: {
                            LockService.getInstance((Database)db).forceReleaseLock();
                            break;
                        }
                        case SYNC: {
                            liquibase.changeLogSync(contexts);
                            break;
                        }
                        case STATUS: {
                            File tmp = File.createTempFile("liquibase", ".status");
                            liquibase.reportStatus(true, contexts, (Writer)new FileWriter(tmp));
                            Logger.info((String)"status dumped into file [%s]", (Object[])new Object[]{tmp});
                            break;
                        }
                        case UPDATE: {
                            liquibase.update(contexts);
                            break;
                        }
                        case CLEARCHECKSUMS: {
                            liquibase.clearCheckSums();
                            break;
                        }
                        case VALIDATE: {
                            try {
                                liquibase.validate();
                                break;
                            }
                            catch (ValidationFailedException e) {
                                Logger.error((Throwable)e, (String)"liquibase validation", (Object[])new Object[0]);
                            }
                        }
                    }
                    Logger.info((String)"op [%s] performed", (Object[])new Object[]{op});
                }
            }
            catch (SQLException sqe) {
                throw new LiquibaseUpdateException(sqe.getMessage());
            }
            catch (LiquibaseException e) {
                throw new LiquibaseUpdateException(e.getMessage());
            }
            catch (IOException ioe) {
                throw new LiquibaseUpdateException(ioe.getMessage());
            }
            finally {
                if (null != db) {
                    try {
                        db.close();
                    }
                    catch (DatabaseException e) {
                        Logger.warn((Throwable)e, (String)"problem closing connection", (Object[])new Object[0]);
                    }
                    catch (JDBCException jdbce) {
                        Logger.warn((Throwable)jdbce, (String)"problem closing connection", (Object[])new Object[0]);
                    }
                }
                if (null != pstream) {
                    try {
                        pstream.close();
                    }
                    catch (Exception e) {}
                }
                if (null != clstream) {
                    try {
                        clstream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        Logger.info((String)"Auto update flag [%s] != true  => skipping structural update", (Object[])new Object[]{autoupdate});
    }
}

