/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.Delayed;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.RunnableScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private volatile boolean removeOnCancel = false;
    private static final AtomicLong sequencer = new AtomicLong(0L);

    final long now() {
        return Utils.nanoTime();
    }

    boolean canRunInCurrentRunState(boolean periodic) {
        return this.isRunningOrShutdown(periodic ? this.continueExistingPeriodicTasksAfterShutdown : this.executeExistingDelayedTasksAfterShutdown);
    }

    private void delayedExecute(RunnableScheduledFuture task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            super.getQueue().add(task);
            if (this.isShutdown() && !this.canRunInCurrentRunState(task.isPeriodic()) && this.remove(task)) {
                task.cancel(false);
            } else {
                this.prestartCoreThread();
            }
        }
    }

    void reExecutePeriodic(RunnableScheduledFuture task) {
        if (this.canRunInCurrentRunState(true)) {
            super.getQueue().add(task);
            if (!this.canRunInCurrentRunState(true) && this.remove(task)) {
                task.cancel(false);
            } else {
                this.prestartCoreThread();
            }
        }
    }

    void onShutdown() {
        BlockingQueue q = super.getQueue();
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            q.clear();
        } else {
            Object[] entries = q.toArray();
            for (int i = 0; i < entries.length; ++i) {
                RunnableScheduledFuture t;
                Object e = entries[i];
                if (!(e instanceof RunnableScheduledFuture) || !(!(t = (RunnableScheduledFuture)e).isPeriodic() ? !keepDelayed : !keepPeriodic) && !t.isCancelled() || !q.remove(t)) continue;
                t.cancel(false);
            }
        }
        this.tryTerminate();
    }

    protected RunnableScheduledFuture decorateTask(Runnable runnable, RunnableScheduledFuture task) {
        return task;
    }

    protected RunnableScheduledFuture decorateTask(Callable callable, RunnableScheduledFuture task) {
        return task;
    }

    public ScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue());
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayedWorkQueue(), threadFactory);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, (BlockingQueue)new DelayedWorkQueue(), handler);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, handler);
    }

    public ScheduledFuture schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture schedule(Callable callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay < 0L) {
            delay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(delay);
        RunnableScheduledFuture t = this.decorateTask(callable, (RunnableScheduledFuture)new ScheduledFutureTask(callable, triggerTime));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime, unit.toNanos(period)));
        this.delayedExecute(t);
        return t;
    }

    public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        if (initialDelay < 0L) {
            initialDelay = 0L;
        }
        long triggerTime = this.now() + unit.toNanos(initialDelay);
        RunnableScheduledFuture t = this.decorateTask(command, (RunnableScheduledFuture)new ScheduledFutureTask(command, null, triggerTime, unit.toNanos(-delay)));
        this.delayedExecute(t);
        return t;
    }

    public void execute(Runnable command) {
        this.schedule(command, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Runnable task, Object result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.NANOSECONDS);
    }

    public Future submit(Callable task) {
        return this.schedule(task, 0L, TimeUnit.NANOSECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void setRemoveOnCancelPolicy(boolean value) {
        this.removeOnCancel = value;
    }

    public boolean getRemoveOnCancelPolicy() {
        return this.removeOnCancel;
    }

    public void shutdown() {
        super.shutdown();
    }

    public List shutdownNow() {
        return super.shutdownNow();
    }

    public BlockingQueue getQueue() {
        return super.getQueue();
    }

    static class DelayedWorkQueue
    extends AbstractQueue
    implements BlockingQueue {
        private static final int INITIAL_CAPACITY = 64;
        private transient RunnableScheduledFuture[] queue = new RunnableScheduledFuture[64];
        private final transient ReentrantLock lock = new ReentrantLock();
        private final transient Condition available = this.lock.newCondition();
        private int size = 0;

        DelayedWorkQueue() {
        }

        private void setIndex(Object f, int idx) {
            if (f instanceof ScheduledFutureTask) {
                ((ScheduledFutureTask)f).heapIndex = idx;
            }
        }

        private void siftUp(int k, RunnableScheduledFuture key) {
            int parent;
            RunnableScheduledFuture e;
            while (k > 0 && key.compareTo(e = this.queue[parent = k - 1 >>> 1]) < 0) {
                this.queue[k] = e;
                this.setIndex(e, k);
                k = parent;
            }
            this.queue[k] = key;
            this.setIndex(key, k);
        }

        private void siftDown(int k, RunnableScheduledFuture key) {
            int half = this.size >>> 1;
            while (k < half) {
                int child = (k << 1) + 1;
                RunnableScheduledFuture c = this.queue[child];
                int right = child + 1;
                if (right < this.size && c.compareTo(this.queue[right]) > 0) {
                    child = right;
                    c = this.queue[child];
                }
                if (key.compareTo(c) <= 0) break;
                this.queue[k] = c;
                this.setIndex(c, k);
                k = child;
            }
            this.queue[k] = key;
            this.setIndex(key, k);
        }

        private RunnableScheduledFuture finishPoll(RunnableScheduledFuture f) {
            int s = --this.size;
            RunnableScheduledFuture x = this.queue[s];
            this.queue[s] = null;
            if (s != 0) {
                this.siftDown(0, x);
                this.available.signalAll();
            }
            this.setIndex(f, -1);
            return f;
        }

        private void grow() {
            int oldCapacity = this.queue.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            RunnableScheduledFuture[] newqueue = new RunnableScheduledFuture[newCapacity];
            System.arraycopy(this.queue, 0, newqueue, 0, this.queue.length);
            this.queue = newqueue;
        }

        private int indexOf(Object x) {
            if (x != null) {
                for (int i = 0; i < this.size; ++i) {
                    if (!x.equals(this.queue[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object x) {
            boolean removed;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i = x instanceof ScheduledFutureTask ? ((ScheduledFutureTask)x).heapIndex : this.indexOf(x);
                removed = i >= 0 && i < this.size && this.queue[i] == x;
                if (removed) {
                    this.setIndex(x, -1);
                    int s = --this.size;
                    RunnableScheduledFuture replacement = this.queue[s];
                    this.queue[s] = null;
                    if (s != i) {
                        this.siftDown(i, replacement);
                        if (this.queue[i] == replacement) {
                            this.siftUp(i, replacement);
                        }
                    }
                }
            }
            finally {
                lock.unlock();
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            int s;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                s = this.size;
            }
            finally {
                lock.unlock();
            }
            return s;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object peek() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture runnableScheduledFuture = this.queue[0];
                return runnableScheduledFuture;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(Object x) {
            if (x == null) {
                throw new NullPointerException();
            }
            RunnableScheduledFuture e = (RunnableScheduledFuture)x;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                boolean notify;
                int i = this.size;
                if (i >= this.queue.length) {
                    this.grow();
                }
                this.size = i + 1;
                if (i == 0) {
                    notify = true;
                    this.queue[0] = e;
                    this.setIndex(e, 0);
                } else {
                    notify = e.compareTo(this.queue[0]) < 0;
                    this.siftUp(i, e);
                }
                if (notify) {
                    this.available.signalAll();
                }
            }
            finally {
                lock.unlock();
            }
            return true;
        }

        public void put(Object e) {
            this.offer(e);
        }

        public boolean add(Runnable e) {
            return this.offer(e);
        }

        public boolean offer(Object e, long timeout, TimeUnit unit) {
            return this.offer(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture first = this.queue[0];
                if (first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                    Object var3_3 = null;
                    return var3_3;
                }
                RunnableScheduledFuture runnableScheduledFuture = this.finishPoll(first);
                return runnableScheduledFuture;
            }
            finally {
                lock.unlock();
            }
        }

        public Object take() throws InterruptedException {
            ReentrantLock lock = this.lock;
            lock.lockInterruptibly();
            try {
                while (true) {
                    RunnableScheduledFuture first;
                    if ((first = this.queue[0]) == null) {
                        this.available.await();
                        continue;
                    }
                    long delay = first.getDelay(TimeUnit.NANOSECONDS);
                    if (delay > 0L) {
                        this.available.await(delay, TimeUnit.NANOSECONDS);
                        continue;
                    }
                    RunnableScheduledFuture runnableScheduledFuture = this.finishPoll(first);
                    return runnableScheduledFuture;
                }
            }
            finally {
                lock.unlock();
            }
        }

        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            long nanos = unit.toNanos(timeout);
            long deadline = Utils.nanoTime() + nanos;
            ReentrantLock lock = this.lock;
            lock.lockInterruptibly();
            try {
                while (true) {
                    RunnableScheduledFuture first;
                    if ((first = this.queue[0]) == null) {
                        if (nanos <= 0L) {
                            Object var10_8 = null;
                            return var10_8;
                        }
                        this.available.await(nanos, TimeUnit.NANOSECONDS);
                        nanos = deadline - Utils.nanoTime();
                        continue;
                    }
                    long delay = first.getDelay(TimeUnit.NANOSECONDS);
                    if (delay > 0L) {
                        if (nanos <= 0L) {
                            Object var13_9 = null;
                            return var13_9;
                        }
                        if (delay > nanos) {
                            delay = nanos;
                        }
                        this.available.await(delay, TimeUnit.NANOSECONDS);
                        nanos = deadline - Utils.nanoTime();
                        continue;
                    }
                    RunnableScheduledFuture runnableScheduledFuture = this.finishPoll(first);
                    return runnableScheduledFuture;
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    RunnableScheduledFuture t = this.queue[i];
                    if (t == null) continue;
                    this.queue[i] = null;
                    this.setIndex(t, -1);
                }
                this.size = 0;
            }
            finally {
                lock.unlock();
            }
        }

        private RunnableScheduledFuture pollExpired() {
            RunnableScheduledFuture first = this.queue[0];
            if (first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L) {
                return null;
            }
            this.setIndex(first, -1);
            int s = --this.size;
            RunnableScheduledFuture x = this.queue[s];
            this.queue[s] = null;
            if (s != 0) {
                this.siftDown(0, x);
            }
            return first;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int drainTo(Collection c) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (c == this) {
                throw new IllegalArgumentException();
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture first;
                int n = 0;
                while ((first = this.pollExpired()) != null) {
                    c.add(first);
                    ++n;
                }
                if (n > 0) {
                    this.available.signalAll();
                }
                int n2 = n;
                return n2;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int drainTo(Collection c, int maxElements) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (c == this) {
                throw new IllegalArgumentException();
            }
            if (maxElements <= 0) {
                return 0;
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture first;
                int n;
                for (n = 0; n < maxElements && (first = this.pollExpired()) != null; ++n) {
                    c.add(first);
                }
                if (n > 0) {
                    this.available.signalAll();
                }
                int n2 = n;
                return n2;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Object[] objectArray = Arrays.copyOf(this.queue, this.size);
                return objectArray;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] a) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (a.length < this.size) {
                    Object[] objectArray = Arrays.copyOf(this.queue, this.size, a.getClass());
                    return objectArray;
                }
                System.arraycopy(this.queue, 0, a, 0, this.size);
                if (a.length > this.size) {
                    a[this.size] = null;
                }
                Object[] objectArray = a;
                return objectArray;
            }
            finally {
                lock.unlock();
            }
        }

        public Iterator iterator() {
            return new Itr(this.toArray());
        }

        private class Itr
        implements Iterator {
            final Object[] array;
            int cursor;
            int lastRet = -1;

            Itr(Object[] array) {
                this.array = array;
            }

            public boolean hasNext() {
                return this.cursor < this.array.length;
            }

            public Object next() {
                if (this.cursor >= this.array.length) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.cursor;
                return (Runnable)this.array[this.cursor++];
            }

            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                DelayedWorkQueue.this.remove(this.array[this.lastRet]);
                this.lastRet = -1;
            }
        }
    }

    private class ScheduledFutureTask
    extends FutureTask
    implements RunnableScheduledFuture {
        private final long sequenceNumber;
        private long time;
        private final long period;
        int heapIndex;

        ScheduledFutureTask(Runnable r, Object result, long ns) {
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, Object result, long ns, long period) {
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable callable, long ns) {
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        public long getDelay(TimeUnit unit) {
            long d = unit.convert(this.time - ScheduledThreadPoolExecutor.this.now(), TimeUnit.NANOSECONDS);
            return d;
        }

        public int compareTo(Object other) {
            Delayed otherd = (Delayed)other;
            if (otherd == this) {
                return 0;
            }
            if (otherd instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - otherd.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }

        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : ScheduledThreadPoolExecutor.this.now() - p;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && ScheduledThreadPoolExecutor.this.removeOnCancel && this.heapIndex >= 0) {
                ScheduledThreadPoolExecutor.this.remove(this);
            }
            return cancelled;
        }

        public void run() {
            boolean periodic = this.isPeriodic();
            if (!ScheduledThreadPoolExecutor.this.canRunInCurrentRunState(periodic)) {
                this.cancel(false);
            } else if (!periodic) {
                ScheduledFutureTask.super.run();
            } else if (ScheduledFutureTask.super.runAndReset()) {
                this.setNextRunTime();
                ScheduledThreadPoolExecutor.this.reExecutePeriodic(this);
            }
        }
    }
}

