/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddDefaultValueStatement;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;

public class AddDefaultValueChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnDataType;
    private String defaultValue;
    private String defaultValueNumeric;
    private String defaultValueDate;
    private Boolean defaultValueBoolean;
    private DatabaseFunction defaultValueComputed;

    public AddDefaultValueChange() {
        super("addDefaultValue", "Add Default Value", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public void setDefaultValueNumeric(String defaultValueNumeric) {
        this.defaultValueNumeric = defaultValueNumeric;
    }

    public String getDefaultValueDate() {
        return this.defaultValueDate;
    }

    public void setDefaultValueDate(String defaultValueDate) {
        this.defaultValueDate = defaultValueDate;
    }

    public Boolean getDefaultValueBoolean() {
        return this.defaultValueBoolean;
    }

    public void setDefaultValueBoolean(Boolean defaultValueBoolean) {
        this.defaultValueBoolean = defaultValueBoolean;
    }

    public DatabaseFunction getDefaultValueComputed() {
        return this.defaultValueComputed;
    }

    public void setDefaultValueComputed(DatabaseFunction defaultValueComputed) {
        this.defaultValueComputed = defaultValueComputed;
    }

    public SqlStatement[] generateStatements(Database database) {
        Object defaultValue = null;
        if (this.getDefaultValue() != null) {
            defaultValue = this.getDefaultValue();
        } else if (this.getDefaultValueBoolean() != null) {
            defaultValue = (boolean)this.getDefaultValueBoolean();
        } else if (this.getDefaultValueNumeric() != null) {
            try {
                defaultValue = NumberFormat.getInstance(Locale.US).parse(this.getDefaultValueNumeric());
            }
            catch (ParseException e) {
                defaultValue = new DatabaseFunction(this.getDefaultValueNumeric());
            }
        } else if (this.getDefaultValueDate() != null) {
            try {
                defaultValue = new ISODateFormat().parse(this.getDefaultValueDate());
            }
            catch (ParseException e) {
                defaultValue = new DatabaseFunction(this.getDefaultValueDate());
            }
        } else if (this.getDefaultValueComputed() != null) {
            defaultValue = this.getDefaultValueComputed();
        }
        return new SqlStatement[]{new AddDefaultValueStatement(this.getSchemaName(), this.getTableName(), this.getColumnName(), this.getColumnDataType(), defaultValue)};
    }

    protected Change[] createInverses() {
        DropDefaultValueChange inverse = new DropDefaultValueChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setColumnName(this.getColumnName());
        inverse.setColumnDataType(this.getColumnDataType());
        return new Change[]{inverse};
    }

    public String getConfirmationMessage() {
        return "Default value added to " + this.getTableName() + "." + this.getColumnName();
    }
}

