/*
 * Decompiled with CFR 0.152.
 */
package play.modules.log4play;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import play.Logger;
import play.Play;
import play.libs.F;
import play.modules.log4play.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stats<KEY> {
    protected ConcurrentHashMap<KEY, ExecutionTimes> map = new ConcurrentHashMap();
    public F.EventStream<ExecutionEvent> executionStream = new F.EventStream();
    protected ExecutorService executor = Executors.newFixedThreadPool(5);

    public Stats() {
        this.now();
    }

    protected void log(String msg) {
        if (!Play.mode.equals((Object)Play.Mode.PROD)) {
            Logger.info((String)msg, (Object[])new Object[0]);
        }
    }

    public void now() {
        try {
            this.executor.submit(new Callable<Stats>(){

                @Override
                public Stats call() throws Exception {
                    Stats.this.log("Firing job to listen on execution stream");
                    while (true) {
                        Stats.this.log("Waiting on Execution Event...");
                        Stats.this.await((F.Promise<ExecutionEvent>)Stats.this.executionStream.nextEvent());
                    }
                }
            });
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }

    public long executions(KEY key) {
        ExecutionTimes et = this.map.get(key);
        if (et == null) {
            return 0L;
        }
        long current = et.executions.get();
        return current;
    }

    public long executionTimes(KEY key) {
        ExecutionTimes et = this.map.get(key);
        if (et == null) {
            return 0L;
        }
        long current = et.executionTimes.get();
        return current;
    }

    public void record(KEY key, long executionTime) {
        this.executionStream.publish((Object)new ExecutionEvent(key, executionTime));
    }

    protected void await(F.Promise<ExecutionEvent> promise) {
        try {
            ExecutionEvent e = (ExecutionEvent)promise.get();
            this.log("Received Execution Event: " + e);
            this.map.putIfAbsent(e.key, new ExecutionTimes());
            ExecutionTimes et = this.map.get(e.key);
            if (et == null) {
                throw new RuntimeException("Invalid Key: " + et);
            }
            long execs = et.executions.incrementAndGet();
            this.log("Executions: " + execs);
            long times = et.executionTimes.getAndAdd(e.executionTime);
            this.log("Execution Times: " + times);
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }

    public long averageTime(KEY key) {
        long executions = this.executions(key);
        long times = this.executionTimes(key);
        if (executions <= 0L) {
            return 0L;
        }
        return times / executions;
    }

    protected static class ExecutionTimes {
        protected AtomicLong executions = new AtomicLong();
        protected AtomicLong executionTimes = new AtomicLong();

        protected ExecutionTimes() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExecutionEvent {
        public KEY key;
        public long executionTime;

        public ExecutionEvent(KEY key, long executionTime) {
            this.key = key;
            this.executionTime = executionTime;
        }
    }
}

