/*
 * Decompiled with CFR 0.152.
 */
package play.modules.betterlogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.modules.betterlogs.BetterLogsEnhancer;

public class BetterLogsPlugin
extends PlayPlugin {
    static final Pattern PREFIX_PATTERN = Pattern.compile("%file|%line|%class|%method|%relativeFile|%simpleClass|%package|%signature");
    static final Pattern TRAILING_SPACES_PATTERN = Pattern.compile("(\\d+)(t|ws)?");
    static String stringFormatPrefix;
    static ArrayList<String> argsPrefix;
    static boolean disabled;

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        if (!disabled) {
            new BetterLogsEnhancer().enhanceThisClass(applicationClass);
        }
    }

    public void onConfigurationRead() {
        String trailingSpaces;
        disabled = "true".equals(Play.configuration.getProperty("betterlogs.disabled"));
        if (disabled) {
            Logger.warn((String)"BetterLogs is disabled. The classes are no more enhanced. If you enable it again, don't forget to clean your app before to force Play to enhance all the classes.", (Object[])new Object[0]);
        }
        ArrayList<String> newArgsPrefix = new ArrayList<String>();
        String prefix = Play.configuration.getProperty("betterlogs.prefix", "[%relativeFile:%line] %method() ::");
        Matcher matcher = PREFIX_PATTERN.matcher(prefix);
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            int lastEnd = 0;
            do {
                newArgsPrefix.add(matcher.group().substring(1));
                sb.append(prefix.substring(lastEnd, matcher.start()).replace("%", "%%")).append("%s");
                lastEnd = matcher.end();
            } while (matcher.find());
            sb.append(prefix.substring(lastEnd));
        }
        if ((matcher = TRAILING_SPACES_PATTERN.matcher(trailingSpaces = Play.configuration.getProperty("betterlogs.prefix.trailingSpaces", "1ws"))).matches()) {
            char c;
            char c2 = c = "t".equals(matcher.group(2)) ? (char)'\t' : ' ';
            for (int nb = Integer.parseInt(matcher.group(1)); nb > 0; --nb) {
                sb.append(c);
            }
        }
        argsPrefix = newArgsPrefix;
        stringFormatPrefix = sb.toString();
    }

    public static void log(String level, String clazz, String clazzSimpleName, String packageName, String method, String signature, String fileName, String relativeFileName, int line, Object[] args) {
        Throwable throwable = null;
        String pattern = "";
        if (args[0] instanceof Throwable) {
            throwable = (Throwable)args[0];
            pattern = (String)args[1];
        } else {
            pattern = (String)args[0];
        }
        pattern = stringFormatPrefix + pattern;
        Object[] betterLogsArgs = new Object[argsPrefix.size()];
        int i = 0;
        for (String argName : argsPrefix) {
            if ("class".equals(argName)) {
                betterLogsArgs[i] = clazz;
            }
            if ("simpleClass".equals(argName)) {
                betterLogsArgs[i] = clazzSimpleName;
            }
            if ("package".equals(argName)) {
                betterLogsArgs[i] = packageName;
            }
            if ("method".equals(argName)) {
                betterLogsArgs[i] = method;
            }
            if ("file".equals(argName)) {
                betterLogsArgs[i] = fileName;
            }
            if ("line".equals(argName)) {
                betterLogsArgs[i] = line;
            }
            if ("relativeFile".equals(argName)) {
                betterLogsArgs[i] = relativeFileName;
            }
            if ("signature".equals(argName)) {
                betterLogsArgs[i] = signature;
            }
            ++i;
        }
        if ("trace".equals(level)) {
            Logger.trace((String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 1));
        } else if ("debug".equals(level)) {
            if (throwable != null) {
                Logger.debug((Throwable)throwable, (String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 2));
            } else {
                Logger.debug((String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 1));
            }
        } else if ("info".equals(level)) {
            if (throwable != null) {
                Logger.info((Throwable)throwable, (String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 2));
            } else {
                Logger.info((String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 1));
            }
        } else if ("warn".equals(level)) {
            if (throwable != null) {
                Logger.warn((Throwable)throwable, (String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 2));
            } else {
                Logger.warn((String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 1));
            }
        } else if ("error".equals(level)) {
            if (throwable != null) {
                Logger.error((Throwable)throwable, (String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 2));
            } else {
                Logger.error((String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 1));
            }
        } else if ("fatal".equals(level)) {
            if (throwable != null) {
                Logger.fatal((Throwable)throwable, (String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 2));
            } else {
                Logger.fatal((String)pattern, (Object[])BetterLogsPlugin.handleLogArgs(betterLogsArgs, args, 1));
            }
        }
    }

    private static Object[] handleLogArgs(Object[] injected, Object[] original, int skip) {
        Object[] kept = Arrays.copyOfRange(original, skip, original.length - 1);
        kept = original[original.length - 1] instanceof Object[] ? BetterLogsPlugin.concat(kept, (Object[])original[original.length - 1]) : BetterLogsPlugin.concat(kept, new Object[]{original[original.length - 1]});
        return BetterLogsPlugin.concat(injected, kept);
    }

    private static Object[] concat(Object[] o1, Object[] o2) {
        Object[] result = new Object[o1.length + o2.length];
        for (int i = 0; i < o1.length; ++i) {
            result[i] = o1[i];
        }
        for (int j = 0; j < o2.length; ++j) {
            result[o1.length + j] = o2[j];
        }
        return result;
    }

    static {
        disabled = false;
    }
}

