/*
 * Decompiled with CFR 0.152.
 */
package play.modules.yml;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import play.Play;
import play.db.jpa.JPASupport;
import play.modules.yml.YmlExtractorUtil;
import play.modules.yml.models.YmlObject;

public class YmlExtractor {
    private static HashMap<String, YmlObject> ymlObjects = new HashMap();

    public static void main(String[] args) throws Exception {
        File root = new File(System.getProperty("application.path", "/home/bsimard/workspace/LogiSima-bsimard"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        String filename = "data";
        String output = "conf/";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--")) continue;
            if (args[i].startsWith("--filename=")) {
                filename = args[i].substring(11);
            }
            if (!args[i].startsWith("--output=")) continue;
            output = args[i].substring(9);
        }
        EntityManager em = YmlExtractorUtil.iniateJPA();
        List entities = Play.classloader.getAnnotatedClasses(Entity.class);
        for (Class entity : entities) {
            List objects = em.createQuery("select e from " + entity.getCanonicalName() + " as e").getResultList();
            for (JPASupport jpaSupport : objects) {
                YmlObject ymlObject = YmlExtractorUtil.object2YmlObject(jpaSupport);
                ymlObjects.put(YmlExtractorUtil.getObjectId(jpaSupport), ymlObject);
            }
        }
        YmlExtractorUtil.writeYml(output, filename, ymlObjects);
    }
}

