/*
 * Decompiled with CFR 0.152.
 */
package play.modules.yml;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.sql.DataSource;
import org.apache.log4j.Level;
import org.hibernate.ejb.Ejb3Configuration;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import play.Logger;
import play.Play;
import play.db.jpa.JPASupport;
import play.db.jpa.Model;
import play.modules.yml.models.YmlObject;
import play.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YmlExtractorUtil {
    private static final String TAB = "    ";

    public static void writeYml(String output, String filename, HashMap<String, YmlObject> ymlObjects) throws IOException {
        File file = new File(output + "/" + filename + ".yml");
        FileOutputStream fop = new FileOutputStream(file);
        fop.write("# Generated by logisima-play-yml (http://github.com/sim51/logisima-play-yml).\n".getBytes());
        fop.write("# This module is a part of LogiSima (http://www.logisima.com).\n".getBytes());
        Iterator<Map.Entry<String, YmlObject>> it = ymlObjects.entrySet().iterator();
        String tmp = "";
        while (it.hasNext()) {
            Map.Entry<String, YmlObject> object = it.next();
            YmlObject ymlObject = object.getValue();
            if (ymlObject.isAlreadyWrite().booleanValue()) continue;
            tmp = YmlExtractorUtil.writeObject2Yml(ymlObjects, ymlObject);
            fop.write(tmp.getBytes());
        }
        fop.flush();
        fop.close();
    }

    public static String writeObject2Yml(HashMap<String, YmlObject> ymlObjects, YmlObject object) {
        String ymlText = "";
        if (!object.isAlreadyWrite().booleanValue()) {
            object.setAlreadyWrite(Boolean.TRUE);
            ymlObjects.put(object.getId(), object);
            if (object.getChildren().size() != 0) {
                for (int i = 0; i < object.getChildren().size(); ++i) {
                    ymlText = ymlText + YmlExtractorUtil.writeObject2Yml(ymlObjects, ymlObjects.get(object.getChildren().get(i)));
                }
            }
            ymlText = ymlText + object.getYmlValue();
        }
        return ymlText;
    }

    public static YmlObject object2YmlObject(JPASupport jpaSupport) throws IllegalArgumentException, IllegalAccessException, ParseException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        YmlObject ymlObject = new YmlObject();
        ymlObject.setId(YmlExtractorUtil.getObjectId(jpaSupport));
        String stringObject = "\n" + jpaSupport.getClass().getCanonicalName() + "(" + YmlExtractorUtil.getObjectId(jpaSupport) + "):\n";
        Logger.info((String)("Generate YML for class id :" + YmlExtractorUtil.getObjectId(jpaSupport)), (Object[])new Object[0]);
        for (Field field : jpaSupport.getClass().getFields()) {
            Map.Entry myObj;
            int i;
            String[] tmpValues;
            HashMap<String, Object> data = new HashMap<String, Object>();
            String name = field.getName();
            Boolean valueIsSet = Boolean.FALSE;
            if (name.equals("id") || name.equals("willBeSaved")) continue;
            if (List.class.isInstance(field.get(jpaSupport))) {
                List myList = (List)field.get(jpaSupport);
                tmpValues = new String[myList.size()];
                for (int i2 = 0; i2 < myList.size(); ++i2) {
                    tmpValues[i2] = YmlExtractorUtil.getObjectId(myList.get(i2));
                    if (!Model.class.isInstance(myList.get(i2))) continue;
                    ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myList.get(i2)));
                }
                data.put(name, tmpValues);
                valueIsSet = Boolean.TRUE;
            }
            if (Map.class.isInstance(field.get(jpaSupport))) {
                Map myMap = (Map)field.get(jpaSupport);
                tmpValues = new String[myMap.size()];
                Iterator it = myMap.entrySet().iterator();
                i = 0;
                while (it.hasNext()) {
                    myObj = it.next();
                    tmpValues[i] = YmlExtractorUtil.getObjectId(myObj);
                    if (Model.class.isInstance(myObj)) {
                        ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myObj));
                    }
                    ++i;
                }
                data.put(name, tmpValues);
                valueIsSet = Boolean.TRUE;
            }
            if (Set.class.isInstance(field.get(jpaSupport))) {
                Set mySet = (Set)field.get(jpaSupport);
                tmpValues = new String[mySet.size()];
                Iterator it = mySet.iterator();
                i = 0;
                while (it.hasNext()) {
                    myObj = it.next();
                    tmpValues[i] = YmlExtractorUtil.getObjectId(myObj);
                    if (Model.class.isInstance(myObj)) {
                        ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myObj));
                    }
                    ++i;
                }
                data.put(name, tmpValues);
                valueIsSet = Boolean.TRUE;
            }
            if (field.isAnnotationPresent(Lob.class)) {
                data.put(name, field.get(jpaSupport).toString());
                valueIsSet = Boolean.TRUE;
            }
            if (Model.class.isInstance(field.get(jpaSupport))) {
                ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(field.get(jpaSupport)));
                data.put(name, YmlExtractorUtil.getObjectId(field.get(jpaSupport)));
                valueIsSet = Boolean.TRUE;
            }
            if (Date.class.isInstance(field.get(jpaSupport))) {
                SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd hh:mm:ss");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Date myDate = sdf.parse(field.get(jpaSupport).toString());
                data.put(name, df.format(myDate));
                valueIsSet = Boolean.TRUE;
            }
            if (!valueIsSet.booleanValue()) {
                String tmpValue = "" + field.get(jpaSupport);
                data.put(name, tmpValue);
            }
            String value = yaml.dump(data).replaceAll("^", TAB);
            value = value.replaceAll("- ", "    - ");
            stringObject = stringObject + value;
        }
        ymlObject.setYmlValue(stringObject);
        return ymlObject;
    }

    public static String getObjectId(Object object) throws IllegalArgumentException, IllegalAccessException {
        JPASupport jpaSupport = (JPASupport)object;
        String objectId = null;
        if (jpaSupport instanceof Model) {
            objectId = ((Model)jpaSupport).getClass().getSimpleName() + "_" + ((Model)jpaSupport).id.toString();
        } else {
            Field fieldId = null;
            for (Field field : jpaSupport.getClass().getFields()) {
                if (field.getAnnotation(Id.class) == null) continue;
                fieldId = field;
            }
            if (fieldId != null) {
                objectId = fieldId.get(jpaSupport).toString();
            }
        }
        return objectId;
    }

    public static String getDefaultDialect(String driver) {
        if (driver.equals("org.hsqldb.jdbcDriver")) {
            return "org.hibernate.dialect.HSQLDialect";
        }
        if (driver.equals("com.mysql.jdbc.Driver")) {
            return "play.db.jpa.MySQLDialect";
        }
        String dialect = Play.configuration.getProperty("jpa.dialect");
        if (dialect != null) {
            return dialect;
        }
        throw new UnsupportedOperationException("I do not know which hibernate dialect to use with " + driver + ", use the property jpa.dialect in config file");
    }

    public static EntityManager iniateJPA() throws PropertyVetoException {
        String[] moreEntities;
        Properties p = Play.configuration;
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setDriverClass(p.getProperty("db.driver"));
        ds.setJdbcUrl(p.getProperty("db.url"));
        ds.setUser(p.getProperty("db.user"));
        ds.setPassword(p.getProperty("db.pass"));
        ds.setAcquireRetryAttempts(1);
        ds.setAcquireRetryDelay(0);
        ds.setCheckoutTimeout(Integer.parseInt(p.getProperty("db.pool.timeout", "5000")));
        ds.setBreakAfterAcquireFailure(true);
        ds.setMaxPoolSize(Integer.parseInt(p.getProperty("db.pool.maxSize", "30")));
        ds.setMinPoolSize(Integer.parseInt(p.getProperty("db.pool.minSize", "1")));
        ds.setTestConnectionOnCheckout(true);
        List classes = Play.classloader.getAnnotatedClasses(Entity.class);
        Ejb3Configuration cfg = new Ejb3Configuration();
        cfg.setDataSource((DataSource)ds);
        if (!Play.configuration.getProperty("jpa.ddl", "update").equals("none")) {
            cfg.setProperty("hibernate.hbm2ddl.auto", Play.configuration.getProperty("jpa.ddl", "update"));
        }
        cfg.setProperty("hibernate.dialect", YmlExtractorUtil.getDefaultDialect(Play.configuration.getProperty("db.driver")));
        cfg.setProperty("javax.persistence.transaction", "RESOURCE_LOCAL");
        if (Play.configuration.getProperty("jpa.debugSQL", "false").equals("true")) {
            org.apache.log4j.Logger.getLogger((String)"org.hibernate.SQL").setLevel(Level.ALL);
        } else {
            org.apache.log4j.Logger.getLogger((String)"org.hibernate.SQL").setLevel(Level.OFF);
        }
        cfg.addProperties((Properties)Utils.Maps.filterMap((Map)Play.configuration, (String)"^hibernate\\..*"));
        try {
            Field field = cfg.getClass().getDeclaredField("overridenClassLoader");
            field.setAccessible(true);
            field.set(cfg, Play.classloader);
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Error trying to override the hibernate classLoader (new hibernate version ???)", (Object[])new Object[0]);
        }
        for (Class clazz : classes) {
            if (!clazz.isAnnotationPresent(Entity.class)) continue;
            cfg.addAnnotatedClass(clazz);
            Logger.trace((String)"JPA Model : %s", (Object[])new Object[]{clazz});
        }
        for (String entity : moreEntities = Play.configuration.getProperty("jpa.entities", "").split(", ")) {
            if (entity.trim().equals("")) continue;
            try {
                cfg.addAnnotatedClass(Play.classloader.loadClass(entity));
            }
            catch (Exception e) {
                Logger.warn((String)"JPA -> Entity not found: %s", (Object[])new Object[]{entity});
            }
        }
        Logger.trace((String)"Initializing JPA ...", (Object[])new Object[0]);
        EntityManagerFactory entityManagerFactory = cfg.buildEntityManagerFactory();
        return entityManagerFactory.createEntityManager();
    }
}

