/*
 * Decompiled with CFR 0.152.
 */
package play.modules.yml;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.sql.DataSource;
import org.apache.log4j.Level;
import org.hibernate.Hibernate;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.proxy.HibernateProxy;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import play.Logger;
import play.Play;
import play.db.jpa.JPABase;
import play.db.jpa.Model;
import play.modules.yml.YmlExtractor;
import play.modules.yml.models.YmlObject;
import play.utils.Utils;

public class YmlExtractorUtil {
    private static final String TAB = "    ";

    public static void writeYml(String output, String filename) throws IOException {
        File file = new File(output + "/" + filename + ".yml");
        FileOutputStream fop = new FileOutputStream(file);
        fop.write("# Generated by logisima-play-yml (http://github.com/sim51/logisima-play-yml).\n".getBytes());
        fop.write("# This module is a part of LogiSima (http://www.logisima.com).\n".getBytes());
        Iterator<Map.Entry<String, YmlObject>> it = YmlExtractor.ymlObjects.entrySet().iterator();
        String tmp = "";
        while (it.hasNext()) {
            Map.Entry<String, YmlObject> object = it.next();
            YmlObject ymlObject = object.getValue();
            if (ymlObject.isAlreadyWrite().booleanValue()) continue;
            tmp = YmlExtractorUtil.writeObject2Yml(ymlObject, 0);
            fop.write(tmp.getBytes());
        }
        fop.flush();
        fop.close();
    }

    public static String writeObject2Yml(YmlObject object, int level) {
        ++level;
        String ymlText = "";
        if (!object.isAlreadyWrite().booleanValue()) {
            object.setAlreadyWrite(Boolean.TRUE);
            YmlExtractor.ymlObjects.put(object.getId(), object);
            if (object.getChildren().size() != 0) {
                for (int i = 0; i < object.getChildren().size(); ++i) {
                    ymlText = ymlText + YmlExtractorUtil.writeObject2Yml(YmlExtractor.ymlObjects.get(object.getChildren().get(i)), level);
                }
            }
            ymlText = ymlText + object.getYmlValue();
        }
        return ymlText;
    }

    public static YmlObject object2YmlObject(JPABase jpaBase) throws IllegalArgumentException, IllegalAccessException, ParseException, SecurityException, NoSuchMethodException, InvocationTargetException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        YmlObject ymlObject = new YmlObject();
        ymlObject.setId(YmlExtractorUtil.getObjectId(jpaBase));
        String stringObject = "\n" + YmlExtractorUtil.getObjectClassName(jpaBase) + "(" + YmlExtractorUtil.getObjectId(jpaBase) + "):\n";
        Logger.info((String)("Generate YML for class id :" + YmlExtractorUtil.getObjectId(jpaBase) + "(" + jpaBase.getClass().getFields().length + "fields)"), (Object[])new Object[0]);
        if (jpaBase.getClass().getCanonicalName().contains("_$$_")) {
            Hibernate.initialize((Object)jpaBase);
            HibernateProxy proxy = (HibernateProxy)jpaBase;
            jpaBase = (JPABase)proxy.getHibernateLazyInitializer().getImplementation();
        }
        for (Field field : jpaBase.getClass().getFields()) {
            Map.Entry myObj;
            int i;
            String[] tmpValues;
            HashMap<String, Object> data = new HashMap<String, Object>();
            String name = field.getName();
            if (name.equals("id") || name.equals("willBeSaved") || YmlExtractorUtil.isFieldHasMappedByInAnnotation(field).booleanValue()) continue;
            Boolean valueIsSet = Boolean.FALSE;
            Logger.debug((String)("Generated field " + name), (Object[])new Object[0]);
            if (field.get(jpaBase) == null) continue;
            if (List.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field " + name + " type is List"), (Object[])new Object[0]);
                List myList = (List)field.get(jpaBase);
                if (!myList.isEmpty() && myList.size() > 0) {
                    tmpValues = new String[myList.size()];
                    for (int i2 = 0; i2 < myList.size(); ++i2) {
                        tmpValues[i2] = YmlExtractorUtil.getObjectId(myList.get(i2));
                        if (!Model.class.isInstance(myList.get(i2))) continue;
                        ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myList.get(i2)));
                    }
                    data.put(name, tmpValues);
                }
                valueIsSet = Boolean.TRUE;
            }
            if (Map.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field  " + name + " type is Map"), (Object[])new Object[0]);
                Map myMap = (Map)field.get(jpaBase);
                if (myMap != null && myMap.size() > 0) {
                    tmpValues = new String[myMap.size()];
                    Iterator it = myMap.entrySet().iterator();
                    i = 0;
                    while (it.hasNext()) {
                        myObj = it.next();
                        tmpValues[i] = YmlExtractorUtil.getObjectId(myObj);
                        if (myObj != null && Model.class.isInstance(myObj) && YmlExtractorUtil.getObjectId(myObj) != null) {
                            ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myObj));
                        }
                        ++i;
                    }
                    data.put(name, tmpValues);
                }
                valueIsSet = Boolean.TRUE;
            }
            if (Set.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field  " + name + " type is Set"), (Object[])new Object[0]);
                Set mySet = (Set)field.get(jpaBase);
                if (mySet != null && mySet.size() > 0) {
                    tmpValues = new String[mySet.size()];
                    Iterator it = mySet.iterator();
                    i = 0;
                    while (it.hasNext()) {
                        myObj = it.next();
                        tmpValues[i] = YmlExtractorUtil.getObjectId(myObj);
                        if (myObj != null && Model.class.isInstance(myObj) && YmlExtractorUtil.getObjectId(myObj) != null) {
                            ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myObj));
                        }
                        ++i;
                    }
                    data.put(name, tmpValues);
                }
                valueIsSet = Boolean.TRUE;
            }
            if (field.isAnnotationPresent(Lob.class)) {
                Logger.debug((String)("Field  " + name + " type is a Lob"), (Object[])new Object[0]);
                if (field.get(jpaBase) != null) {
                    data.put(name, field.get(jpaBase).toString());
                }
                valueIsSet = Boolean.TRUE;
            }
            if (jpaBase != null && Model.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field  " + name + " type is a Model"), (Object[])new Object[0]);
                ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(field.get(jpaBase)));
                data.put(name, YmlExtractorUtil.getObjectId(field.get(jpaBase)));
                valueIsSet = Boolean.TRUE;
            }
            if (Date.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field  " + name + " type is Date"), (Object[])new Object[0]);
                SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd hh:mm:ss");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Date myDate = sdf.parse(field.get(jpaBase).toString());
                data.put(name, df.format(myDate));
                valueIsSet = Boolean.TRUE;
            }
            if (!valueIsSet.booleanValue()) {
                Logger.debug((String)("Field  " + name + " type is Basic"), (Object[])new Object[0]);
                String tmpValue = "" + field.get(jpaBase);
                data.put(name, tmpValue);
                valueIsSet = Boolean.TRUE;
            }
            if (!valueIsSet.booleanValue() || data.isEmpty()) continue;
            String value = yaml.dump(data).replaceAll("^", TAB);
            value = value.replaceAll("- ", "    - ");
            stringObject = stringObject + value;
        }
        ymlObject.setYmlValue(stringObject);
        return ymlObject;
    }

    public static String getObjectClassName(Object object) {
        String classname = object.getClass().getSimpleName();
        if (classname.contains("_$$_")) {
            classname = classname.split("_")[0];
        }
        return classname;
    }

    public static String getObjectId(Object object) throws IllegalArgumentException, IllegalAccessException {
        JPABase jpaBase = (JPABase)object;
        String objectId = null;
        if (jpaBase != null && jpaBase instanceof Model) {
            Model myModel = (Model)jpaBase;
            objectId = YmlExtractorUtil.getObjectClassName(object);
            objectId = objectId + "_";
            objectId = objectId + myModel.getId();
        } else {
            Field fieldId = null;
            for (Field field : jpaBase.getClass().getFields()) {
                if (field.getAnnotation(Id.class) == null) continue;
                fieldId = field;
            }
            if (fieldId != null) {
                objectId = fieldId.get(jpaBase).toString();
            }
        }
        if (object.getClass().getCanonicalName().contains("_$$_javassist_")) {
            String[] elements = object.getClass().getCanonicalName().split("_");
            objectId = YmlExtractorUtil.getObjectClassName(object) + "_" + elements[elements.length - 1];
        }
        return objectId;
    }

    public static String getDefaultDialect(String driver) {
        if (driver != null && driver.equals("org.hsqldb.jdbcDriver")) {
            return "org.hibernate.dialect.HSQLDialect";
        }
        if (driver != null && driver.equals("com.mysql.jdbc.Driver")) {
            return "play.db.jpa.MySQLDialect";
        }
        String dialect = Play.configuration.getProperty("jpa.dialect");
        if (dialect != null) {
            return dialect;
        }
        throw new UnsupportedOperationException("I do not know which hibernate dialect to use with " + driver + ", use the property jpa.dialect in config file");
    }

    public static Boolean isFieldHasMappedByInAnnotation(Field field) {
        Boolean bool = Boolean.FALSE;
        ManyToMany annotation = field.getAnnotation(ManyToMany.class);
        if (annotation != null && annotation.mappedBy() != null) {
            bool = Boolean.TRUE;
        }
        return bool;
    }

    public static EntityManager iniateJPA() throws PropertyVetoException {
        String[] moreEntities;
        Properties p = Play.configuration;
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setDriverClass(p.getProperty("db.driver"));
        ds.setJdbcUrl(p.getProperty("db.url"));
        ds.setUser(p.getProperty("db.user"));
        ds.setPassword(p.getProperty("db.pass"));
        ds.setAcquireRetryAttempts(1);
        ds.setAcquireRetryDelay(0);
        ds.setCheckoutTimeout(Integer.parseInt(p.getProperty("db.pool.timeout", "5000")));
        ds.setBreakAfterAcquireFailure(true);
        ds.setMaxPoolSize(Integer.parseInt(p.getProperty("db.pool.maxSize", "30")));
        ds.setMinPoolSize(Integer.parseInt(p.getProperty("db.pool.minSize", "1")));
        ds.setTestConnectionOnCheckout(true);
        List classes = Play.classloader.getAnnotatedClasses(Entity.class);
        Ejb3Configuration cfg = new Ejb3Configuration();
        cfg.setDataSource((DataSource)ds);
        if (!Play.configuration.getProperty("jpa.ddl", "update").equals("none")) {
            cfg.setProperty("hibernate.hbm2ddl.auto", Play.configuration.getProperty("jpa.ddl", "update"));
        }
        cfg.setProperty("hibernate.dialect", YmlExtractorUtil.getDefaultDialect(Play.configuration.getProperty("jpa.dialect")));
        cfg.setProperty("javax.persistence.transaction", "RESOURCE_LOCAL");
        if (Play.configuration.getProperty("jpa.debugSQL", "false").equals("true")) {
            org.apache.log4j.Logger.getLogger((String)"org.hibernate.SQL").setLevel(Level.ALL);
        } else {
            org.apache.log4j.Logger.getLogger((String)"org.hibernate.SQL").setLevel(Level.OFF);
        }
        cfg.addProperties((Properties)Utils.Maps.filterMap((Map)Play.configuration, (String)"^hibernate\\..*"));
        try {
            Field field = cfg.getClass().getDeclaredField("overridenClassLoader");
            field.setAccessible(true);
            field.set(cfg, Play.classloader);
        }
        catch (Exception e) {
            Logger.error((Throwable)e, (String)"Error trying to override the hibernate classLoader (new hibernate version ???)", (Object[])new Object[0]);
        }
        for (Class clazz : classes) {
            if (!clazz.isAnnotationPresent(Entity.class)) continue;
            cfg.addAnnotatedClass(clazz);
            Logger.trace((String)"JPA Model : %s", (Object[])new Object[]{clazz});
        }
        for (String entity : moreEntities = Play.configuration.getProperty("jpa.entities", "").split(", ")) {
            if (entity.trim().equals("")) continue;
            try {
                cfg.addAnnotatedClass(Play.classloader.loadClass(entity));
            }
            catch (Exception e) {
                Logger.warn((String)"JPA -> Entity not found: %s", (Object[])new Object[]{entity});
            }
        }
        Logger.trace((String)"Initializing JPA ...", (Object[])new Object[0]);
        EntityManagerFactory entityManagerFactory = cfg.buildEntityManagerFactory();
        return entityManagerFactory.createEntityManager();
    }
}

