/*
 * Decompiled with CFR 0.152.
 */
package play.modules.yml;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import play.Play;
import play.db.jpa.JPABase;
import play.modules.yml.YmlExtractorUtil;
import play.modules.yml.models.YmlObject;

public class YmlExtractor {
    public static Map<String, YmlObject> ymlObjects = Collections.synchronizedMap(new HashMap());

    public static void main(String[] args) throws Exception {
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        String filename = "data";
        String output = "conf/";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--")) continue;
            if (args[i].startsWith("--filename=")) {
                filename = args[i].substring(11);
            }
            if (!args[i].startsWith("--output=")) continue;
            output = args[i].substring(9);
        }
        YmlExtractor.mainWork(filename, output);
    }

    public static void mainWork(String filename, String output) throws Exception {
        EntityManager em = YmlExtractorUtil.iniateJPA();
        List entities = Play.classloader.getAnnotatedClasses(Entity.class);
        for (Class entity : entities) {
            List objects = em.createQuery("SELECT E FROM " + entity.getSimpleName() + " E").getResultList();
            for (JPABase jpaBase : objects) {
                YmlObject ymlObject = YmlExtractorUtil.object2YmlObject(jpaBase);
                ymlObjects.put(YmlExtractorUtil.getObjectId(jpaBase), ymlObject);
            }
        }
        YmlExtractorUtil.writeYml(output, filename);
    }
}

