/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api;

import com.cloudbees.api.BeesClientConfiguration;
import com.cloudbees.api.HttpClientHelper;
import com.cloudbees.api.UploadProgress;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpMethodParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeesClientBase {
    Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    protected String format = "xml";
    private String serverApiUrl = "http://localhost:8080/api";
    private String api_key;
    private String secret;
    private String version = "1.0";
    private String sigVersion = "1";
    private boolean verbose = true;
    private BeesClientConfiguration beesClientConfiguration;

    public BeesClientBase(BeesClientConfiguration beesClientConfiguration) {
        if (beesClientConfiguration == null) {
            throw new IllegalArgumentException("BeesClientConfiguration cannot be null");
        }
        this.beesClientConfiguration = beesClientConfiguration;
        if (beesClientConfiguration.getServerApiUrl() != null) {
            this.serverApiUrl = beesClientConfiguration.getServerApiUrl();
        }
        if (beesClientConfiguration.getApiKey() != null) {
            this.api_key = beesClientConfiguration.getApiKey();
        }
        if (beesClientConfiguration.getSecret() != null) {
            this.secret = beesClientConfiguration.getSecret();
        }
        if (beesClientConfiguration.getFormat() != null) {
            this.format = beesClientConfiguration.getFormat();
        }
        if (beesClientConfiguration.getVersion() != null) {
            this.version = beesClientConfiguration.getVersion();
        }
    }

    public BeesClientBase(String serverApiUrl, String apiKey, String secret, String format, String version) {
        this(new BeesClientConfiguration(serverApiUrl, apiKey, secret, format, version));
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getRequestURL(String method, Map<String, String> methodParams) throws Exception {
        return this.getRequestURL(method, methodParams, true);
    }

    public String getRequestURL(String method, Map<String, String> methodParams, boolean asActionParam) throws Exception {
        HashMap<String, String> urlParams = this.getDefaultParameters();
        StringBuilder requestURL = this.getApiUrl(asActionParam ? null : method);
        requestURL.append("?");
        for (Map.Entry<String, String> entry : methodParams.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            urlParams.put(key, value);
        }
        if (asActionParam) {
            urlParams.put("action", method);
        }
        String signature = this.calculateSignature(urlParams);
        Iterator<Map.Entry<String, String>> it = urlParams.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (i > 0) {
                requestURL.append("&");
            }
            requestURL.append(URLEncoder.encode(key, "UTF-8"));
            requestURL.append("=");
            requestURL.append(URLEncoder.encode(value, "UTF-8"));
            ++i;
        }
        requestURL.append("&");
        requestURL.append("sig");
        requestURL.append("=");
        requestURL.append(signature);
        return requestURL.toString();
    }

    private String calculateSignature(Map<String, String> entries) throws Exception {
        StringBuilder sigData = new StringBuilder();
        ArrayList<Map.Entry<String, String>> sortedParams = new ArrayList<Map.Entry<String, String>>(entries.entrySet());
        Collections.sort(sortedParams, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                return e1.getKey().compareTo(e2.getKey());
            }
        });
        for (Map.Entry<String, String> entry : sortedParams) {
            String key = entry.getKey();
            String value = entry.getValue();
            sigData.append(key);
            sigData.append(value);
        }
        String signature = BeesClientBase.getSignature(sigData.toString(), this.secret);
        return signature;
    }

    protected StringBuilder getApiUrl(String method) {
        StringBuilder requestURL = new StringBuilder();
        requestURL.append(this.serverApiUrl);
        if (method != null) {
            requestURL.append("/");
            requestURL.append(method);
        }
        return requestURL;
    }

    private HashMap<String, String> getDefaultParameters() {
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("format", this.format);
        urlParams.put("v", this.version);
        urlParams.put("api_key", this.api_key);
        urlParams.put("timestamp", new Long(System.currentTimeMillis() / 1000L).toString());
        urlParams.put("sig_version", this.sigVersion);
        return urlParams;
    }

    public static String getSignature(String data, String secret) throws Exception {
        String s = data + secret;
        String sig = BeesClientBase.md5(s);
        return sig;
    }

    public static String md5(String message) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] md5Bytes = md5.digest(message.getBytes("CP1252"));
            StringBuffer hex = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                hex.append(Integer.toHexString(md5Bytes[i] & 0xFF | 0x100).substring(1, 3));
            }
            return hex.toString();
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public String executeRequest(String url) throws Exception {
        HttpClient httpClient = HttpClientHelper.createClient(this.beesClientConfiguration);
        GetMethod getMethod = new GetMethod(url);
        httpClient.executeMethod((HttpMethod)getMethod);
        return this.getResponseString(getMethod.getResponseBodyAsStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponseString(InputStream ins) throws IOException {
        StringBuffer response = new StringBuffer();
        try {
            InputStreamReader isr = new InputStreamReader(ins);
            char[] chars = new char[1024];
            int numRead = isr.read(chars, 0, chars.length);
            while (numRead != -1) {
                response.append(new String(chars, 0, numRead));
                numRead = isr.read(chars, 0, chars.length);
            }
        }
        finally {
            ins.close();
        }
        return response.toString();
    }

    public InputStream executeCometRequest(String url) throws Exception {
        HttpClient httpClient = HttpClientHelper.createClient(this.beesClientConfiguration);
        HttpClientParams params = httpClient.getParams();
        params.setIntParameter("http.socket.timeout", 0);
        GetMethod getMethod = new GetMethod(url);
        httpClient.executeMethod((HttpMethod)getMethod);
        return getMethod.getResponseBodyAsStream();
    }

    protected void trace(String message) {
        if (this.verbose) {
            System.out.println(message);
        }
    }

    protected void traceResponse(String message) {
        if (this.verbose) {
            System.out.println("xml response: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeUpload(String uploadURL, Map<String, String> params, Map<String, File> files, UploadProgress writeListener) throws Exception {
        HashMap<String, String> clientParams = this.getDefaultParameters();
        clientParams.putAll(params);
        PostMethod filePost = new PostMethod(uploadURL);
        try {
            ArrayList<Object> parts = new ArrayList<Object>();
            int fileUploadSize = 0;
            for (Map.Entry<String, File> entry : files.entrySet()) {
                FilePart filePart = new FilePart(entry.getKey(), entry.getValue());
                parts.add(filePart);
                fileUploadSize = (int)((long)fileUploadSize + filePart.length());
            }
            for (Map.Entry<String, Object> entry : clientParams.entrySet()) {
                parts.add(new StringPart(entry.getKey(), (String)entry.getValue()));
            }
            String signature = this.calculateSignature(clientParams);
            parts.add(new StringPart("sig", signature));
            ProgressUploadEntity progressUploadEntity = new ProgressUploadEntity(parts.toArray(new Part[parts.size()]), filePost.getParams(), writeListener, fileUploadSize);
            filePost.setRequestEntity((RequestEntity)progressUploadEntity);
            HttpClient client = HttpClientHelper.createClient(this.beesClientConfiguration);
            client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
            int status = client.executeMethod((HttpMethod)filePost);
            String response = this.getResponseString(filePost.getResponseBodyAsStream());
            if (status == 200) {
                this.trace("upload complete, response=" + response);
            } else {
                this.trace("upload failed, response=" + HttpStatus.getStatusText((int)status));
            }
            String string = response;
            return string;
        }
        finally {
            filePost.releaseConnection();
        }
    }

    class WriteListenerOutputStream
    extends OutputStream {
        private OutputStream targetStream;
        private long bytesWritten;
        private boolean isClosed;
        private long bytesToSend;
        private UploadProgress writeListener;

        public WriteListenerOutputStream(OutputStream targetStream, UploadProgress writeListener, long length) {
            this.targetStream = targetStream;
            this.writeListener = writeListener;
            this.bytesToSend = length;
        }

        public void close() throws IOException {
            this.isClosed = true;
            this.targetStream.close();
        }

        public void flush() throws IOException {
            this.targetStream.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.targetStream.write(b, off, len);
            this.trackBytesWritten(len);
        }

        public void write(byte[] b) throws IOException {
            this.targetStream.write(b);
            this.trackBytesWritten(b.length);
        }

        public void write(int b) throws IOException {
            this.targetStream.write(b);
            this.trackBytesWritten(1L);
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        private void trackBytesWritten(long count) {
            this.bytesWritten += count;
            if (this.writeListener != null) {
                this.writeListener.handleBytesWritten(count, this.bytesWritten, this.bytesToSend);
            }
        }
    }

    class ProgressUploadEntity
    extends MultipartRequestEntity {
        private UploadProgress listener;
        long length;

        public ProgressUploadEntity(Part[] parts, HttpMethodParams params, UploadProgress listener, long length) {
            super(parts, params);
            this.listener = listener;
            this.length = length;
        }

        public void writeRequest(OutputStream out) throws IOException {
            WriteListenerOutputStream listenStream = new WriteListenerOutputStream(out, this.listener, this.length);
            super.writeRequest((OutputStream)listenStream);
        }
    }
}

