/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import jodd.JoddDefault;
import jodd.util.CharUtil;

public class StringOutputStream
extends OutputStream
implements Serializable {
    protected final StringBuilder sb = new StringBuilder();
    protected final String encoding;

    public StringOutputStream() {
        this(JoddDefault.encoding);
    }

    public StringOutputStream(String encoding) {
        this.encoding = encoding;
    }

    public String toString() {
        return this.sb.toString();
    }

    public void close() {
        this.sb.setLength(0);
    }

    public void write(byte[] b) throws IOException {
        this.sb.append(CharUtil.toCharArray(b, this.encoding));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("Parameters out of bounds.");
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = b[off];
            ++off;
        }
        this.sb.append(CharUtil.toCharArray(bytes, this.encoding));
    }

    public void write(int b) {
        this.sb.append((char)b);
    }
}

