/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jodd.io.FileNameUtil;
import jodd.io.StreamUtil;
import jodd.util.StringUtil;

public class ZipUtil {
    private static final String ZIP_EXT = ".zip";

    public static InputStream createFirstEntryInputStream(String zipFileName) throws IOException {
        return ZipUtil.createFirstEntryInputStream(new File(zipFileName));
    }

    public static InputStream createFirstEntryInputStream(File zipFile) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zf.entries();
        if (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            return zf.getInputStream(entry);
        }
        return null;
    }

    public static ZipOutputStream createSingleEntryOutputStream(String zipEntryFileName) throws IOException {
        return ZipUtil.createSingleEntryOutputStream(new File(zipEntryFileName));
    }

    public static ZipOutputStream createSingleEntryOutputStream(File zipEntryFile) throws IOException {
        String entryName = zipEntryFile.getName();
        if (entryName.endsWith(ZIP_EXT)) {
            entryName = entryName.substring(0, entryName.length() - ZIP_EXT.length());
        }
        return ZipUtil.createSingleEntryOutputStream(entryName, zipEntryFile);
    }

    public static ZipOutputStream createSingleEntryOutputStream(String entryName, String zipEntryFileName) throws IOException {
        return ZipUtil.createSingleEntryOutputStream(entryName, new File(zipEntryFileName));
    }

    public static ZipOutputStream createSingleEntryOutputStream(String entryName, File zipEntryFile) throws IOException {
        String zipFileName = zipEntryFile.getAbsolutePath();
        if (!zipFileName.endsWith(ZIP_EXT)) {
            zipFileName = zipFileName + ZIP_EXT;
        }
        FileOutputStream fos = new FileOutputStream(new File(zipFileName));
        ZipOutputStream zos = new ZipOutputStream(fos);
        ZipEntry ze = new ZipEntry(entryName);
        try {
            zos.putNextEntry(ze);
        }
        catch (IOException ioex) {
            StreamUtil.close(fos);
            throw ioex;
        }
        return zos;
    }

    public static ZipOutputStream createZip(File zip) throws FileNotFoundException {
        return new ZipOutputStream(new FileOutputStream(zip));
    }

    public static ZipOutputStream createZip(String zipFile) throws FileNotFoundException {
        return ZipUtil.createZip(new File(zipFile));
    }

    public static void unzip(String zipFile, String destDir) throws IOException {
        ZipUtil.unzip(new File(zipFile), new File(destDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destDir) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            File file;
            ZipEntry entry = en.nextElement();
            File file2 = file = destDir != null ? new File(destDir, entry.getName()) : new File(entry.getName());
            if (entry.isDirectory()) {
                if (file.mkdirs() || file.isDirectory()) continue;
                throw new IOException("Error creating directory: " + file);
            }
            File parent = file.getParentFile();
            if (!(parent == null || parent.exists() || parent.mkdirs() || file.isDirectory())) {
                throw new IOException("Error creating directory: " + parent);
            }
            InputStream in = zip.getInputStream(entry);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                StreamUtil.copy(in, (OutputStream)out);
            }
            catch (Throwable throwable) {
                StreamUtil.close(out);
                StreamUtil.close(in);
                throw throwable;
            }
            StreamUtil.close(out);
            StreamUtil.close(in);
        }
    }

    public static void addFileToZip(ZipOutputStream zos, File file, String relativeName) throws IOException {
        ZipUtil.addFileToZip(zos, file, relativeName, null);
    }

    public static void addFileToZip(ZipOutputStream zos, String fileName, String relativeName) throws IOException {
        ZipUtil.addFileToZip(zos, new File(fileName), relativeName, null);
    }

    public static void addFileToZip(ZipOutputStream zos, String fileName, String relativeName, String comment) throws IOException {
        ZipUtil.addFileToZip(zos, new File(fileName), relativeName, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileToZip(ZipOutputStream zos, File file, String relativeName, String comment) throws IOException {
        while (relativeName.length() != 0 && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        boolean isDir = file.isDirectory();
        if (isDir && !StringUtil.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        long size = isDir ? 0L : file.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(file.lastModified());
        e.setComment(comment);
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                StreamUtil.copy((InputStream)is, (OutputStream)zos);
            }
            finally {
                StreamUtil.close(is);
            }
        }
        zos.closeEntry();
    }

    public static void addDirToZip(ZipOutputStream out, String dirName) throws IOException {
        String path = FileNameUtil.getName(dirName);
        ZipUtil.addDirToZip(out, new File(dirName), path);
    }

    public static void addDirToZip(ZipOutputStream out, String dirName, String relativePath) throws IOException {
        ZipUtil.addDirToZip(out, new File(dirName), relativePath);
    }

    public static void addDirToZip(ZipOutputStream out, File dir) throws IOException {
        String path = FileNameUtil.getName(dir.getAbsolutePath());
        ZipUtil.addDirToZip(out, dir, path);
    }

    public static void addDirToZip(ZipOutputStream out, File dir, String relativePath) throws IOException {
        File[] children;
        boolean noRelativePath = StringUtil.isEmpty(relativePath);
        if (!noRelativePath) {
            ZipUtil.addFileToZip(out, dir, relativePath);
        }
        if ((children = dir.listFiles()) != null) {
            for (File child : children) {
                String childRelativePath = (noRelativePath ? "" : relativePath + '/') + child.getName();
                if (child.isDirectory()) {
                    ZipUtil.addDirToZip(out, child, childRelativePath);
                    continue;
                }
                ZipUtil.addFileToZip(out, child, childRelativePath);
            }
        }
    }

    public static void close(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

