/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.mail.MailException;

public abstract class EmailAttachment {
    protected final String name;
    protected final String contentId;
    protected int size = -1;

    protected EmailAttachment(String name, String contentId) {
        this.name = name;
        this.contentId = contentId;
    }

    public String getName() {
        return this.name;
    }

    public String getContentId() {
        return this.contentId;
    }

    public boolean isInline() {
        return this.contentId != null;
    }

    public abstract DataSource getDataSource();

    public int getSize() {
        return this.size;
    }

    protected void setSize(int size) {
        this.size = size;
    }

    public byte[] toByteArray() {
        FastByteArrayOutputStream out = this.size != -1 ? new FastByteArrayOutputStream(this.size) : new FastByteArrayOutputStream();
        this.writeToStream(out);
        return out.toByteArray();
    }

    public void writeToFile(File destination) {
        InputStream in = null;
        try {
            in = this.getDataSource().getInputStream();
            FileUtil.writeStream(destination, in);
        }
        catch (IOException ioex) {
            throw new MailException(ioex);
        }
        finally {
            StreamUtil.close(in);
        }
    }

    public void writeToStream(OutputStream out) {
        InputStream in = null;
        try {
            in = this.getDataSource().getInputStream();
            StreamUtil.copy(in, out);
        }
        catch (IOException ioex) {
            throw new MailException(ioex);
        }
        finally {
            StreamUtil.close(in);
        }
    }
}

