/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import jodd.datetime.JDateTime;
import jodd.mutable.MutableByte;
import jodd.mutable.MutableDouble;
import jodd.mutable.MutableFloat;
import jodd.mutable.MutableInteger;
import jodd.mutable.MutableLong;
import jodd.mutable.MutableShort;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.impl.BigDecimalConverter;
import jodd.typeconverter.impl.BigIntegerConverter;
import jodd.typeconverter.impl.BooleanArrayConverter;
import jodd.typeconverter.impl.BooleanConverter;
import jodd.typeconverter.impl.ByteArrayConverter;
import jodd.typeconverter.impl.ByteConverter;
import jodd.typeconverter.impl.CharacterConverter;
import jodd.typeconverter.impl.ClassArrayConverter;
import jodd.typeconverter.impl.ClassConverter;
import jodd.typeconverter.impl.DateConverter;
import jodd.typeconverter.impl.DoubleArrayConverter;
import jodd.typeconverter.impl.DoubleConverter;
import jodd.typeconverter.impl.FloatArrayConverter;
import jodd.typeconverter.impl.FloatConverter;
import jodd.typeconverter.impl.IntegerArrayConverter;
import jodd.typeconverter.impl.IntegerConverter;
import jodd.typeconverter.impl.JDateTimeConverter;
import jodd.typeconverter.impl.LongArrayConverter;
import jodd.typeconverter.impl.LongConverter;
import jodd.typeconverter.impl.MutableByteConverter;
import jodd.typeconverter.impl.MutableDoubleConverter;
import jodd.typeconverter.impl.MutableFloatConverter;
import jodd.typeconverter.impl.MutableIntegerConverter;
import jodd.typeconverter.impl.MutableLongConverter;
import jodd.typeconverter.impl.MutableShortConverter;
import jodd.typeconverter.impl.ShortArrayConverter;
import jodd.typeconverter.impl.ShortConverter;
import jodd.typeconverter.impl.StringArrayConverter;
import jodd.typeconverter.impl.StringConverter;
import jodd.typeconverter.impl.URIConverter;
import jodd.typeconverter.impl.URLConverter;

public class Convert {
    public static BigDecimal toBigDecimal(Object value) {
        return Convert.toBigDecimal(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return BigDecimalConverter.valueOf(value);
    }

    public static BigInteger toBigInteger(Object value) {
        return Convert.toBigInteger(value, null);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return BigIntegerConverter.valueOf(value);
    }

    public static boolean toBoolean(Object value) {
        return Convert.toBoolean(value, false);
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return BooleanConverter.valueOf(value);
    }

    public static Boolean toBoolean(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return BooleanConverter.valueOf(value);
    }

    public static boolean[] toBooleanArray(Object value) {
        return Convert.toBooleanArray(value, null);
    }

    public static boolean[] toBooleanArray(Object value, boolean[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return BooleanArrayConverter.valueOf(value);
    }

    public static byte toByte(Object value) {
        return Convert.toByte(value, (byte)0);
    }

    public static byte toByte(Object value, byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ByteConverter.valueOf(value);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ByteConverter.valueOf(value);
    }

    public static byte[] toByteArray(Object value) {
        return Convert.toByteArray(value, null);
    }

    public static byte[] toByteArray(Object value, byte[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ByteArrayConverter.valueOf(value);
    }

    public static char toCharacter(Object value) {
        return Convert.toCharacter(value, '\u0000');
    }

    public static char toCharacter(Object value, char defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return CharacterConverter.valueOf(value).charValue();
    }

    public static Character toCharacter(Object value, Character defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return CharacterConverter.valueOf(value);
    }

    public static Class toClass(Object value) {
        return Convert.toClass(value, null);
    }

    public static Class toClass(Object value, Class defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ClassConverter.valueOf(value);
    }

    public static Class[] toClassArray(Object value) {
        return Convert.toClassArray(value, null);
    }

    public static Class[] toClassArray(Object value, Class[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ClassArrayConverter.valueOf(value);
    }

    public static double toDouble(Object value) {
        return Convert.toDouble(value, 0.0);
    }

    public static double toDouble(Object value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return DoubleConverter.valueOf(value);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return DoubleConverter.valueOf(value);
    }

    public static double[] toDoubleArray(Object value) {
        return Convert.toDoubleArray(value, null);
    }

    public static double[] toDoubleArray(Object value, double[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return DoubleArrayConverter.valueOf(value);
    }

    public static float toFloat(Object value) {
        return Convert.toFloat(value, 0.0f);
    }

    public static float toFloat(Object value, float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return FloatConverter.valueOf(value).floatValue();
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return FloatConverter.valueOf(value);
    }

    public static float[] toFloatArray(Object value) {
        return Convert.toFloatArray(value, null);
    }

    public static float[] toFloatArray(Object value, float[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return FloatArrayConverter.valueOf(value);
    }

    public static int toInteger(Object value) {
        return Convert.toInteger(value, 0);
    }

    public static int toInteger(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return IntegerConverter.valueOf(value);
    }

    public static Integer toInteger(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return IntegerConverter.valueOf(value);
    }

    public static int[] toIntegerArray(Object value) {
        return Convert.toIntegerArray(value, null);
    }

    public static int[] toIntegerArray(Object value, int[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return IntegerArrayConverter.valueOf(value);
    }

    public static JDateTime toJDateTime(Object value) {
        return Convert.toJDateTime(value, null);
    }

    public static JDateTime toJDateTime(Object value, JDateTime defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return JDateTimeConverter.valueOf(value);
    }

    public static long toLong(Object value) {
        return Convert.toLong(value, 0L);
    }

    public static long toLong(Object value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return LongConverter.valueOf(value);
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return LongConverter.valueOf(value);
    }

    public static long[] toLongArray(Object value) {
        return Convert.toLongArray(value, null);
    }

    public static long[] toLongArray(Object value, long[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return LongArrayConverter.valueOf(value);
    }

    public static MutableByte toMutableByte(Object value) {
        return Convert.toMutableByte(value, null);
    }

    public static MutableByte toMutableByte(Object value, MutableByte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return MutableByteConverter.valueOf(value);
    }

    public static MutableDouble toMutableDouble(Object value) {
        return Convert.toMutableDouble(value, null);
    }

    public static MutableDouble toMutableDouble(Object value, MutableDouble defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return MutableDoubleConverter.valueOf(value);
    }

    public static MutableFloat toMutableFloat(Object value) {
        return Convert.toMutableFloat(value, null);
    }

    public static MutableFloat toMutableFloat(Object value, MutableFloat defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return MutableFloatConverter.valueOf(value);
    }

    public static MutableInteger toMutableInteger(Object value) {
        return Convert.toMutableInteger(value, null);
    }

    public static MutableInteger toMutableInteger(Object value, MutableInteger defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return MutableIntegerConverter.valueOf(value);
    }

    public static MutableLong toMutableLong(Object value) {
        return Convert.toMutableLong(value, null);
    }

    public static MutableLong toMutableLong(Object value, MutableLong defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return MutableLongConverter.valueOf(value);
    }

    public static MutableShort toMutableShort(Object value) {
        return Convert.toMutableShort(value, null);
    }

    public static MutableShort toMutableShort(Object value, MutableShort defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return MutableShortConverter.valueOf(value);
    }

    public static short toShort(Object value) {
        return Convert.toShort(value, (short)0);
    }

    public static short toShort(Object value, short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ShortConverter.valueOf(value);
    }

    public static Short toShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ShortConverter.valueOf(value);
    }

    public static short[] toShortArray(Object value) {
        return Convert.toShortArray(value, null);
    }

    public static short[] toShortArray(Object value, short[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ShortArrayConverter.valueOf(value);
    }

    public static String toString(Object value) {
        return Convert.toString(value, null);
    }

    public static String toString(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return StringConverter.valueOf(value);
    }

    public static String[] toStringArray(Object value) {
        return Convert.toStringArray(value, null);
    }

    public static String[] toStringArray(Object value, String[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return StringArrayConverter.valueOf(value);
    }

    public static URI toURI(Object value) {
        return Convert.toURI(value, null);
    }

    public static URI toURI(Object value, URI defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return URIConverter.valueOf(value);
    }

    public static URL toURL(Object value) {
        return Convert.toURL(value, null);
    }

    public static URL toURL(Object value, URL defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return URLConverter.valueOf(value);
    }

    public static Date toDate(Object value) {
        return Convert.toDate(value, null);
    }

    public static Date toDate(Object value, Date defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return DateConverter.valueOf(value);
    }

    public static Object toObject(Object value, Class destinationType) {
        if (value == null) {
            return null;
        }
        TypeConverter converter = TypeConverterManager.lookup(destinationType);
        if (converter == null) {
            throw new TypeConversionException("Unable to convert value to type: '" + destinationType.getName() + "'.");
        }
        return converter.convert(value);
    }
}

