/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import jodd.datetime.JDateTime;
import jodd.mutable.MutableByte;
import jodd.mutable.MutableDouble;
import jodd.mutable.MutableFloat;
import jodd.mutable.MutableInteger;
import jodd.mutable.MutableLong;
import jodd.mutable.MutableShort;
import jodd.servlet.upload.FileUpload;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.impl.BigDecimalConverter;
import jodd.typeconverter.impl.BigIntegerConverter;
import jodd.typeconverter.impl.BooleanArrayConverter;
import jodd.typeconverter.impl.BooleanConverter;
import jodd.typeconverter.impl.ByteArrayConverter;
import jodd.typeconverter.impl.ByteConverter;
import jodd.typeconverter.impl.CalendarConverter;
import jodd.typeconverter.impl.CharacterConverter;
import jodd.typeconverter.impl.ClassArrayConverter;
import jodd.typeconverter.impl.ClassConverter;
import jodd.typeconverter.impl.DateConverter;
import jodd.typeconverter.impl.DoubleArrayConverter;
import jodd.typeconverter.impl.DoubleConverter;
import jodd.typeconverter.impl.FileConverter;
import jodd.typeconverter.impl.FileUploadConverter;
import jodd.typeconverter.impl.FloatArrayConverter;
import jodd.typeconverter.impl.FloatConverter;
import jodd.typeconverter.impl.IntegerArrayConverter;
import jodd.typeconverter.impl.IntegerConverter;
import jodd.typeconverter.impl.JDateTimeConverter;
import jodd.typeconverter.impl.LocaleConverter;
import jodd.typeconverter.impl.LongArrayConverter;
import jodd.typeconverter.impl.LongConverter;
import jodd.typeconverter.impl.MutableByteConverter;
import jodd.typeconverter.impl.MutableDoubleConverter;
import jodd.typeconverter.impl.MutableFloatConverter;
import jodd.typeconverter.impl.MutableIntegerConverter;
import jodd.typeconverter.impl.MutableLongConverter;
import jodd.typeconverter.impl.MutableShortConverter;
import jodd.typeconverter.impl.ShortArrayConverter;
import jodd.typeconverter.impl.ShortConverter;
import jodd.typeconverter.impl.SqlDateConverter;
import jodd.typeconverter.impl.SqlTimeConverter;
import jodd.typeconverter.impl.SqlTimestampConverter;
import jodd.typeconverter.impl.StringArrayConverter;
import jodd.typeconverter.impl.StringConverter;
import jodd.typeconverter.impl.URIConverter;
import jodd.typeconverter.impl.URLConverter;

public class TypeConverterManager {
    private static HashMap<Class, TypeConverter> converters = new HashMap(64);

    public static void unregisterAll() {
        converters.clear();
    }

    public static void registerDefaults() {
        TypeConverterManager.register(String.class, new StringConverter());
        TypeConverterManager.register(String[].class, new StringArrayConverter());
        IntegerConverter integerConverter = new IntegerConverter();
        TypeConverterManager.register(Integer.class, integerConverter);
        TypeConverterManager.register(Integer.TYPE, integerConverter);
        TypeConverterManager.register(MutableInteger.class, new MutableIntegerConverter());
        ShortConverter shortConverter = new ShortConverter();
        TypeConverterManager.register(Short.class, shortConverter);
        TypeConverterManager.register(Short.TYPE, shortConverter);
        TypeConverterManager.register(MutableShort.class, new MutableShortConverter());
        LongConverter longConverter = new LongConverter();
        TypeConverterManager.register(Long.class, longConverter);
        TypeConverterManager.register(Long.TYPE, longConverter);
        TypeConverterManager.register(MutableLong.class, new MutableLongConverter());
        ByteConverter byteConverter = new ByteConverter();
        TypeConverterManager.register(Byte.class, byteConverter);
        TypeConverterManager.register(Byte.TYPE, byteConverter);
        TypeConverterManager.register(MutableByte.class, new MutableByteConverter());
        FloatConverter floatConverter = new FloatConverter();
        TypeConverterManager.register(Float.class, floatConverter);
        TypeConverterManager.register(Float.TYPE, floatConverter);
        TypeConverterManager.register(MutableFloat.class, new MutableFloatConverter());
        DoubleConverter doubleConverter = new DoubleConverter();
        TypeConverterManager.register(Double.class, doubleConverter);
        TypeConverterManager.register(Double.TYPE, doubleConverter);
        TypeConverterManager.register(MutableDouble.class, new MutableDoubleConverter());
        BooleanConverter booleanConverter = new BooleanConverter();
        TypeConverterManager.register(Boolean.class, booleanConverter);
        TypeConverterManager.register(Boolean.TYPE, booleanConverter);
        CharacterConverter characterConverter = new CharacterConverter();
        TypeConverterManager.register(Character.class, characterConverter);
        TypeConverterManager.register(Character.TYPE, characterConverter);
        TypeConverterManager.register(byte[].class, new ByteArrayConverter());
        TypeConverterManager.register(short[].class, new ShortArrayConverter());
        TypeConverterManager.register(int[].class, new IntegerArrayConverter());
        TypeConverterManager.register(long[].class, new LongArrayConverter());
        TypeConverterManager.register(float[].class, new FloatArrayConverter());
        TypeConverterManager.register(double[].class, new DoubleArrayConverter());
        TypeConverterManager.register(boolean[].class, new BooleanArrayConverter());
        TypeConverterManager.register(BigDecimal.class, new BigDecimalConverter());
        TypeConverterManager.register(BigInteger.class, new BigIntegerConverter());
        TypeConverterManager.register(java.util.Date.class, new DateConverter());
        TypeConverterManager.register(Date.class, new SqlDateConverter());
        TypeConverterManager.register(Time.class, new SqlTimeConverter());
        TypeConverterManager.register(Timestamp.class, new SqlTimestampConverter());
        TypeConverterManager.register(Calendar.class, new CalendarConverter());
        TypeConverterManager.register(GregorianCalendar.class, new CalendarConverter());
        TypeConverterManager.register(JDateTime.class, new JDateTimeConverter());
        TypeConverterManager.register(FileUpload.class, new FileUploadConverter());
        TypeConverterManager.register(File.class, new FileConverter());
        TypeConverterManager.register(Class.class, new ClassConverter());
        TypeConverterManager.register(Class[].class, new ClassArrayConverter());
        TypeConverterManager.register(URI.class, new URIConverter());
        TypeConverterManager.register(URL.class, new URLConverter());
        TypeConverterManager.register(Locale.class, new LocaleConverter());
    }

    public static void register(Class type, TypeConverter typeConverter) {
        converters.put(type, typeConverter);
    }

    public static void unregister(Class type) {
        converters.remove(type);
    }

    public static TypeConverter lookup(Class type) {
        return converters.get(type);
    }

    static {
        TypeConverterManager.registerDefaults();
    }
}

