/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.impl.StringArrayConverter;
import jodd.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassArrayConverter
implements TypeConverter<Class[]> {
    public static Class[] valueOf(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == Class[].class) {
            return (Class[])value;
        }
        if (type == Class.class) {
            return new Class[]{(Class)value};
        }
        String[] allClassNames = StringArrayConverter.valueOf(value);
        int total = allClassNames.length;
        Class[] result = new Class[total];
        try {
            for (int i = 0; i < total; ++i) {
                result[i] = ClassLoaderUtil.loadClass(allClassNames[i].trim());
            }
        }
        catch (ClassNotFoundException cnfex) {
            throw new TypeConversionException(value, (Throwable)cnfex);
        }
        return result;
    }

    @Override
    public Class[] convert(Object value) {
        return ClassArrayConverter.valueOf(value);
    }
}

