/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArrayConverter
implements TypeConverter<double[]> {
    public static double[] valueOf(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (value instanceof Number) {
                return new double[]{((Number)value).doubleValue()};
            }
            try {
                return new double[]{Double.parseDouble(value.toString().trim())};
            }
            catch (NumberFormatException nfex) {
                throw new TypeConversionException(value, (Throwable)nfex);
            }
        }
        if (type == double[].class) {
            return (double[])value;
        }
        if (type == float[].class) {
            float[] values = (float[])value;
            double[] results = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == int[].class) {
            int[] values = (int[])value;
            double[] results = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == long[].class) {
            long[] values = (long[])value;
            double[] results = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == byte[].class) {
            byte[] values = (byte[])value;
            double[] results = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == boolean[].class) {
            boolean[] values = (boolean[])value;
            double[] results = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] ? 1 : 0;
            }
            return results;
        }
        if (type == short[].class) {
            short[] values = (short[])value;
            double[] results = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        Object[] values = (Object[])value;
        double[] results = new double[values.length];
        try {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                results[i] = values[i] instanceof Number ? ((Number)values[i]).doubleValue() : Double.parseDouble(values[i].toString().trim());
            }
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
        return results;
    }

    @Override
    public double[] convert(Object value) {
        return DoubleArrayConverter.valueOf(value);
    }
}

