/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArrayConverter
implements TypeConverter<float[]> {
    public static float[] valueOf(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (value instanceof Number) {
                return new float[]{((Number)value).floatValue()};
            }
            try {
                return new float[]{Float.parseFloat(value.toString().trim())};
            }
            catch (NumberFormatException nfex) {
                throw new TypeConversionException(value, (Throwable)nfex);
            }
        }
        if (type == float[].class) {
            return (float[])value;
        }
        if (type == double[].class) {
            double[] values = (double[])value;
            float[] results = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (float)values[i];
            }
            return results;
        }
        if (type == int[].class) {
            int[] values = (int[])value;
            float[] results = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == long[].class) {
            long[] values = (long[])value;
            float[] results = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == byte[].class) {
            byte[] values = (byte[])value;
            float[] results = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == boolean[].class) {
            boolean[] values = (boolean[])value;
            float[] results = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] ? 1 : 0;
            }
            return results;
        }
        if (type == short[].class) {
            short[] values = (short[])value;
            float[] results = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        Object[] values = (Object[])value;
        float[] results = new float[values.length];
        try {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                results[i] = values[i] instanceof Number ? ((Number)values[i]).floatValue() : Float.parseFloat(values[i].toString().trim());
            }
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
        return results;
    }

    @Override
    public float[] convert(Object value) {
        return FloatArrayConverter.valueOf(value);
    }
}

