/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayConverter
implements TypeConverter<long[]> {
    public static long[] valueOf(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (value instanceof Number) {
                return new long[]{((Number)value).longValue()};
            }
            String[] values = CsvUtil.toStringArray(value.toString());
            long[] result = new long[values.length];
            try {
                int valuesLength = values.length;
                for (int i = 0; i < valuesLength; ++i) {
                    result[i] = Long.parseLong(values[i].trim());
                }
            }
            catch (NumberFormatException nfex) {
                throw new TypeConversionException(value, (Throwable)nfex);
            }
            return result;
        }
        if (type == long[].class) {
            return (long[])value;
        }
        if (type == int[].class) {
            int[] values = (int[])value;
            long[] results = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == double[].class) {
            double[] values = (double[])value;
            long[] results = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (long)values[i];
            }
            return results;
        }
        if (type == byte[].class) {
            byte[] values = (byte[])value;
            long[] results = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        if (type == float[].class) {
            float[] values = (float[])value;
            long[] results = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = (long)values[i];
            }
            return results;
        }
        if (type == boolean[].class) {
            boolean[] values = (boolean[])value;
            long[] results = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i] ? 1L : 0L;
            }
            return results;
        }
        if (type == short[].class) {
            short[] values = (short[])value;
            long[] results = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                results[i] = values[i];
            }
            return results;
        }
        Object[] values = (Object[])value;
        long[] results = new long[values.length];
        try {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                results[i] = values[i] instanceof Number ? ((Number)values[i]).longValue() : Long.parseLong(values[i].toString().trim());
            }
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
        return results;
    }

    @Override
    public long[] convert(Object value) {
        return LongArrayConverter.valueOf(value);
    }
}

