/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.sql.Clob;
import java.sql.SQLException;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverter
implements TypeConverter<String> {
    public static String valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        Class<?> type = value.getClass();
        if (type == Class.class) {
            return ((Class)value).getName();
        }
        if (type.isArray()) {
            if (type == byte[].class) {
                byte[] valueArray = (byte[])value;
                return new String(valueArray, 0, valueArray.length);
            }
            if (type == char[].class) {
                char[] charArray = (char[])value;
                return new String(charArray);
            }
            return CsvUtil.toCsvString((Object[])value);
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                long length = clob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new TypeConversionException("Clob is too big.");
                }
                return clob.getSubString(1L, (int)length);
            }
            catch (SQLException sex) {
                throw new TypeConversionException(value, (Throwable)sex);
            }
        }
        return value.toString();
    }

    @Override
    public String convert(Object value) {
        return StringConverter.valueOf(value);
    }
}

