/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.collection;

public class FastFloatBuffer {
    private float[][] buffers = new float[16][];
    private int buffersCount = 0;
    private int currentBufferIndex = -1;
    private float[] currentBuffer;
    private int offset;
    private int count;

    public FastFloatBuffer() {
        this(1024);
    }

    public FastFloatBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.needNewBuffer(size);
    }

    private void needNewBuffer(int newCount) {
        if (this.currentBufferIndex < this.buffersCount - 1) {
            this.offset = 0;
            ++this.currentBufferIndex;
            this.currentBuffer = this.buffers[this.currentBufferIndex];
        } else {
            int newBufferSize = this.currentBuffer == null ? newCount : Math.max(this.currentBuffer.length << 1, newCount - this.count);
            ++this.currentBufferIndex;
            this.currentBuffer = new float[newBufferSize];
            this.offset = 0;
            if (this.currentBufferIndex >= this.buffers.length) {
                int newLen = this.buffers.length << 1;
                float[][] newBuffers = new float[newLen][];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                this.buffers = newBuffers;
            }
            this.buffers[this.currentBufferIndex] = this.currentBuffer;
            ++this.buffersCount;
        }
    }

    public FastFloatBuffer append(float[] b, int off, int len) {
        int end = off + len;
        if (off < 0 || off > b.length || len < 0 || end > b.length || end < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        int newCount = this.count + len;
        int remaining = len;
        while (remaining > 0) {
            int part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(b, end - remaining, this.currentBuffer, this.offset, part);
            this.offset += part;
            this.count += part;
            if ((remaining -= part) <= 0) continue;
            this.needNewBuffer(newCount);
        }
        return this;
    }

    public FastFloatBuffer append(float[] b) {
        return this.append(b, 0, b.length);
    }

    public FastFloatBuffer append(float value) {
        if (this.offset == this.currentBuffer.length) {
            this.needNewBuffer(this.count + 1);
        }
        this.currentBuffer[this.offset] = value;
        ++this.offset;
        ++this.count;
        return this;
    }

    public int size() {
        return this.count;
    }

    public int index() {
        return this.currentBufferIndex;
    }

    public int offset() {
        return this.offset;
    }

    public float[] array(int index) {
        return this.buffers[index];
    }

    public void reset() {
        this.count = 0;
        this.offset = 0;
        this.currentBufferIndex = 0;
        this.currentBuffer = this.buffers[this.currentBufferIndex];
        this.buffersCount = 1;
    }

    public float[] toArray() {
        int remaining = this.count;
        int pos = 0;
        float[] array = new float[this.count];
        for (float[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            System.arraycopy(buf, 0, array, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
        }
        return array;
    }
}

