/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.idgen;

public class SimpleIdGenerator {
    protected volatile int value;
    protected int initialValue;
    protected int maxValue;
    protected boolean cycle;

    public SimpleIdGenerator() {
        this(1, Integer.MAX_VALUE, true);
    }

    public SimpleIdGenerator(int initialValue) {
        this(initialValue, Integer.MAX_VALUE, true);
    }

    public SimpleIdGenerator(int initialValue, int maxValue) {
        this(initialValue, maxValue, true);
    }

    public SimpleIdGenerator(int initialValue, int maxValue, boolean cycle) {
        if (initialValue < 0) {
            throw new IllegalArgumentException("Initial value must be positive: " + initialValue);
        }
        if (maxValue <= initialValue) {
            throw new IllegalArgumentException("Max value: " + maxValue + " <= initial value: " + initialValue);
        }
        this.initialValue = this.value = initialValue;
        this.maxValue = maxValue;
        this.cycle = cycle;
    }

    public synchronized int next() {
        int id = this.value++;
        if (this.value > this.maxValue || this.value < 0) {
            if (!this.cycle) {
                throw new IllegalStateException("Max value already reached.");
            }
            this.value = this.initialValue;
        }
        return id;
    }
}

