/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.idgen;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class Uuid32Generator {
    private static final String ZEROS = "000000000000";

    public static String generateUUID() {
        return new Uuid32Generator().generate();
    }

    public String generate() {
        StringBuilder strRetVal = new StringBuilder();
        try {
            String strTemp;
            byte[] ipaddr;
            InetAddress addr = InetAddress.getLocalHost();
            for (byte anIpaddr : ipaddr = addr.getAddress()) {
                Byte b = anIpaddr;
                strTemp = Integer.toHexString(b.intValue() & 0xFF);
                strRetVal.append(ZEROS.substring(0, 2 - strTemp.length()));
                strRetVal.append(strTemp);
            }
            strRetVal.append(':');
            strTemp = Long.toHexString(System.currentTimeMillis());
            strRetVal.append(ZEROS.substring(0, 12 - strTemp.length()));
            strRetVal.append(strTemp).append(':');
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            strTemp = Integer.toHexString(prng.nextInt());
            while (strTemp.length() < 8) {
                strTemp = '0' + strTemp;
            }
            strRetVal.append(strTemp.substring(4)).append(':');
            strTemp = Long.toHexString(System.identityHashCode(this));
            strRetVal.append(ZEROS.substring(0, 8 - strTemp.length()));
            strRetVal.append(strTemp);
        }
        catch (UnknownHostException uhex) {
            throw new RuntimeException("Unknown host.", uhex);
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new RuntimeException("Algorithm 'SHA1PRNG' is unavailable.", nsaex);
        }
        return strRetVal.toString().toUpperCase();
    }
}

