/*
 * Decompiled with CFR 0.152.
 */
package play.modules.yml;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import play.Logger;
import play.Play;
import play.db.DBPlugin;
import play.db.jpa.JPA;
import play.db.jpa.JPABase;
import play.db.jpa.JPAPlugin;
import play.modules.yml.YmlExtractorUtil;
import play.modules.yml.models.YmlObject;

public class YmlExtractor {
    public static Map<String, YmlObject> ymlObjects = Collections.synchronizedMap(new HashMap());

    public static void main(String[] args) throws Exception {
        String filename = "data";
        String output = "conf/";
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--")) continue;
            if (args[i].startsWith("--filename=")) {
                filename = args[i].substring(11);
            }
            if (!args[i].startsWith("--output=")) continue;
            output = args[i].substring(9);
        }
        File root = new File(System.getProperty("application.path"));
        Play.init((File)root, (String)System.getProperty("play.id", ""));
        Thread.currentThread().setContextClassLoader((ClassLoader)Play.classloader);
        Class c = Play.classloader.loadClass("play.modules.yml.YmlExtractor");
        Method m = c.getMethod("mainWork", String.class, String.class);
        m.invoke(c.newInstance(), filename, output);
        System.exit(0);
    }

    public static void mainWork(String filename, String output) throws Exception {
        new DBPlugin().onApplicationStart();
        new JPAPlugin().onApplicationStart();
        JPAPlugin.startTx((boolean)true);
        List entities = Play.classloader.getAnnotatedClasses(Entity.class);
        for (Class entity : entities) {
            List objects = JPA.em().createQuery("SELECT E FROM " + entity.getSimpleName() + " E").getResultList();
            for (JPABase jpaBase : objects) {
                YmlObject ymlObject = YmlExtractorUtil.object2YmlObject(jpaBase);
                ymlObjects.put(YmlExtractorUtil.getObjectId(jpaBase), ymlObject);
            }
        }
        JPAPlugin.closeTx((boolean)false);
        YmlExtractorUtil.writeYml(output, filename);
        Logger.info((String)"*****************************************************************************", (Object[])new Object[0]);
        Logger.info((String)("* Ending export yml process into file " + output + filename + ".yml"), (Object[])new Object[0]);
        Logger.info((String)"*****************************************************************************", (Object[])new Object[0]);
    }
}

